/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.conf;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.slide.util.conf.AbstractConfiguration;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public class ConfigurationImpl
extends AbstractConfiguration {
    private Hashtable attributes = new Hashtable();
    private Hashtable children = new Hashtable();
    private String name = null;
    private String value = null;

    protected ConfigurationImpl() {
    }

    protected ConfigurationImpl(String name) {
        this.name = name;
    }

    protected ConfigurationImpl(String name, String source, int line) {
        super(source, line);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() throws ConfigurationException {
        if (this.value != null) {
            return this.value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\"", this);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value = (String)this.attributes.get(name);
        if (value != null) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\"", this);
    }

    public Configuration getConfiguration(String name) {
        Vector v = (Vector)this.children.get(name);
        if (v != null && v.size() > 0) {
            return (Configuration)v.firstElement();
        }
        return null;
    }

    public Enumeration getConfigurations(String name) {
        Vector v = (Vector)this.children.get(name);
        if (v == null) {
            return new EmptyEnumerationImpl();
        }
        return v.elements();
    }

    protected void appendValueData(String value) {
        this.value = this.value == null ? value : this.value + value;
    }

    protected String addAttribute(String name, String value) {
        return this.attributes.put(name, value);
    }

    public void addConfiguration(Configuration conf) {
        String name = conf.getName();
        Vector<Configuration> v = (Vector<Configuration>)this.children.get(name);
        if (v == null) {
            v = new Vector<Configuration>();
            this.children.put(name, v);
        }
        v.addElement(conf);
    }

    private class EmptyEnumerationImpl
    implements Enumeration {
        private EmptyEnumerationImpl() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

