/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;

public class JobStoreTX
extends JobStoreSupport {
    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        super.initialize(loadHelper, signaler);
        this.getLog().info((Object)"JobStoreTX initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void recoverJobs() throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.recoverJobs(conn);
        this.commitConnection(conn);
        Object var5_3 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.cleanVolatileTriggerAndJobs(conn);
        this.commitConnection(conn);
        Object var5_3 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        if (this.isLockOnInsert()) {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
        }
        if (newJob.isVolatile() && !newTrigger.isVolatile()) {
            JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
            jpe.setErrorCode(100);
            throw jpe;
        }
        this.storeJob(conn, ctxt, newJob, false);
        this.storeTrigger(conn, ctxt, newTrigger, newJob, false, "WAITING", false, false);
        this.commitConnection(conn);
        Object var8_8 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        if (this.isLockOnInsert() || replaceExisting) {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
        }
        this.storeJob(conn, ctxt, newJob, replaceExisting);
        this.commitConnection(conn);
        Object var8_6 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        boolean removed = this.removeJob(conn, ctxt, jobName, groupName, true);
        this.commitConnection(conn);
        boolean bl = removed;
        Object var9_9 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return bl;
        catch (JobPersistenceException e) {
            try {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable;
            }
        }
    }

    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            JobDetail job = this.retrieveJob(conn, ctxt, jobName, groupName);
            this.commitConnection(conn);
            JobDetail jobDetail = job;
            return jobDetail;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        if (this.isLockOnInsert() || replaceExisting) {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            transOwner = true;
        }
        this.storeTrigger(conn, ctxt, newTrigger, null, replaceExisting, "WAITING", false, false);
        this.commitConnection(conn);
        Object var8_6 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        boolean removed = this.removeTrigger(conn, ctxt, triggerName, groupName);
        this.commitConnection(conn);
        boolean bl = removed;
        Object var9_9 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return bl;
        catch (JobPersistenceException e) {
            try {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        boolean removed = this.replaceTrigger(conn, ctxt, triggerName, groupName, newTrigger);
        this.commitConnection(conn);
        boolean bl = removed;
        Object var10_10 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return bl;
        catch (JobPersistenceException e) {
            try {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable;
            }
        }
    }

    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Trigger trigger = this.retrieveTrigger(conn, ctxt, triggerName, groupName);
            this.commitConnection(conn);
            Trigger trigger2 = trigger;
            return trigger2;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void storeCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean lockOwner = false;
        if (this.isLockOnInsert() || updateTriggers) {
            this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
            lockOwner = true;
        }
        this.storeCalendar(conn, ctxt, calName, calendar, replaceExisting, updateTriggers);
        this.commitConnection(conn);
        Object var10_8 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean lockOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        lockOwner = true;
        boolean removed = this.removeCalendar(conn, ctxt, calName);
        this.commitConnection(conn);
        boolean bl = removed;
        Object var8_8 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return bl;
        catch (JobPersistenceException e) {
            try {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    this.releaseLock(conn, LOCK_TRIGGER_ACCESS, lockOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable;
            }
        }
    }

    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Calendar cal = this.retrieveCalendar(conn, ctxt, calName);
            this.commitConnection(conn);
            Calendar calendar = cal;
            return calendar;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int getNumberOfJobs(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int numJobs = this.getNumberOfJobs(conn, ctxt);
            this.commitConnection(conn);
            int n = numJobs;
            return n;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int getNumberOfTriggers(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int numTriggers = this.getNumberOfTriggers(conn, ctxt);
            this.commitConnection(conn);
            int n = numTriggers;
            return n;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int getNumberOfCalendars(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int numCals = this.getNumberOfCalendars(conn, ctxt);
            this.commitConnection(conn);
            int n = numCals;
            return n;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Set groups = this.getPausedTriggerGroups(conn, ctxt);
            this.commitConnection(conn);
            Set set = groups;
            return set;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] jobNames = this.getJobNames(conn, ctxt, groupName);
            this.commitConnection(conn);
            String[] stringArray = jobNames;
            return stringArray;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] triggerNames = this.getTriggerNames(conn, ctxt, groupName);
            this.commitConnection(conn);
            String[] stringArray = triggerNames;
            return stringArray;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public String[] getJobGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] groupNames = this.getJobGroupNames(conn, ctxt);
            this.commitConnection(conn);
            String[] stringArray = groupNames;
            return stringArray;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] triggerGroups = this.getTriggerGroupNames(conn, ctxt);
            this.commitConnection(conn);
            String[] stringArray = triggerGroups;
            return stringArray;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public String[] getCalendarNames(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            String[] calNames = this.getCalendarNames(conn, ctxt);
            this.commitConnection(conn);
            String[] stringArray = calNames;
            return stringArray;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Trigger[] triggerArray = this.getTriggersForJob(conn, ctxt, jobName, groupName);
            return triggerArray;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getTriggerState(conn, ctxt, triggerName, groupName);
            return n;
        }
        catch (JobPersistenceException e) {
            this.rollbackConnection(conn);
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.pauseTrigger(conn, ctxt, triggerName, groupName);
        this.commitConnection(conn);
        Object var8_6 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.pauseTriggerGroup(conn, ctxt, groupName);
        this.commitConnection(conn);
        Object var7_5 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
        for (int j = 0; j < triggers.length; ++j) {
            this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
        }
        this.commitConnection(conn);
        Object var9_9 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        String[] jobNames = this.getJobNames(conn, ctxt, groupName);
        for (int i = 0; i < jobNames.length; ++i) {
            Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
            }
        }
        this.commitConnection(conn);
        Object var10_10 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.resumeTrigger(conn, ctxt, triggerName, groupName);
        this.commitConnection(conn);
        Object var8_6 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.resumeTriggerGroup(conn, ctxt, groupName);
        this.commitConnection(conn);
        Object var7_5 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
        for (int j = 0; j < triggers.length; ++j) {
            this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
        }
        this.commitConnection(conn);
        Object var9_9 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        String[] jobNames = this.getJobNames(conn, ctxt, groupName);
        for (int i = 0; i < jobNames.length; ++i) {
            Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
            for (int j = 0; j < triggers.length; ++j) {
                this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
            }
        }
        this.commitConnection(conn);
        Object var10_10 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void pauseAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.pauseAll(conn, ctxt);
        this.commitConnection(conn);
        Object var6_4 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void resumeAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.resumeAll(conn, ctxt);
        this.commitConnection(conn);
        Object var6_4 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Trigger acquireNextTrigger(SchedulingContext ctxt, long noLaterThan) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        Trigger trigger = this.acquireNextTrigger(conn, ctxt, noLaterThan);
        this.commitConnection(conn);
        Trigger trigger2 = trigger;
        Object var9_8 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return trigger2;
        catch (JobPersistenceException e) {
            try {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.releaseAcquiredTrigger(conn, ctxt, trigger);
        this.commitConnection(conn);
        Object var7_5 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        TriggerFiredBundle tfb = null;
        JobPersistenceException err = null;
        try {
            tfb = this.triggerFired(conn, ctxt, trigger);
        }
        catch (JobPersistenceException jpe) {
            if (jpe.getErrorCode() != 410) {
                throw jpe;
            }
            err = jpe;
        }
        this.commitConnection(conn);
        if (err != null) {
            throw err;
        }
        TriggerFiredBundle triggerFiredBundle = tfb;
        Object var9_10 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return triggerFiredBundle;
        catch (JobPersistenceException e) {
            try {
                this.rollbackConnection(conn);
                throw e;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        this.triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
        this.commitConnection(conn);
        Object var9_7 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean doRecoverMisfires() throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        boolean moreToDo = false;
        this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
        transOwner = true;
        try {
            moreToDo = this.recoverMisfiredJobs(conn, false);
        }
        catch (Exception e) {
            throw new JobPersistenceException(e.getMessage(), e);
        }
        this.commitConnection(conn);
        boolean e = moreToDo;
        Object var6_7 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        return e;
        catch (JobPersistenceException e2) {
            try {
                this.rollbackConnection(conn);
                throw e2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean doCheckin() throws JobPersistenceException {
        List failedRecords;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        boolean transStateOwner = false;
        boolean recovered = false;
        List list = failedRecords = this.firstCheckIn ? null : this.clusterCheckIn(conn);
        if (this.firstCheckIn || failedRecords.size() > 0) {
            this.getLockHandler().obtainLock(conn, LOCK_STATE_ACCESS);
            transStateOwner = true;
            List list2 = failedRecords = this.firstCheckIn ? this.clusterCheckIn(conn) : this.findFailedInstances(conn);
            if (failedRecords.size() > 0) {
                this.getLockHandler().obtainLock(conn, LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.clusterRecover(conn, failedRecords);
                recovered = true;
            }
        }
        this.commitConnection(conn);
        Object var7_7 = null;
        try {
            this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        try {
            this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
        }
        finally {
            this.closeConnection(conn);
        }
        {
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                this.releaseLock(conn, LOCK_TRIGGER_ACCESS, transOwner);
                Object var9_11 = null;
            }
            catch (Throwable throwable2) {
                Object var9_12 = null;
                try {
                    this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
                }
                finally {
                    this.closeConnection(conn);
                }
                throw throwable2;
            }
            try {
                this.releaseLock(conn, LOCK_STATE_ACCESS, transStateOwner);
            }
            finally {
                this.closeConnection(conn);
            }
            throw throwable;
        }
        this.firstCheckIn = false;
        return recovered;
    }
}

