/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.skife.jdbi.Configuration;
import org.skife.jdbi.ConnectionFactory;
import org.skife.jdbi.DBIError;
import org.skife.jdbi.tweak.ClasspathStatementLocator;
import org.skife.jdbi.tweak.StatementLocator;
import org.skife.jdbi.tweak.TransactionHandler;
import org.skife.jdbi.unstable.decorator.HandleDecorator;

class AutoConfigurator {
    private static final String SYSTEM_PROPERTY_NAME_OVERRIDE = "org.skife.jdbi.properties-file";
    private static final String[] PROPERTIES_FILE_NAMES = new String[]{System.getProperty("org.skife.jdbi.properties-file") != null ? System.getProperty("org.skife.jdbi.properties-file") : "No Such Property Name, Thank You Very Much, Please Try Another", "jdbi.properties", "jdbc.properties", "dbi.properties", "database.properties"};
    private static final String[] JDBC_URL_PROPS = new String[]{"jdbi.url", "jdbc.url", "connection.string"};
    private static final String[] DRIVER_NAME_PROPS = new String[]{"jdbi.driver", "jdbc.driver", "driver", "jdbc.drive"};
    private static final String[] USERNAME_PROPS = new String[]{"jdbi.username", "jdbi.user", "jdbc.username", "jdbc.user", "username", "user"};
    private static final String[] PASSWORD_PROPS = new String[]{"jdbi.password", "jdbi.pass", "jdbc.password", "jdbc.pass", "pass", "password"};
    private static final String[] HANDLE_DECORATOR_BUIDLER = new String[]{"jdbi.handle-decorator-builder", "jdbc.handle-decorator-builder", "handle-decorator-builder"};
    private static final String[] TRANSACTION_HANDLER = new String[]{"jdbi.transaction-handler", "jdbc.transaction-handler", "transaction-handler"};
    private static final String[] STATEMENT_LOCATOR = new String[]{"jdbi.statement-locator", "jdbc.statement-locator", "statement-locator"};
    private static ConnectionFactory factory = null;
    private static String handleDecoratorBuilder = null;
    private static String transactionHandler = null;
    private static String statementLocator = null;

    AutoConfigurator() {
    }

    ConnectionFactory getConnectionFactory() throws IOException {
        if (factory != null) {
            return factory;
        }
        Configuration config = this.configure();
        config.validate();
        final String conn = config.getUrl();
        String driver = config.getDriver();
        final String user = config.getUsername();
        final String pass = config.getPassword();
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new DBIError("The JDBC Driver class name provided [" + driver + "] cannot be found.");
        }
        factory = user == null ? new ConnectionFactory(){

            public Connection getConnection() throws SQLException {
                return DriverManager.getConnection(conn);
            }
        } : new ConnectionFactory(){

            public Connection getConnection() throws SQLException {
                return DriverManager.getConnection(conn, user, pass);
            }
        };
        handleDecoratorBuilder = config.getHandleDecoratorBuilder();
        transactionHandler = config.getTransactionHandler();
        statementLocator = config.getStatementLocator();
        return factory;
    }

    Configuration configure() throws IOException {
        Properties props = this.mangleProperties(this.findProperties());
        Configuration config = new Configuration();
        config.setDriver(props.getProperty(DRIVER_NAME_PROPS[0]));
        config.setPassword(props.getProperty(PASSWORD_PROPS[0]));
        config.setUrl(props.getProperty(JDBC_URL_PROPS[0]));
        config.setUsername(props.getProperty(USERNAME_PROPS[0]));
        config.setHandleDecoratorBuilder(props.getProperty(HANDLE_DECORATOR_BUIDLER[0]));
        config.setTransactionHandler(props.getProperty(TRANSACTION_HANDLER[0]));
        config.setStatementLocator(props.getProperty(STATEMENT_LOCATOR[0]));
        return config;
    }

    private Properties findProperties() throws IOException {
        Properties props = new Properties();
        for (int i = 0; i < PROPERTIES_FILE_NAMES.length; ++i) {
            String name = PROPERTIES_FILE_NAMES[i];
            InputStream in = ClasspathStatementLocator.selectClassLoader().getResourceAsStream(name);
            if (in == null) continue;
            props.load(in);
            in.close();
            return props;
        }
        throw new IllegalStateException("unable to findInternal configuration properties on classpath");
    }

    private Properties mangleProperties(Properties starting) {
        String locator;
        String txHandler;
        String decorator;
        String password;
        String username;
        String jdbc_url;
        String driver = this.selectFirst(DRIVER_NAME_PROPS, starting);
        if (driver != null) {
            starting.setProperty(DRIVER_NAME_PROPS[0], driver);
        }
        if ((jdbc_url = this.selectFirst(JDBC_URL_PROPS, starting)) != null) {
            starting.setProperty(JDBC_URL_PROPS[0], jdbc_url);
        }
        if ((username = this.selectFirst(USERNAME_PROPS, starting)) != null) {
            starting.setProperty(USERNAME_PROPS[0], username);
        }
        if ((password = this.selectFirst(PASSWORD_PROPS, starting)) != null) {
            starting.setProperty(PASSWORD_PROPS[0], password);
        }
        if ((decorator = this.selectFirst(HANDLE_DECORATOR_BUIDLER, starting)) != null) {
            starting.setProperty(HANDLE_DECORATOR_BUIDLER[0], decorator);
        }
        if ((txHandler = this.selectFirst(TRANSACTION_HANDLER, starting)) != null) {
            starting.setProperty(TRANSACTION_HANDLER[0], txHandler);
        }
        if ((locator = this.selectFirst(STATEMENT_LOCATOR, starting)) != null) {
            starting.setProperty(STATEMENT_LOCATOR[0], locator);
        }
        return starting;
    }

    private String selectFirst(String[] options, Properties props) {
        if (System.getProperty(options[0]) != null) {
            return System.getProperty(options[0]);
        }
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (!props.containsKey(option)) continue;
            return props.getProperty(option);
        }
        return null;
    }

    public HandleDecorator getHandleDecoratorBuilder() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (handleDecoratorBuilder == null) {
            return null;
        }
        Class<?> clazz = Class.forName(handleDecoratorBuilder);
        HandleDecorator builder = (HandleDecorator)clazz.newInstance();
        return builder;
    }

    public TransactionHandler getTransactionHandler() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (transactionHandler == null) {
            return null;
        }
        Class<?> clazz = Class.forName(transactionHandler);
        TransactionHandler handler = (TransactionHandler)clazz.newInstance();
        return handler;
    }

    public StatementLocator getStatementLocator() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (statementLocator == null) {
            return null;
        }
        Class<?> clazz = Class.forName(statementLocator);
        StatementLocator locator = (StatementLocator)clazz.newInstance();
        return locator;
    }
}

