/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.skife.jdbi.Arguments;
import org.skife.jdbi.StatementEnvelope;
import org.skife.jdbi.StatementFactory;
import org.skife.jdbi.StatementParser;

class DynamicStatementEnvelope
implements StatementEnvelope {
    private Set statements = new HashSet();
    private final Connection conn;
    private final StatementParser parser;

    DynamicStatementEnvelope(Connection conn, StatementParser parser) {
        this.conn = conn;
        this.parser = parser;
    }

    public PreparedStatement prepare(Arguments args) throws SQLException {
        String sql = this.parser.getSubstitutedSql();
        Object[] params = args.objects();
        for (int i = 0; i < params.length; ++i) {
            String last;
            String subs;
            StringBuffer buffer;
            String first;
            int index_of_sub;
            Object[] new_params;
            Iterator iterator;
            int index;
            Object[] to_insert;
            List<Object> in_param;
            Object param = params[i];
            if (param instanceof Collection) {
                in_param = (List<Object>)param;
                to_insert = new Object[in_param.size()];
                index = 0;
                iterator = in_param.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    to_insert[index++] = o;
                }
                new_params = new Object[params.length - 1 + to_insert.length];
                System.arraycopy(params, 0, new_params, 0, i + 1);
                System.arraycopy(to_insert, 0, new_params, i, to_insert.length);
                params = new_params;
                index_of_sub = StatementFactory.findNth(sql, "?", i + 1);
                first = sql.substring(0, index_of_sub);
                buffer = new StringBuffer();
                for (int j = 1; j < new_params.length; ++j) {
                    buffer.append("?");
                    if (j >= new_params.length) continue;
                    buffer.append(",");
                }
                subs = buffer.toString();
                last = sql.substring(index_of_sub, sql.length());
                sql = first + subs + last;
                break;
            }
            if (!param.getClass().isArray()) continue;
            in_param = Arrays.asList((Object[])param);
            to_insert = new Object[in_param.size()];
            index = 0;
            iterator = in_param.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                to_insert[index++] = o;
            }
            new_params = new Object[params.length - 1 + to_insert.length];
            System.arraycopy(params, 0, new_params, 0, i + 1);
            System.arraycopy(to_insert, 0, new_params, i, to_insert.length);
            params = new_params;
            index_of_sub = StatementFactory.findNth(sql, "?", i + 1);
            first = sql.substring(0, index_of_sub);
            buffer = new StringBuffer();
            for (int j = 1; j < new_params.length; ++j) {
                buffer.append("?");
                if (j >= new_params.length) continue;
                buffer.append(",");
            }
            subs = buffer.toString();
            last = sql.substring(index_of_sub, sql.length());
            sql = first + subs + last;
            break;
        }
        System.err.println("DSQL: " + sql);
        PreparedStatement stmt = sql.toUpperCase().trim().startsWith("CALL") ? this.conn.prepareCall(sql) : this.conn.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            stmt.setObject(i + 1, param);
        }
        this.statements.add(stmt);
        return stmt;
    }

    public void close() throws SQLException {
        SQLException e = null;
        Iterator iterator = this.statements.iterator();
        while (iterator.hasNext()) {
            PreparedStatement preparedStatement = (PreparedStatement)iterator.next();
            try {
                preparedStatement.close();
            }
            catch (SQLException e1) {
                e = e1;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public String[] getNamedParameters() {
        return this.parser.getNamedParams();
    }
}

