/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.tweak.CachingStatementLocator;
import org.skife.jdbi.tweak.ClasspathStatementLocator;
import org.skife.jdbi.tweak.StatementLocator;

class NamedStatementRepository {
    private final Map store = new HashMap();
    private StatementLocator locator = new CachingStatementLocator(new ClasspathStatementLocator());

    NamedStatementRepository() {
    }

    public Collection getNames() {
        return new ArrayList(this.store.keySet());
    }

    public boolean contains(String statement) {
        return this.store.containsKey(statement);
    }

    public String get(String statement) {
        String sql = (String)this.store.get(statement);
        if (sql == null) {
            sql = this.locator.load(statement);
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String statement, String sql) {
        Map map = this.store;
        synchronized (map) {
            this.store.put(statement, sql);
        }
    }

    public Map getStore() {
        return new HashMap(this.store);
    }

    public StatementLocator getLocator() {
        return this.locator;
    }

    public void setLocator(StatementLocator locator) {
        this.locator = locator;
    }
}

