/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.skife.jdbi.Batch;
import org.skife.jdbi.DBIException;

class QueueingBatch
implements Batch {
    private final List statements = new ArrayList();
    private final Connection conn;

    public QueueingBatch(Connection conn) {
        this.conn = conn;
    }

    public Batch add(String statement) {
        this.statements.add(statement);
        return this;
    }

    public Batch addAll(Collection statements) {
        Iterator iterator = statements.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            statements.add(String.valueOf(o));
        }
        return null;
    }

    public int[] execute() throws DBIException {
        Iterator itty = this.statements.iterator();
        try {
            Statement stmt = this.conn.createStatement();
            while (itty.hasNext()) {
                stmt.addBatch((String)itty.next());
            }
            int[] results = stmt.executeBatch();
            stmt.close();
            int[] nArray = results;
            return nArray;
        }
        catch (SQLException e) {
            throw new DBIException(e.getMessage(), e);
        }
        finally {
            this.statements.clear();
        }
    }
}

