/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.Arguments;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.ParamTool;
import org.skife.jdbi.PreparedBatch;

class QueueingPreparedBatch
implements PreparedBatch {
    private final PreparedStatement stmt;
    private final String[] params;
    private Map globals;
    private List args = new ArrayList();

    QueueingPreparedBatch(PreparedStatement stmt, String[] params, Map globals) {
        this.stmt = stmt;
        this.params = params;
        this.globals = globals;
    }

    public PreparedBatch add(Object[] objects) {
        this.args.add(new ArrayHolder(objects));
        return this;
    }

    public PreparedBatch add(Collection params) {
        this.args.add(new CollectionHolder(params));
        return this;
    }

    public PreparedBatch add(Object bean) {
        this.args.add(new BeanHolder(bean));
        return this;
    }

    public PreparedBatch addAll(Collection args) {
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof Map) {
                this.add((Map)o);
                continue;
            }
            if (o instanceof Collection) {
                this.add((Collection)o);
                continue;
            }
            if (o instanceof Object[]) {
                this.add((Object[])o);
                continue;
            }
            this.add(o);
        }
        return this;
    }

    public PreparedBatch addAll(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i];
            if (o instanceof Map) {
                this.add((Map)o);
                continue;
            }
            if (o instanceof Collection) {
                this.add((Collection)o);
                continue;
            }
            if (o instanceof Object[]) {
                this.add((Object[])o);
                continue;
            }
            this.add(o);
        }
        return this;
    }

    public PreparedBatch add(Map params) {
        this.args.add(new MapHolder(params));
        return this;
    }

    public int[] execute() throws DBIException {
        try {
            int[] results;
            for (int i = 0; i < this.args.size(); ++i) {
                Arguments h = (Arguments)this.args.get(i);
                Object[] objects = h.objects();
                for (int j = 0; j < objects.length; ++j) {
                    Object object = objects[j];
                    this.stmt.setObject(j + 1, object);
                }
                this.stmt.addBatch();
            }
            int[] nArray = results = this.stmt.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            throw new DBIException(e.getMessage(), e);
        }
        finally {
            this.args.clear();
        }
    }

    private class CollectionHolder
    implements Arguments {
        final Object[] args;

        public CollectionHolder(Collection params) {
            this.args = ParamTool.getParamsFromCollection(params);
        }

        public Object[] objects() {
            return this.args;
        }
    }

    private class MapHolder
    implements Arguments {
        final Object[] args;

        MapHolder(Map map) {
            this.args = ParamTool.getParamsFromMap(QueueingPreparedBatch.this.params, map, QueueingPreparedBatch.this.globals);
        }

        public Object[] objects() {
            return this.args;
        }
    }

    private class BeanHolder
    implements Arguments {
        private final Object[] args;

        public BeanHolder(Object bean) {
            this.args = ParamTool.getParamsForBean(QueueingPreparedBatch.this.params, bean, QueueingPreparedBatch.this.globals);
        }

        public Object[] objects() {
            return this.args;
        }
    }

    private class ArrayHolder
    implements Arguments {
        private final Object[] args;

        ArrayHolder(Object[] args) {
            this.args = args;
        }

        public Object[] objects() {
            return this.args;
        }
    }
}

