/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.skife.jdbi.Batch;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.Handle;
import org.skife.jdbi.tweak.ClasspathStatementLocator;

class Script {
    private final Handle handle;
    private final String name;

    Script(Handle handle, String name) {
        this.handle = handle;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws DBIException, IOException {
        ClassLoader loader = ClasspathStatementLocator.selectClassLoader();
        BufferedReader reader = null;
        Batch batch = this.handle.batch();
        try {
            String line;
            InputStream in = loader.getResourceAsStream(this.name + ".sql");
            reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (ClasspathStatementLocator.isComment(line)) continue;
                buffer.append(line).append(" ");
            }
            String[] statements = buffer.toString().replaceAll("\n", " ").split(";");
            for (int i = 0; i != statements.length; ++i) {
                if (statements[i].trim().equals("")) continue;
                batch.add(statements[i]);
            }
            batch.execute();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

