/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.skife.jdbi.Arguments;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.NamedStatementRepository;
import org.skife.jdbi.ParamTool;
import org.skife.jdbi.StatementEnvelope;
import org.skife.jdbi.StatementFactory;

class StatementCache {
    private final Connection conn;
    private final Map envelopes;
    private final Map globals;
    private final NamedStatementRepository repository;

    StatementCache(Connection conn, NamedStatementRepository repository, Map globals) {
        this.conn = conn;
        this.envelopes = new HashMap();
        this.globals = globals;
        this.repository = repository;
    }

    Map getGlobals() {
        return this.globals;
    }

    Collection close() {
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
        Iterator iterator = this.envelopes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            StatementEnvelope stmt = (StatementEnvelope)entry.getValue();
            try {
                stmt.close();
            }
            catch (SQLException e) {
                exceptions.add(e);
            }
        }
        this.envelopes.clear();
        return exceptions;
    }

    private StatementEnvelope locateStatement(String statement) throws DBIException {
        if (this.envelopes.containsKey(statement)) {
            return (StatementEnvelope)this.envelopes.get(statement);
        }
        String lower_case = statement.toLowerCase().trim();
        if (lower_case.startsWith("select ") || lower_case.startsWith("update ") || lower_case.startsWith("insert ") || lower_case.startsWith("delete ") || lower_case.startsWith("call ")) {
            try {
                return this.store(statement, statement);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        String sql = null;
        sql = this.repository.get(statement);
        if (sql != null) {
            try {
                StatementEnvelope stmt = this.store(statement, sql);
                return stmt;
            }
            catch (SQLException e1) {
                throw new DBIException("unable to parse statement stored in global repository: " + e1.getMessage(), e1);
            }
        }
        throw new DBIException("Unable to parse, or find an external representation of [" + statement + "]");
    }

    String load(String name) throws IOException {
        return this.repository.get(name);
    }

    void name(String name, String sql) throws DBIException {
        try {
            this.store(name, sql);
            this.repository.store(name, sql);
        }
        catch (SQLException e) {
            throw new DBIException("unable to prepare statement [" + sql + "] : " + e.getMessage(), e);
        }
    }

    PreparedStatement find(String statement) throws DBIException {
        return this.findInternal(statement, new Arguments(){

            public Object[] objects() {
                return ParamTool.EMPTY_OBJECT_ARRAY;
            }
        });
    }

    PreparedStatement find(final String statement, final Map params) throws DBIException {
        return this.findInternal(statement, new Arguments(){

            public Object[] objects() {
                return ParamTool.getParamsFromMap(StatementCache.this.parametersFor(statement), params, StatementCache.this.globals);
            }
        });
    }

    PreparedStatement find(String statement, final Collection args) throws DBIException {
        return this.findInternal(statement, new Arguments(){

            public Object[] objects() {
                return ParamTool.getParamsFromCollection(args);
            }
        });
    }

    PreparedStatement find(final String statement, final Object bean) throws DBIException {
        return this.findInternal(statement, new Arguments(){

            public Object[] objects() {
                String[] param_names = StatementCache.this.parametersFor(statement);
                return ParamTool.getParamsForBean(param_names, bean, StatementCache.this.globals);
            }
        });
    }

    PreparedStatement find(String statement, final Object[] params) throws DBIException {
        return this.findInternal(statement, new Arguments(){

            public Object[] objects() {
                return params;
            }
        });
    }

    private PreparedStatement findInternal(String statement, Arguments args) throws DBIException {
        PreparedStatement stmt;
        StatementEnvelope envelope = this.locateStatement(statement);
        try {
            stmt = envelope.prepare(args);
        }
        catch (SQLException e) {
            throw new DBIException("exception binding argument to statement [" + statement + "] : " + e.getMessage(), e);
        }
        return stmt;
    }

    private StatementEnvelope store(String name, String sql) throws SQLException {
        StatementEnvelope envelope = StatementFactory.build(this.conn, sql);
        this.envelopes.put(name, envelope);
        return envelope;
    }

    String[] parametersFor(String statement) {
        StatementEnvelope envelope = (StatementEnvelope)this.envelopes.get(statement);
        return envelope.getNamedParameters();
    }
}

