/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.spring;

import org.skife.jdbi.DBIException;
import org.skife.jdbi.Handle;
import org.skife.jdbi.IDBI;
import org.skife.jdbi.tweak.ConnectionTransactionHandler;
import org.skife.jdbi.tweak.TransactionHandler;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class SpringTransactionHandler
implements TransactionHandler {
    private final IDBI dbi;
    private final TransactionHandler direct = new ConnectionTransactionHandler();

    SpringTransactionHandler(IDBI dbi) {
        this.dbi = dbi;
    }

    public void begin(Handle handle) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Handle txional = (Handle)TransactionSynchronizationManager.getResource((Object)this.dbi);
            if (txional != this) {
                this.direct.begin(handle);
            }
        } else {
            this.direct.begin(handle);
        }
    }

    public void commit(Handle handle) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Handle txional = (Handle)TransactionSynchronizationManager.getResource((Object)this.dbi);
            if (txional != this) {
                this.direct.commit(handle);
            }
        } else {
            this.direct.commit(handle);
        }
    }

    public void rollback(Handle handle) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Handle txional = (Handle)TransactionSynchronizationManager.getResource((Object)this.dbi);
            if (txional == this) {
                throw new DBIException("Rollback Transaction");
            }
            this.direct.rollback(handle);
        } else {
            this.direct.rollback(handle);
        }
    }

    public boolean isInTransaction(Handle handle) {
        return this.direct.isInTransaction(handle);
    }
}

