/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.tweak;

import java.sql.Connection;
import java.sql.SQLException;
import org.skife.jdbi.DBIException;
import org.skife.jdbi.Handle;
import org.skife.jdbi.tweak.TransactionHandler;

public class ConnectionTransactionHandler
implements TransactionHandler {
    public void begin(Handle handle) {
        Connection conn = handle.getConnection();
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DBIException("unable to begin a transaction: " + e.getMessage(), e);
        }
    }

    public void commit(Handle handle) {
        Connection conn = handle.getConnection();
        try {
            conn.commit();
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new DBIException("unable to commit transaction: " + e.getMessage(), e);
        }
    }

    public void rollback(Handle handle) {
        Connection conn = handle.getConnection();
        try {
            conn.rollback();
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new DBIException("unable to roll back transaction: " + e.getMessage(), e);
        }
    }

    public boolean isInTransaction(Handle handle) {
        Connection conn = handle.getConnection();
        try {
            return !conn.getAutoCommit();
        }
        catch (SQLException e) {
            throw new DBIException(e.getMessage(), e);
        }
    }
}

