/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.naming.rmi.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import org.apache.avalon.excalibur.naming.DefaultNameParser;
import org.apache.avalon.excalibur.naming.DefaultNamespace;
import org.apache.avalon.excalibur.naming.memory.MemoryContext;
import org.apache.avalon.excalibur.naming.rmi.server.RMINamingProviderImpl;

public class Main
implements Runnable {
    private final boolean m_debug;
    private RMINamingProviderImpl m_server;
    private ServerSocket m_serverSocket;
    private MarshalledObject m_serverStub;
    private boolean m_running;
    private boolean m_initialized;

    public static void main(String[] args) throws Exception {
        boolean debug = true;
        if (args.length > 0 && "-q".equals(args[0])) {
            debug = false;
        }
        Main main = new Main(debug);
        main.start();
        main.accept();
    }

    public Main(boolean debug) {
        this.m_debug = debug;
    }

    public Main() {
        this(true);
    }

    public void init() throws Exception {
        if (this.m_initialized) {
            return;
        }
        try {
            if (this.m_debug) {
                System.out.println("Starting server on port 1977");
            }
            this.m_serverSocket = new ServerSocket(1977);
            this.m_initialized = true;
        }
        catch (IOException ioe) {
            if (this.m_debug) {
                System.out.println("Failed starting server");
            }
            throw ioe;
        }
    }

    public void start() throws Exception {
        this.init();
        this.export();
    }

    public void export() throws Exception {
        DefaultNameParser parser = new DefaultNameParser();
        DefaultNamespace namespace = new DefaultNamespace(parser);
        MemoryContext context = new MemoryContext(namespace, null, null);
        this.m_server = new RMINamingProviderImpl(context);
        try {
            if (this.m_debug) {
                System.out.println("Exporting RMI object on port 1099");
            }
            this.m_serverStub = new MarshalledObject<Remote>(UnicastRemoteObject.exportObject((Remote)this.m_server, 1099));
        }
        catch (IOException ioe) {
            if (this.m_debug) {
                System.out.println("Failed exporting object");
            }
            throw ioe;
        }
    }

    public void dispose() throws Exception {
        if (this.m_debug) {
            System.out.println("Shutting down server");
        }
        this.m_running = false;
        ServerSocket serverSocket = this.m_serverSocket;
        this.m_serverSocket = null;
        serverSocket.close();
        if (this.m_debug) {
            System.out.println("Server shutdown");
        }
    }

    public void stop() throws Exception {
        if (this.m_debug) {
            System.out.println("Stopping");
        }
        this.m_running = false;
        if (this.m_debug) {
            System.out.println("Unexporting object");
        }
        UnicastRemoteObject.unexportObject(this.m_server, true);
        this.m_serverStub = null;
        if (this.m_debug) {
            System.out.println("Server stopped");
        }
    }

    public void accept() {
        this.m_running = true;
        while (this.m_running) {
            try {
                Socket socket = this.m_serverSocket.accept();
                if (this.m_debug) {
                    System.out.println("Accepted Connection");
                }
                ObjectOutputStream output = new ObjectOutputStream(socket.getOutputStream());
                output.writeObject(this.m_serverStub);
                socket.close();
            }
            catch (IOException ioe) {
                if (!this.m_running) break;
                ioe.printStackTrace();
            }
        }
    }

    public void run() {
        this.accept();
    }
}

