/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Feature;
import org.apache.batik.svggen.font.table.Lookup;
import org.apache.batik.svggen.font.table.LookupSubtableFactory;

public class LookupList {
    private int lookupCount;
    private int[] lookupOffsets;
    private Lookup[] lookups;

    public LookupList(RandomAccessFile randomAccessFile, int n, LookupSubtableFactory lookupSubtableFactory) throws IOException {
        int n2;
        randomAccessFile.seek(n);
        this.lookupCount = randomAccessFile.readUnsignedShort();
        this.lookupOffsets = new int[this.lookupCount];
        this.lookups = new Lookup[this.lookupCount];
        for (n2 = 0; n2 < this.lookupCount; ++n2) {
            this.lookupOffsets[n2] = randomAccessFile.readUnsignedShort();
        }
        for (n2 = 0; n2 < this.lookupCount; ++n2) {
            this.lookups[n2] = new Lookup(lookupSubtableFactory, randomAccessFile, n + this.lookupOffsets[n2]);
        }
    }

    public Lookup getLookup(Feature feature, int n) {
        if (feature.getLookupCount() > n) {
            int n2 = feature.getLookupListIndex(n);
            return this.lookups[n2];
        }
        return null;
    }
}

