/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.logger;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.slide.common.Domain;
import org.apache.slide.webdav.logger.XResponseHeader;
import org.apache.slide.webdav.logger.XServletOutputStreamFacade;
import org.apache.slide.webdav.logger.XServletWriterFacade;

public class XHttpServletResponseFacade
extends HttpServletResponseWrapper {
    public static final String DEFAULT_CHAR_ENCODING = "8859_1";
    StringBuffer body = null;
    protected HttpServletRequest request;
    private int statusCode = -1;
    private String statusText = "";
    private boolean usingStream = false;
    private boolean usingWriter = false;
    XServletOutputStreamFacade osFacade = null;
    PrintWriter writer = null;
    Vector responseHeaders = new Vector();

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Enumeration getResponseHeaders() {
        return this.responseHeaders.elements();
    }

    public XHttpServletResponseFacade(HttpServletResponse response) {
        super(response);
        Domain.debug((Object)"Create XHttpServletResponseFacade");
    }

    public void addCookie(Cookie cookie) {
        this.responseHeaders.add(new XResponseHeader("Cookie", cookie.getName() + " " + cookie.getValue() + " " + cookie.getDomain()));
        super.addCookie(cookie);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        Domain.debug((Object)"ENTER: XHttpServletResponseFacade:getOutputStream()");
        if (this.usingWriter) {
            throw new IllegalStateException("Writer is already being used for this response");
        }
        this.usingStream = true;
        if (this.osFacade == null) {
            this.osFacade = new XServletOutputStreamFacade(super.getOutputStream(), super.getCharacterEncoding());
        }
        Domain.debug((Object)"LEAVE: XHttpServletResponseFacade:getOutputStream()");
        return this.osFacade;
    }

    public PrintWriter getWriter() throws IOException {
        Domain.debug((Object)"ENTER: XHttpServletResponseFacade:getWriter()");
        if (this.usingStream) {
            throw new IllegalStateException("OutputStream is already being used for this response");
        }
        this.usingWriter = true;
        if (this.writer == null) {
            this.writer = new XServletWriterFacade(super.getWriter());
        }
        Domain.debug((Object)"LEAVE: XHttpServletResponseFacade:getWriter()");
        return this.writer;
    }

    public PrintWriter getWriter(ServletOutputStream outs) throws IOException {
        Domain.debug((Object)"ENTER: XHttpServletResponseFacade:getWriter(ServletOutputStream)");
        if (this.writer != null) {
            return this.writer;
        }
        this.usingWriter = true;
        Domain.debug((Object)"LEAVE: XHttpServletResponseFacade:getWriter(ServletOutputStream)");
        return this.writer;
    }

    /*
     * WARNING - void declaration
     */
    public Writer getConverter(ServletOutputStream outs) throws IOException {
        void var3_3;
        OutputStreamWriter osWriter;
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            osWriter = new OutputStreamWriter((OutputStream)outs);
        } else {
            try {
                osWriter = new OutputStreamWriter((OutputStream)outs, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("Unsuported encoding: " + encoding);
                return new OutputStreamWriter((OutputStream)outs);
            }
        }
        return var3_3;
    }

    public void setDateHeader(String name, long date) {
        this.responseHeaders.add(new XResponseHeader(name, String.valueOf(date)));
        super.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.responseHeaders.add(new XResponseHeader(name, String.valueOf(date)));
        super.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.responseHeaders.add(new XResponseHeader(name, value));
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.responseHeaders.add(new XResponseHeader(name, value));
        super.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.responseHeaders.add(new XResponseHeader(name, String.valueOf(value)));
        super.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.responseHeaders.add(new XResponseHeader(name, String.valueOf(value)));
        super.addHeader(name, Integer.toString(value));
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatus(int sc) {
        this.statusCode = sc;
        super.setStatus(sc);
    }

    public void setStatus(int sc, String msg) {
        this.statusCode = sc;
        this.statusText = msg;
        super.setStatus(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.statusCode = sc;
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.statusCode = sc;
        this.statusText = msg;
        super.sendError(sc, msg);
    }

    public String getResponseBody() throws IOException {
        if (this.usingStream) {
            Domain.debug((Object)"XHttpServletResponseFacade:getResponseBody() - usingStream");
            return this.osFacade.getOutputBuffer();
        }
        if (this.usingWriter) {
            Domain.debug((Object)"XHttpServletResponseFacade:getResponseBody() - usingWriter");
            return ((XServletWriterFacade)this.writer).getOutputBuffer();
        }
        Domain.debug((Object)("XHttpServletResponseFacade:getResponseBody() - nor writer nor stream - osFacade = " + (Object)((Object)this.osFacade) + " writer = " + this.writer));
        return "";
    }
}

