/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.logger;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.slide.webdav.logger.XHttpServletRequestFacade;
import org.apache.slide.webdav.logger.XHttpServletResponseFacade;
import org.apache.slide.webdav.logger.XResponseHeader;
import org.apache.slide.webdav.util.WebdavStatus;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLTestCaseGenerator {
    private XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
    private XHttpServletRequestFacade request;
    private XHttpServletResponseFacade response;
    private Element root = new Element("test");
    private Document doc = new Document(this.root);
    private String threadName;

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public XMLTestCaseGenerator(XHttpServletRequestFacade request, XHttpServletResponseFacade response) {
        this.request = request;
        this.response = response;
    }

    public String toString() {
        String result = "";
        this.root.addContent((Content)this.printXMLstep());
        try {
            result = this.xmlOut.outputString(this.doc.getRootElement().getChild("step"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private Element printXMLstep() {
        Element stepElem = new Element("step");
        stepElem.addContent((Content)this.printXMLrequest());
        stepElem.addContent((Content)this.printXMLresponse());
        return stepElem;
    }

    private Element printXMLrequest() {
        Element stepElem = new Element("request");
        stepElem.addContent((Content)this.printXMLrequestCommand());
        Iterator it = this.printXMLrequestHeaders();
        while (it.hasNext()) {
            stepElem.addContent((Content)((Element)it.next()));
        }
        stepElem.addContent((Content)this.printXMLrequestBody());
        return stepElem;
    }

    private Element printXMLresponse() {
        Element respElem = new Element("response");
        respElem.addContent((Content)this.printXMLresponseCommand());
        Iterator it = this.printXMLresponseHeaders();
        while (it.hasNext()) {
            respElem.addContent((Content)((Element)it.next()));
        }
        respElem.addContent((Content)this.printXMLresponseBody());
        return respElem;
    }

    private Element printXMLrequestCommand() {
        Element reqComElem = new Element("command");
        reqComElem.addContent(this.request.getMethod() + " " + this.request.getRequestURI() + " " + this.getProtocol());
        return reqComElem;
    }

    private Iterator printXMLrequestHeaders() {
        Vector<Element> vector = new Vector<Element>();
        Enumeration e = this.request.getHeaderNames();
        if (e != null) {
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                String headerValue = this.request.getHeader(headerName);
                Element elem = new Element("header");
                elem.addContent(headerName + ": " + headerValue);
                vector.add(elem);
            }
        }
        return vector.iterator();
    }

    private Element printXMLrequestBody() {
        Element bodyElem = new Element("body");
        try {
            bodyElem.addContent((Content)new CDATA(this.request.getRequestBody()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bodyElem;
    }

    private Element printXMLresponseCommand() {
        Element respComElem = new Element("command");
        respComElem.addContent(this.getProtocol() + " " + this.response.getStatus() + " " + WebdavStatus.getStatusText(this.response.getStatus()));
        return respComElem;
    }

    private String getProtocol() {
        String result = this.request.getProtocol();
        while (result.endsWith("\n")) {
            result = result.substring(0, result.length() - "\n".length() - 1);
        }
        return result;
    }

    private Iterator printXMLresponseHeaders() {
        Vector<Element> vector = new Vector<Element>();
        Enumeration e = this.response.getResponseHeaders();
        if (e != null) {
            while (e.hasMoreElements()) {
                Element elem = new Element("header");
                elem.addContent(((XResponseHeader)e.nextElement()).toString());
                vector.add(elem);
            }
        }
        return vector.iterator();
    }

    private Element printXMLresponseBody() {
        Element bodyElem = new Element("body");
        try {
            bodyElem.addContent((Content)new CDATA(this.response.getResponseBody()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bodyElem;
    }
}

