/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.SlideException;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.MethodUtil;

public abstract class AbstractMultistatusResponseMethod
extends AbstractWebdavMethod {
    protected String sourceUri;
    protected String destinationUri;
    protected boolean overwrite;

    public AbstractMultistatusResponseMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.sourceUri = this.requestUri;
        if (this.sourceUri == null) {
            this.sourceUri = "/";
        }
        this.destinationUri = this.requestHeaders.getDestination();
        if (this.destinationUri == null) {
            int statusCode = 400;
            this.sendError(statusCode, this.getClass().getName() + ".missingDestinationHeader");
            throw new WebdavException(statusCode);
        }
        this.destinationUri = this.parseUri(this.destinationUri);
        this.overwrite = this.requestHeaders.getOverwrite(true);
    }

    public static boolean generateMultiStatusResponse(boolean isCollection, NestedSlideException causeException, String resourceURI) {
        boolean isMultiStatus = false;
        if (isCollection) {
            if (causeException.getExceptionsCount() > 1) {
                isMultiStatus = true;
            } else if (causeException.getExceptionsCount() == 1) {
                SlideException unpackedException = causeException.unpackSingleException();
                isMultiStatus = !resourceURI.equals(MethodUtil.getURI(unpackedException));
            }
        }
        return isMultiStatus;
    }
}

