/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.security.NodePermission;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.jdom.Element;
import org.jdom.JDOMException;

public class AclMethod
extends AbstractWebdavMethod
implements AclConstants,
WriteMethod {
    private String resourcePath;
    private Vector permissions;

    public AclMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.permissions = new Vector();
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        try {
            Iterator aceIt = this.parseRequestContent("acl").getChildren().iterator();
            while (aceIt.hasNext()) {
                Element aceElm = (Element)aceIt.next();
                this.permissions.addAll(this.createNodePermissionList(aceElm));
            }
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (PreconditionViolationException e) {
            try {
                this.sendPreconditionViolation(e);
            }
            catch (IOException x) {
                // empty catch block
            }
            throw new WebdavException(e.getStatusCode());
        }
        catch (SlideException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    private List createNodePermissionList(Element aceElm) throws PreconditionViolationException, SlideException, JDOMException {
        Element invertElm;
        ArrayList<NodePermission> result = new ArrayList<NodePermission>();
        String objectUri = this.resourcePath;
        String subjectUri = null;
        String actionUri = null;
        boolean negative = false;
        boolean invert = false;
        Element principalElm = aceElm.getChild("principal", DNSP);
        if (principalElm == null && (invertElm = aceElm.getChild("invert", DNSP)) != null) {
            invert = true;
            principalElm = invertElm.getChild("principal", DNSP);
        }
        if (principalElm == null) {
            throw new PreconditionViolationException(new ViolatedPrecondition("missing-ace-principal", 400), this.resourcePath);
        }
        subjectUri = this.createSubjectUri(principalElm);
        Element grantDenyElm = null;
        Element grantElm = aceElm.getChild("grant", DNSP);
        Element denyElm = aceElm.getChild("deny", DNSP);
        if (grantElm != null && denyElm == null) {
            grantDenyElm = grantElm;
        } else if (grantElm == null && denyElm != null) {
            negative = true;
            grantDenyElm = denyElm;
        } else {
            if (grantElm != null && denyElm != null) {
                throw new PreconditionViolationException(new ViolatedPrecondition("only-grant-or-deny-allowed", 400), this.resourcePath);
            }
            if (grantElm == null && denyElm == null) {
                throw new PreconditionViolationException(new ViolatedPrecondition("missing-grant-or-deny", 400), this.resourcePath);
            }
        }
        Iterator privilegeIt = grantDenyElm.getChildren("privilege", DNSP).iterator();
        while (privilegeIt.hasNext()) {
            Element privilegeElm = (Element)privilegeIt.next();
            actionUri = this.createActionUri(privilegeElm);
            if (actionUri == null) {
                throw new PreconditionViolationException(new ViolatedPrecondition("not-supported-privilege", 400), this.resourcePath);
            }
            NodePermission np = new NodePermission(objectUri, subjectUri, actionUri, true, negative);
            np.setInvert(invert);
            result.add(np);
        }
        return result;
    }

    private String createSubjectUri(Element principalElm) throws JDOMException, PreconditionViolationException {
        Element elm = principalElm.getChild("href", DNSP);
        if (elm != null) {
            return this.getSlidePath(elm.getTextTrim());
        }
        elm = principalElm.getChild("all", DNSP);
        if (elm != null) {
            return "all";
        }
        elm = principalElm.getChild("authenticated", DNSP);
        if (elm != null) {
            return "authenticated";
        }
        elm = principalElm.getChild("unauthenticated", DNSP);
        if (elm != null) {
            return "unauthenticated";
        }
        elm = principalElm.getChild("self", DNSP);
        if (elm != null) {
            return "self";
        }
        elm = principalElm.getChild("property", DNSP);
        if (elm != null) {
            if (elm.getChild("owner", DNSP) != null) {
                return "owner";
            }
            throw new PreconditionViolationException(new ViolatedPrecondition("only-onwer-property-supported", 409), this.resourcePath);
        }
        throw new PreconditionViolationException(new ViolatedPrecondition("could-not-determine-principal", 400), this.resourcePath);
    }

    private String createActionUri(Element privilegeElm) throws JDOMException, PreconditionViolationException, SlideException {
        Element privilegeChildElm = (Element)privilegeElm.getChildren().get(0);
        String privilegeName = privilegeChildElm.getName();
        String privilegeNamespace = privilegeChildElm.getNamespaceURI();
        if ("all".equals(privilegeName) && "DAV:".equals(privilegeNamespace)) {
            return "all";
        }
        ObjectNode actions = this.structure.retrieve(this.slideToken, this.token.getNamespaceConfig().getActionsPath());
        ObjectNode action = this.findAction(actions.getChildren().iterator(), privilegeName, privilegeNamespace);
        return action != null ? action.getUri() : null;
    }

    private ObjectNode findAction(Iterator actionsIterator, String privilegeName, String privilegeNamespace) throws SlideException {
        ObjectNode result = null;
        while (result == null && actionsIterator.hasNext()) {
            String aNamespace;
            String aUriAsString = (String)actionsIterator.next();
            ObjectNode aNode = this.structure.retrieve(this.slideToken, aUriAsString);
            if (aNode.hasChildren()) {
                result = this.findAction(aNode.getChildren().iterator(), privilegeName, privilegeNamespace);
                continue;
            }
            Uri aUri = this.token.getUri(this.slideToken, aUriAsString);
            NodeRevisionDescriptors nrds = aUri.getStore().retrieveRevisionDescriptors(aUri);
            NodeRevisionDescriptor latestNrd = aUri.getStore().retrieveRevisionDescriptor(aUri, nrds.getLatestRevision());
            NodeProperty aNamespaceAsNode = latestNrd.getProperty("privilege-namespace", "DAV:");
            String string = aNamespace = aNamespaceAsNode == null ? null : aNamespaceAsNode.getValue().toString();
            String aUriLastSegment = aUriAsString.substring(aUriAsString.lastIndexOf(47) + 1);
            if (!aUriLastSegment.equals(privilegeName) || (aNamespace == null || !privilegeNamespace.equals(aNamespace)) && (aNamespace != null || !privilegeNamespace.equals("DAV:"))) continue;
            result = aNode;
        }
        return result;
    }

    private void checkPreconditions() throws PreconditionViolationException, ServiceAccessException {
        this.resp.setStatus(200);
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.resourcePath)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            if (WebdavEvent.ACL.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.ACL, (EventObject)new WebdavEvent(this));
            }
            this.checkPreconditions();
            this.security.setPermissions(this.slideToken, this.resourcePath, this.permissions.elements());
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }
}

