/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class CheckoutMethod
extends AbstractWebdavMethod
implements DeltavConstants,
WriteMethod {
    private String resourcePath;
    private boolean applyToVersion = false;
    private boolean forkOk = false;
    protected VersioningHelper versioningHelper = null;

    public CheckoutMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        if (Configuration.useVersionControl()) {
            try {
                String labelHeader = WebdavUtils.fixTomcatHeader(this.requestHeaders.getLabel(), "UTF-8");
                this.applyToVersion = labelHeader != null;
                this.resourcePath = this.versioningHelper.getLabeledResourceUri(this.resourcePath, labelHeader);
            }
            catch (LabeledRevisionNotFoundException e) {
                ViolatedPrecondition violatedPrecondition = new ViolatedPrecondition("must-select-version-in-history", 409);
                try {
                    this.sendPreconditionViolation(new PreconditionViolationException(violatedPrecondition, this.resourcePath));
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw new WebdavException(this.getErrorCode((Throwable)((Object)e)));
            }
            catch (SlideException e) {
                int statusCode = this.getErrorCode(e);
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
        if (this.req.getContentLength() > 0) {
            try {
                Iterator i = this.parseRequestContent("checkout").getChildren().iterator();
                while (i.hasNext()) {
                    Element e = (Element)i.next();
                    if (e.getName().equals("apply-to-version")) {
                        String labelHeader = WebdavUtils.fixTomcatHeader(this.requestHeaders.getLabel(), "UTF-8");
                        if (labelHeader != null) {
                            ViolatedPrecondition violatedPrecondition = new ViolatedPrecondition("must-not-have-label-and-apply-to-version", 409);
                            this.sendPreconditionViolation(new PreconditionViolationException(violatedPrecondition, this.resourcePath));
                            throw new WebdavException(409);
                        }
                        this.applyToVersion = true;
                    }
                    if (!e.getName().equals("fork-ok")) continue;
                    this.forkOk = true;
                }
            }
            catch (IOException e) {
                int statusCode = 500;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (JDOMException e) {
                int statusCode = 400;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeRequest() throws WebdavException, IOException {
        String locationValue = null;
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.resourcePath)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            try {
                if (WebdavEvent.CHECKOUT.isEnabled()) {
                    EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.CHECKOUT, (EventObject)new WebdavEvent(this));
                }
                locationValue = this.versioningHelper.checkout(this.resourcePath, this.forkOk, this.applyToVersion);
            }
            catch (PreconditionViolationException e) {
                this.sendPreconditionViolation(e);
                throw e;
            }
            catch (Exception e) {
                int statusCode = this.getErrorCode(e);
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.resp.setHeader("Cache-Control", "no-cache");
            if (locationValue == null) throw throwable;
            if (locationValue.length() <= 0) throw throwable;
            locationValue = this.getFullPath(locationValue);
            this.resp.setHeader("Location", WebdavUtils.encodeURL(locationValue, "utf-8"));
            throw throwable;
        }
        this.resp.setHeader("Cache-Control", "no-cache");
        if (locationValue == null) return;
        if (locationValue.length() <= 0) return;
        locationValue = this.getFullPath(locationValue);
        this.resp.setHeader("Location", WebdavUtils.encodeURL(locationValue, "utf-8"));
    }
}

