/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.BranchNotFoundException;
import org.apache.slide.content.NodeNotVersionedException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoException;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.macro.CopyListener;
import org.apache.slide.macro.CopyRouteRedirector;
import org.apache.slide.macro.DeleteListener;
import org.apache.slide.macro.MacroException;
import org.apache.slide.macro.MacroParameters;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.store.Store;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractMultistatusResponseMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.BindConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.VersionableImpl;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class CopyMethod
extends AbstractMultistatusResponseMethod
implements DeltavConstants,
AclConstants,
BindConstants,
CopyListener,
DeleteListener,
CopyRouteRedirector,
WriteMethod {
    protected VersioningHelper versioningHelper = null;
    protected Map destinationDescriptorMap = new HashMap();
    protected Map destinationBackupDescriptorMap = new HashMap();
    protected String labelHeader = null;
    private MacroParameters macroParameters = null;

    public CopyMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        super.parseRequest();
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        this.labelHeader = WebdavUtils.fixTomcatHeader(this.requestHeaders.getLabel(), "UTF-8");
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        boolean isCollection = this.isCollection(this.sourceUri);
        try {
            if (this.isLockNull(this.sourceUri)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.sourceUri});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Throwable)e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        UriHandler destUh = UriHandler.getUriHandler(this.destinationUri);
        if (destUh.isRestrictedUri()) {
            boolean sendError = true;
            if (destUh.isWorkspaceUri() || destUh.isWorkingresourceUri()) {
                try {
                    if (WebdavEvent.COPY.isEnabled()) {
                        EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.COPY, (EventObject)new WebdavEvent(this));
                    }
                    this.content.retrieve(this.slideToken, this.destinationUri);
                    sendError = false;
                }
                catch (SlideException x) {
                    int statusCode = this.getErrorCode(x);
                    this.sendError(statusCode, x);
                    throw new WebdavException(statusCode);
                }
            }
            if (sendError) {
                int statusCode = 403;
                this.sendError(statusCode, this.getClass().getName() + ".restrictedDestinationUri", new Object[]{this.destinationUri});
                throw new WebdavException(statusCode);
            }
        }
        try {
            int depth = this.requestHeaders.getDepth(Integer.MAX_VALUE);
            if (depth != 0 && depth != Integer.MAX_VALUE) {
                int sc = 412;
                this.sendError(sc, "Invalid header Depth: " + depth);
                throw new WebdavException(sc);
            }
            boolean recursive = depth == Integer.MAX_VALUE;
            this.macroParameters = this.overwrite ? new MacroParameters(recursive, true, true) : new MacroParameters(recursive, false, false);
            boolean destinationExistsBefore = this.exists(this.destinationUri);
            if (!this.overwrite && destinationExistsBefore) {
                int statusCode = 412;
                this.sendError(statusCode, this.getClass().getName() + ".noOverwrite", new Object[]{this.destinationUri});
                throw new WebdavException(statusCode);
            }
            this.macro.copy(this.slideToken, this.sourceUri, this.destinationUri, this.macroParameters, (CopyRouteRedirector)this, (CopyListener)this, null, (DeleteListener)this);
            if (this.overwrite && destinationExistsBefore) {
                this.resp.setStatus(204);
            } else {
                this.resp.setStatus(201);
            }
        }
        catch (MacroException e) {
            if (CopyMethod.generateMultiStatusResponse(isCollection, (NestedSlideException)e, this.requestUri)) {
                String errorMessage = this.generateErrorMessage((NestedSlideException)e);
                this.resp.setStatus(207);
                try {
                    this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                    this.resp.getWriter().write(errorMessage);
                }
                catch (IOException ex) {
                    int statusCode = 500;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            } else {
                SlideException exception = (SlideException)((Object)e.enumerateExceptions().nextElement());
                if (exception instanceof PreconditionViolationException) {
                    try {
                        this.sendPreconditionViolation((PreconditionViolationException)exception);
                    }
                    catch (IOException ex) {
                        int statusCode = 500;
                        this.sendError(statusCode, e);
                        throw new WebdavException(statusCode);
                    }
                } else {
                    int statusCode = this.getErrorCode(exception);
                    this.sendError(statusCode, exception);
                    throw new WebdavException(statusCode);
                }
            }
            throw new WebdavException(202, false);
        }
        catch (WebdavException e) {
            throw e;
        }
        catch (SlideException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected int getErrorCode(SlideException ex) {
        try {
            throw ex;
        }
        catch (RevisionNotFoundException e) {
            return 404;
        }
        catch (SlideException e) {
            return super.getErrorCode(e);
        }
    }

    private void restoreLiveProperties(String destinationUri, NodeRevisionDescriptor destinationNrd, NodeRevisionDescriptor existingNrd) {
        Enumeration propertyEnum = destinationNrd.enumerateProperties();
        NodeProperty property = null;
        while (propertyEnum.hasMoreElements()) {
            property = (NodeProperty)propertyEnum.nextElement();
            if (!this.isLivePropertyToRestore(destinationUri, property)) continue;
            destinationNrd.removeProperty(property);
        }
        propertyEnum = existingNrd.enumerateProperties();
        property = null;
        while (propertyEnum.hasMoreElements()) {
            property = (NodeProperty)propertyEnum.nextElement();
            if (!this.isLivePropertyToRestore(destinationUri, property)) continue;
            destinationNrd.setProperty(property);
        }
    }

    private boolean isLivePropertyToRestore(String uri, NodeProperty property) {
        boolean isLivePropertyToRestore = property.isLiveProperty() && (DeltavConstants.DELTAV_PROPERTY_LIST.contains(property.getName()) || AclConstants.ACL_PROPERTY_LIST.contains(property.getName()) || BindConstants.BIND_PROPERTY_LIST.contains(property.getName()) || "creationdate".equals(property.getName()) || "displayname".equals(property.getName()) && Configuration.useBinding((Store)this.token.getUri(this.slideToken, uri).getStore()));
        return isLivePropertyToRestore;
    }

    private void resetDeltavProperties(NodeRevisionDescriptor revisionDescriptor, String resourcePath) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this.slideToken, this.token, this.getConfig());
        ResourceKind resourceKind = VersionableImpl.getInstance();
        Iterator initialPropertyIterator = propertyHelper.createInitialProperties(resourceKind, resourcePath).iterator();
        NodeProperty property = null;
        ArrayList<NodeProperty> initialDeltavProperties = new ArrayList<NodeProperty>();
        while (initialPropertyIterator.hasNext()) {
            property = (NodeProperty)initialPropertyIterator.next();
            if (!DeltavConstants.DELTAV_PROPERTY_LIST.contains(property.getName())) continue;
            initialDeltavProperties.add(property);
        }
        Enumeration propertyEnum = revisionDescriptor.enumerateProperties();
        property = null;
        int index = 0;
        while (propertyEnum.hasMoreElements()) {
            property = (NodeProperty)propertyEnum.nextElement();
            if (!DeltavConstants.DELTAV_PROPERTY_LIST.contains(property.getName())) continue;
            index = initialDeltavProperties.indexOf(property);
            if (index >= 0) {
                revisionDescriptor.setProperty((NodeProperty)initialDeltavProperties.get(index));
                continue;
            }
            revisionDescriptor.removeProperty(property);
        }
    }

    private void restoreBackupRevisionDescriptor(String destinationUri, NodeRevisionDescriptors destinationNrds) throws RevisionNotFoundException, ServiceAccessException, RevisionAlreadyExistException, ObjectNotFoundException, LinkedObjectNotFoundException, ObjectLockedException, AccessDeniedException, RevisionDescriptorNotFoundException, BranchNotFoundException, NodeNotVersionedException, VetoException {
        NodeRevisionDescriptor backupNrd = (NodeRevisionDescriptor)this.destinationBackupDescriptorMap.get(destinationUri);
        if (backupNrd != null) {
            try {
                this.content.retrieve(this.slideToken, destinationNrds, NodeRevisionNumber.HIDDEN_0_0);
                this.content.store(this.slideToken, destinationNrds.getUri(), backupNrd, null);
            }
            catch (RevisionDescriptorNotFoundException e) {
                this.content.create(this.slideToken, destinationNrds.getUri(), null, backupNrd, null);
            }
        }
    }

    public CopyRouteRedirector.CopyRoute getRedirectedCopyRoute(CopyRouteRedirector.CopyRoute copyRoute) throws SlideException {
        if (Configuration.useVersionControl()) {
            String sourceUri = copyRoute.getSourceUri();
            String destinationUri = copyRoute.getDestinationUri();
            try {
                sourceUri = this.versioningHelper.getLabeledResourceUri(sourceUri, this.labelHeader);
                copyRoute = new CopyRouteRedirector.CopyRoute(sourceUri, destinationUri);
            }
            catch (LabeledRevisionNotFoundException e) {
                ViolatedPrecondition violatedPrecondition = new ViolatedPrecondition("must-select-version-in-history", 409);
                throw new PreconditionViolationException(violatedPrecondition, sourceUri);
            }
        }
        return copyRoute;
    }

    public void beforeCopy(String sourceUri, String destinationUri, boolean isRootOfCopy) throws SlideException {
        if (Configuration.useVersionControl()) {
            UriHandler sourceUh = UriHandler.getUriHandler(sourceUri);
            if (sourceUh.isHistoryUri()) {
                throw new PreconditionViolationException(new ViolatedPrecondition("cannot-copy-history", 403), sourceUri);
            }
            if (!this.macroParameters.isDeleteCreate()) {
                this.beforeUpdateOrDelete(destinationUri);
            }
        }
        if (isRootOfCopy && Configuration.useBinding((Store)this.token.getUri(this.slideToken, destinationUri).getStore())) {
            HashMap<String, String> parentBindings = new HashMap<String, String>();
            try {
                NodeRevisionDescriptor destinationNrd = this.content.retrieve(this.slideToken, this.content.retrieve(this.slideToken, destinationUri));
                XMLValue v = new XMLValue((String)destinationNrd.getProperty("parent-set").getValue());
                Iterator i = v.iterator();
                while (i.hasNext()) {
                    Namespace dnsp = Namespace.getNamespace((String)"DAV:");
                    Element parentElm = (Element)i.next();
                    String segment = parentElm.getChild("segment", dnsp).getTextTrim();
                    String href = parentElm.getChild("href", dnsp).getTextTrim();
                    parentBindings.put(href, segment);
                }
            }
            catch (ServiceAccessException x) {
                throw x;
            }
            catch (SlideException e) {
            }
            catch (JDOMException e) {
                // empty catch block
            }
            this.macroParameters.setParameter("parentBindings", parentBindings);
        }
    }

    public void afterCopy(String sourceUri, String destinationUri, boolean isRootOfCopy, boolean destinationExists) throws SlideException {
        if (Configuration.useVersionControl()) {
            NodeRevisionDescriptors destinationNrds = this.content.retrieve(this.slideToken, destinationUri);
            NodeRevisionDescriptor destinationNrd = this.content.retrieve(this.slideToken, destinationNrds);
            this.restoreBackupRevisionDescriptor(destinationUri, destinationNrds);
            NodeRevisionDescriptor existingNrd = (NodeRevisionDescriptor)this.destinationDescriptorMap.get(destinationUri);
            if (existingNrd != null) {
                this.restoreLiveProperties(destinationUri, destinationNrd, existingNrd);
            } else {
                this.resetDeltavProperties(destinationNrd, destinationUri);
            }
            this.versioningHelper.setWorkspaceProperty(destinationUri, destinationNrd);
            destinationNrd.setLastModified(new Date());
            destinationNrd.setETag(PropertyHelper.computeEtag(destinationUri, destinationNrd));
            if (!destinationExists) {
                String creator = ((SubjectNode)this.security.getPrincipal(this.slideToken)).getPath().lastSegment();
                destinationNrd.setOwner(creator);
            }
            this.content.store(this.slideToken, destinationNrds.getUri(), destinationNrd, null);
            boolean mustCheckin = this.versioningHelper.mustCheckinAutoVersionedVCR(this.slideToken, destinationNrds, destinationNrd);
            if (mustCheckin) {
                try {
                    this.versioningHelper.checkin(destinationUri, false, false, true);
                }
                catch (IOException e) {
                    throw new SlideException("Checkin failed: " + e.getMessage());
                }
                catch (JDOMException e) {
                    throw new SlideException("Checkin failed: " + e.getMessage());
                }
            }
            if (this.isAutoVersionControl(destinationUri) && !this.isCollection(destinationUri) && !this.isExcludedForVersionControl(destinationUri)) {
                this.versioningHelper.versionControl(destinationUri);
            }
        }
        if (isRootOfCopy && Configuration.useBinding((Store)this.token.getUri(this.slideToken, destinationUri).getStore()) && this.macroParameters.getParameter("parentBindings") != null) {
            Map parentBindings = (Map)this.macroParameters.getParameter("parentBindings");
            Iterator i = parentBindings.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                ObjectNode parentNode = this.structure.retrieve(this.slideToken, (String)me.getKey());
                ObjectNode destinationNode = this.structure.retrieve(this.slideToken, destinationUri);
                String segment = (String)me.getValue();
                this.structure.addBinding(this.slideToken, parentNode, segment, destinationNode);
            }
        }
    }

    public void beforeDelete(String destinationUri) throws SlideException {
        this.beforeUpdateOrDelete(destinationUri);
    }

    private void beforeUpdateOrDelete(String destinationUri) throws SlideException {
        if (Configuration.useVersionControl()) {
            NodeRevisionDescriptors destinationNrds = null;
            NodeRevisionDescriptor destinationNrd = null;
            try {
                destinationNrds = this.content.retrieve(this.slideToken, destinationUri);
                destinationNrd = this.content.retrieve(this.slideToken, destinationNrds);
            }
            catch (ObjectNotFoundException e) {
                // empty catch block
            }
            if (destinationNrds != null && destinationNrd != null) {
                UriHandler uriHandler;
                ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, destinationUri, destinationNrd);
                if (resourceKind instanceof CheckedInVersionControlled) {
                    String autoVersion = this.versioningHelper.getAutoVersionElementName(destinationNrd);
                    if (autoVersion == null) {
                        autoVersion = "";
                    }
                    if (!("checkout-checkin".equals(autoVersion) || "checkout-unlocked-checkin".equals(autoVersion) || "checkout".equals(autoVersion) || "checkout-ignore-unlock".equals(autoVersion) || "locked-checkout".equals(autoVersion))) {
                        throw new PreconditionViolationException(new ViolatedPrecondition("cannot-modify-version-controlled-content", 403), destinationUri);
                    }
                    if ("locked-checkout".equals(autoVersion) && !this.versioningHelper.isWriteLocked(this.slideToken, destinationNrds)) {
                        throw new PreconditionViolationException(new ViolatedPrecondition("cannot-modify-version-controlled-content", 403), destinationUri);
                    }
                }
                if ((uriHandler = UriHandler.getUriHandler(destinationUri)).isVersionUri()) {
                    throw new PreconditionViolationException(new ViolatedPrecondition("cannot-modify-version", 403), destinationUri);
                }
                if (Configuration.useVersionControl() && resourceKind instanceof CheckedInVersionControlled && this.versioningHelper.mustCheckoutAutoVersionedVCR(destinationNrds, destinationNrd)) {
                    try {
                        this.versioningHelper.checkout(destinationNrds, destinationNrd, false, false, true);
                    }
                    catch (IOException e) {
                        throw new SlideException("Checkout failed: " + e.getMessage());
                    }
                    catch (JDOMException e) {
                        throw new SlideException("Checkout failed: " + e.getMessage());
                    }
                }
                try {
                    NodeRevisionDescriptor backupNrd = this.content.retrieve(this.slideToken, destinationNrds, NodeRevisionNumber.HIDDEN_0_0);
                    this.destinationBackupDescriptorMap.put(destinationUri, backupNrd);
                }
                catch (RevisionDescriptorNotFoundException e) {
                    // empty catch block
                }
                this.destinationDescriptorMap.put(destinationUri, destinationNrd);
            }
        }
    }

    public void afterDelete(String targetUri) throws SlideException {
    }
}

