/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionContentNotFoundException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.ReadMethod;
import org.apache.slide.webdav.util.DirectoryIndexGenerator;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;

public class GetMethod
extends AbstractWebdavMethod
implements ReadMethod {
    protected final int BUFFER_SIZE = 2048;
    protected static final String mimeSeparation = "SLIDE_MIME_BOUNDARY";
    protected int input = 2048;
    protected int output = 2048;
    protected boolean printContent = true;
    protected VersioningHelper vHelp = null;
    protected String resourcePath;

    public GetMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void displayDirectory() throws IOException {
        String directoryBrowsing = this.config.getInitParameter("directory-browsing");
        if ("true".equalsIgnoreCase(directoryBrowsing)) {
            try {
                DirectoryIndexGenerator directoryIndexGenerator = new DirectoryIndexGenerator(this.token, this.config);
                directoryIndexGenerator.generate(this.req, this.resp, this.slideToken);
            }
            catch (AccessDeniedException e) {
                this.resp.sendError(403);
            }
            catch (ObjectNotFoundException e) {
                this.resp.sendError(404);
            }
            catch (LinkedObjectNotFoundException e) {
                this.resp.sendError(404);
            }
            catch (SlideException e) {
                this.resp.setStatus(500);
            }
        } else {
            this.resp.sendError(403);
        }
    }

    protected void parseRequest() throws WebdavException {
        this.vHelp = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        if (Configuration.useVersionControl()) {
            try {
                String labelHeader = WebdavUtils.fixTomcatHeader(this.requestHeaders.getLabel(), "UTF-8");
                this.resourcePath = this.vHelp.getLabeledResourceUri(this.resourcePath, labelHeader);
            }
            catch (LabeledRevisionNotFoundException e) {
                ViolatedPrecondition violatedPrecondition = new ViolatedPrecondition("must-select-version-in-history", 409);
                try {
                    this.sendPreconditionViolation(new PreconditionViolationException(violatedPrecondition, this.resourcePath));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new WebdavException(409);
            }
            catch (SlideException e) {
                int statusCode = this.getErrorCode((Exception)((Object)e));
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }

    protected void executeRequest() throws WebdavException {
        try {
            if (this.isLockNull(this.resourcePath)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Exception)((Object)e));
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            if (WebdavEvent.GET.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.GET, (EventObject)new WebdavEvent(this));
            }
            this.structure.retrieve(this.slideToken, this.resourcePath);
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, this.resourcePath);
            if (revisionDescriptors.hasRevisions()) {
                NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                if (revisionDescriptor != null) {
                    if (revisionDescriptor.propertyValueContains("resourcetype", "<collection/>")) {
                        this.displayDirectory();
                    } else {
                        AbstractWebdavMethod.ResourceInfo resourceInfo = new AbstractWebdavMethod.ResourceInfo(this.resourcePath, revisionDescriptor);
                        if (!this.checkIfHeaders(this.req, this.resp, resourceInfo)) {
                            return;
                        }
                        ServletOutputStream os = this.resp.getOutputStream();
                        InputStream is = null;
                        if (this.printContent) {
                            is = this.content.retrieve(this.slideToken, revisionDescriptors, revisionDescriptor).streamContent();
                        }
                        Vector ranges = this.parseRange(this.req, this.resp, resourceInfo);
                        this.resp.setHeader("ETag", this.getETag(resourceInfo, true));
                        this.resp.setHeader("Content-Language", revisionDescriptor.getContentLanguage());
                        this.resp.addHeader("Last-Modified", revisionDescriptor.getLastModified().toString());
                        this.resp.setBufferSize(this.output);
                        if (ranges == null || ranges.isEmpty()) {
                            this.resp.setContentType(revisionDescriptor.getContentType());
                            this.resp.setContentLength((int)revisionDescriptor.getContentLength());
                            if (this.printContent) {
                                this.copy(resourceInfo, is, os);
                            }
                        } else {
                            this.resp.setStatus(206);
                            if (ranges.size() == 1) {
                                Range range = (Range)ranges.elementAt(0);
                                this.resp.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.fileLength);
                                this.resp.setContentLength((int)range.length);
                                this.resp.setContentType(revisionDescriptor.getContentType());
                                if (this.printContent) {
                                    this.copy(resourceInfo, is, os, range);
                                }
                            } else {
                                this.resp.setContentType("multipart/byteranges; boundary=SLIDE_MIME_BOUNDARY");
                                if (this.printContent) {
                                    this.copy(resourceInfo, is, os, ranges.elements(), revisionDescriptor.getContentType());
                                }
                            }
                        }
                    }
                } else {
                    this.displayDirectory();
                }
            } else {
                this.displayDirectory();
            }
        }
        catch (Exception e) {
            int statusCode = e instanceof IOException ? 412 : this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected int getErrorCode(Exception ex) {
        try {
            throw ex;
        }
        catch (RevisionNotFoundException e) {
            return 404;
        }
        catch (RevisionContentNotFoundException e) {
            return 404;
        }
        catch (RevisionDescriptorNotFoundException e) {
            return 404;
        }
        catch (LinkedObjectNotFoundException e) {
            return 404;
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }

    private void copy(AbstractWebdavMethod.ResourceInfo resourceInfo, InputStream resourceInputStream, ServletOutputStream ostream) throws IOException {
        IOException exception = null;
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ostream.flush();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ostream.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(AbstractWebdavMethod.ResourceInfo resourceInfo, InputStream resourceInputStream, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
        exception = this.copyRange(istream, ostream, range.start, range.end);
        try {
            ((InputStream)istream).close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ostream.flush();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ostream.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(AbstractWebdavMethod.ResourceInfo resourceInfo, InputStream resourceInputStream, ServletOutputStream ostream, Enumeration ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasMoreElements()) {
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.input);
            Range currentRange = (Range)ranges.nextElement();
            ostream.println("--SLIDE_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.fileLength);
            ostream.println();
            exception = this.copyRange(istream, ostream, currentRange.start, currentRange.end);
            try {
                ((InputStream)istream).close();
            }
            catch (Throwable t) {}
        }
        ostream.print("--SLIDE_MIME_BOUNDARY--");
        try {
            ostream.flush();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            ostream.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    private IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[this.input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    private Vector parseRange(HttpServletRequest request, HttpServletResponse response, AbstractWebdavMethod.ResourceInfo resourceInfo) throws IOException, WebdavException {
        long fileLength;
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            headerValue = headerValue.trim();
            long lastModified = resourceInfo.date;
            Date date = this.parseHttpDate(headerValue);
            if (date == null ? (headerValue.startsWith("\"") ? !this.getETag(resourceInfo, true).equals(headerValue) : !this.getETagValue(resourceInfo, true).equals(headerValue)) : lastModified > date.getTime() + 1000L) {
                return null;
            }
        }
        if ((fileLength = resourceInfo.length) == 0L) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.sendError(416);
            throw new WebdavException(416);
        }
        rangeHeader = rangeHeader.substring(6);
        Vector<Range> result = new Vector<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken();
            Range currentRange = new Range();
            currentRange.fileLength = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.sendError(416);
                throw new WebdavException(416);
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.sendError(416);
                    throw new WebdavException(416);
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.sendError(416);
                throw new WebdavException(416);
            }
            currentRange.length = currentRange.end - currentRange.start + 1L;
            if (!currentRange.validate()) {
                response.sendError(416);
                throw new WebdavException(416);
            }
            result.addElement(currentRange);
        }
        return result;
    }

    private static class Range {
        public long start;
        public long end;
        public long length;
        public long fileLength;

        private Range() {
        }

        public boolean validate() {
            return this.start >= 0L && this.end >= 0L && this.length > 0L && this.start <= this.end && this.end < this.fileLength && this.fileLength >= this.length;
        }
    }
}

