/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractMultistatusResponseMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.LabeledRevisionNotFoundException;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Version;
import org.apache.slide.webdav.util.resourcekind.VersionControlled;
import org.jdom.Element;
import org.jdom.JDOMException;

public class LabelMethod
extends AbstractMultistatusResponseMethod
implements DeltavConstants,
WriteMethod {
    public static final String LABEL_MISSING = "Label missing";
    public static final String LABEL_MUST_CONTAIN_EITHER_ADD_SET_OR_REMOVE = "Request content <label> element must contain either <add>, <set> or <remove>";
    private String resourcePath;
    protected boolean isCollection = false;
    protected VersioningHelper versioningHelper = null;
    protected String operation = null;
    protected String label = null;
    protected String labelHeader = null;

    public LabelMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        this.labelHeader = WebdavUtils.fixTomcatHeader(this.requestHeaders.getLabel(), "UTF-8");
        try {
            Element root = this.parseRequestContent("label");
            Element current = root.getChild("add", DNSP);
            Element operationElement = null;
            if (current != null) {
                operationElement = current;
            }
            if ((current = root.getChild("set", DNSP)) != null) {
                if (operationElement != null) {
                    throw new JDOMException(LABEL_MUST_CONTAIN_EITHER_ADD_SET_OR_REMOVE);
                }
                operationElement = current;
            }
            if ((current = root.getChild("remove", DNSP)) != null) {
                if (operationElement != null) {
                    throw new JDOMException(LABEL_MUST_CONTAIN_EITHER_ADD_SET_OR_REMOVE);
                }
                operationElement = current;
            }
            if (operationElement == null) {
                throw new JDOMException(LABEL_MUST_CONTAIN_EITHER_ADD_SET_OR_REMOVE);
            }
            this.operation = operationElement.getName();
            Element labelName = operationElement.getChild("label-name", DNSP);
            if (labelName == null || labelName.getText() == null || labelName.getText().length() == 0) {
                throw new JDOMException(LABEL_MISSING);
            }
            this.label = labelName.getText();
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.resourcePath)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Throwable)e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        this.isCollection = this.isCollection(this.resourcePath);
        try {
            if (WebdavEvent.LABEL.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.LABEL, (EventObject)new WebdavEvent(this));
            }
            this.labelResource(this.resourcePath);
        }
        catch (NestedSlideException nestedSlideException) {
            if (LabelMethod.generateMultiStatusResponse(this.isCollection, nestedSlideException, this.requestUri)) {
                String errorMessage = this.generateErrorMessage(nestedSlideException);
                this.resp.setStatus(207);
                try {
                    this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                    this.resp.getWriter().write(errorMessage);
                }
                catch (IOException ex) {
                    int statusCode = 500;
                    this.sendError(statusCode, ex);
                    throw new WebdavException(statusCode);
                }
            } else {
                SlideException exception = (SlideException)((Object)nestedSlideException.enumerateExceptions().nextElement());
                if (exception instanceof PreconditionViolationException) {
                    try {
                        this.sendPreconditionViolation((PreconditionViolationException)exception);
                    }
                    catch (IOException ex) {
                        int statusCode = 500;
                        this.sendError(statusCode, ex);
                        throw new WebdavException(statusCode);
                    }
                } else {
                    int statusCode = this.getErrorCode(exception);
                    this.sendError(statusCode, exception);
                    throw new WebdavException(statusCode);
                }
            }
            throw new WebdavException(202, false);
        }
        catch (SlideException x) {
            int statusCode = this.getErrorCode(x);
            this.sendError(statusCode, x);
            throw new WebdavException(statusCode);
        }
        finally {
            this.resp.setHeader("Cache-Control", "no-cache");
        }
    }

    protected void labelResource(String resourcePath) throws NestedSlideException {
        NestedSlideException nestedSlideException = new NestedSlideException(null);
        try {
            this.labelResource(resourcePath, this.getDepth(), nestedSlideException);
        }
        catch (WebdavException e) {
            nestedSlideException.addException((SlideException)e);
        }
        if (!nestedSlideException.isEmpty()) {
            throw nestedSlideException;
        }
    }

    protected void labelResource(String resourcePath, int depth, NestedSlideException nestedSlideException) {
        try {
            ObjectNode currentNode;
            Enumeration childrenEnum;
            if (!this.isCollection(resourcePath)) {
                ViolatedPrecondition violatedPrecondition = this.getPreconditionViolation(resourcePath);
                if (violatedPrecondition != null) {
                    throw new PreconditionViolationException(violatedPrecondition, resourcePath);
                }
                this.performLabelOperation(resourcePath);
            } else if (depth > 0 && (childrenEnum = this.structure.getChildren(this.slideToken, currentNode = this.structure.retrieve(this.slideToken, resourcePath))) != null) {
                while (childrenEnum.hasMoreElements()) {
                    this.labelResource(((ObjectNode)childrenEnum.nextElement()).getUri(), depth - 1, nestedSlideException);
                }
            }
        }
        catch (SlideException e) {
            nestedSlideException.addException(e);
        }
        catch (JDOMException e) {
            nestedSlideException.addException(new SlideException(e.getMessage()));
        }
    }

    private void performLabelOperation(String resourcePath) throws JDOMException, SlideException {
        NodeRevisionDescriptor revisionDescriptor;
        String labelHeader = WebdavUtils.fixTomcatHeader(this.requestHeaders.getLabel(), "UTF-8");
        String labeledResourceUri = this.getResourceUri(resourcePath, labelHeader);
        NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, labeledResourceUri);
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors));
        if (resourceKind instanceof Version) {
            if ("remove".equals(this.operation)) {
                PropertyHelper.removeElementFromProperty(revisionDescriptor, "label-name-set", "label-name", this.label);
                this.content.store(this.slideToken, revisionDescriptors.getUri(), revisionDescriptor, null);
            }
            if ("set".equals(this.operation)) {
                try {
                    NodeRevisionDescriptor alreadyLabeledDescriptor = this.versioningHelper.retrieveLabeledRevision(revisionDescriptors.getUri(), this.label);
                    PropertyHelper.removeElementFromProperty(alreadyLabeledDescriptor, "label-name-set", "label-name", this.label);
                    this.content.store(this.slideToken, revisionDescriptors.getUri(), alreadyLabeledDescriptor, null);
                }
                catch (LabeledRevisionNotFoundException e) {
                    // empty catch block
                }
            }
            if ("add".equals(this.operation) || "set".equals(this.operation)) {
                PropertyHelper.addElementToProperty(revisionDescriptor, "label-name-set", "label-name", this.label);
                this.content.store(this.slideToken, revisionDescriptors.getUri(), revisionDescriptor, null);
            }
        }
    }

    protected ViolatedPrecondition getPreconditionViolation(String resourcePath) throws SlideException {
        ViolatedPrecondition violatedPrecondition;
        block10: {
            NodeRevisionDescriptor revisionDescriptor;
            violatedPrecondition = null;
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, resourcePath);
            ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors));
            if (resourceKind instanceof VersionControlled && !(resourceKind instanceof CheckedInVersionControlled)) {
                return new ViolatedPrecondition("must-be-checked-in", 409);
            }
            if (resourceKind instanceof VersionControlled && this.labelHeader != null) {
                try {
                    this.versioningHelper.getLabeledResourceUri(resourcePath, this.labelHeader);
                }
                catch (LabeledRevisionNotFoundException e) {
                    return new ViolatedPrecondition("must-select-version-in-history", 409);
                }
            }
            try {
                String slideResourceUri = this.getResourceUri(resourcePath, this.labelHeader);
                revisionDescriptors = this.content.retrieve(this.slideToken, slideResourceUri);
                revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor);
                if (!(resourceKind instanceof Version)) break block10;
                if ("remove".equals(this.operation) && !this.hasLabel(revisionDescriptor, this.label)) {
                    return new ViolatedPrecondition("label-must-exist", 409);
                }
                try {
                    this.versioningHelper.retrieveLabeledRevision(revisionDescriptors.getUri(), this.label);
                    if ("add".equals(this.operation)) {
                        return new ViolatedPrecondition("must-be-new-label", 409);
                    }
                }
                catch (LabeledRevisionNotFoundException e) {}
            }
            catch (LabeledRevisionNotFoundException e) {
                if (!"remove".equals(this.operation)) break block10;
                return new ViolatedPrecondition("label-must-exist", 409);
            }
        }
        return violatedPrecondition;
    }

    private int getDepth() throws WebdavException {
        return this.requestHeaders.getDepth(0);
    }

    protected boolean hasLabel(NodeRevisionDescriptor revisionDescriptor, String label) {
        boolean containsLabel = false;
        NodeProperty labelNameSetProperty = revisionDescriptor.getProperty("label-name-set");
        if (labelNameSetProperty != null && labelNameSetProperty.getValue() != null) {
            try {
                XMLValue xmlValue = new XMLValue(labelNameSetProperty.getValue().toString());
                Iterator iterator = xmlValue.iterator();
                while (!containsLabel && iterator.hasNext()) {
                    containsLabel = label.equals(((Element)iterator.next()).getText());
                }
            }
            catch (JDOMException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return containsLabel;
    }

    protected String getResourceUri(String resourcePath, String label) throws SlideException {
        NodeRevisionDescriptor revisionDescriptor;
        String labeledResourceUri = this.versioningHelper.getLabeledResourceUri(resourcePath, label);
        NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, labeledResourceUri);
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors));
        if (resourceKind instanceof VersionControlled) {
            labeledResourceUri = this.versioningHelper.getUriOfAssociatedVR(resourcePath);
        }
        return labeledResourceUri;
    }
}

