/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.transaction.Transaction;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.NestedSlideException;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.VetoException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectIsAlreadyLockedException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.transaction.ExternalTransactionContext;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractMultistatusResponseMethod;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.WebdavConstants;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class LockMethod
extends AbstractMultistatusResponseMethod
implements WebdavConstants,
WriteMethod {
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int MAX_TIMEOUT = Integer.MAX_VALUE;
    private static final int DEFAULT_TIMEOUT = Integer.MAX_VALUE;
    public static final String DEFAULT_LOCK_OWNER = "";
    private int depth;
    private int lockType;
    private int lockDuration = Integer.MAX_VALUE;
    private String lockInfo_lockScope;
    private String lockInfo_lockType;
    private String lockInfo_lockOwner;
    private String lockInfo_lockSubject;
    protected PropertyHelper propertyHelper = null;

    public LockMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.propertyHelper = PropertyHelper.getPropertyHelper(this.slideToken, this.token, this.getConfig());
        this.lockInfo_lockSubject = this.requestUri;
        if (this.lockInfo_lockSubject == null) {
            this.lockInfo_lockSubject = "/";
        }
        this.depth = this.requestHeaders.getDepth(Integer.MAX_VALUE);
        if (this.depth != 0 && this.depth != Integer.MAX_VALUE) {
            int sc = 412;
            this.sendError(sc, "Invalid header Depth: " + this.depth);
            throw new WebdavException(sc);
        }
        this.lockDuration = this.requestHeaders.getTimeout(Integer.MAX_VALUE);
        if (this.req.getContentLength() > 0 || this.isRequestChunked()) {
            this.parseLockInfo();
        } else {
            this.lockType = 1;
        }
    }

    private void parseLockInfo() throws WebdavException {
        this.lockType = 0;
        try {
            Iterator childrenIterator = this.parseRequestContent("lockinfo").getChildren().iterator();
            while (childrenIterator.hasNext()) {
                Element currentElement = (Element)childrenIterator.next();
                if ("lockscope".equals(currentElement.getName())) {
                    this.parseLockScope(currentElement);
                    continue;
                }
                if ("locktype".equals(currentElement.getName())) {
                    this.parseLockType(currentElement);
                    continue;
                }
                if (!"owner".equals(currentElement.getName())) continue;
                this.parseOwner(currentElement);
            }
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    private void parseLockScope(Element lockScopeElement) throws JDOMException {
        if (lockScopeElement == null) {
            throw new JDOMException("Expected <lockscope> element");
        }
        List children = lockScopeElement.getChildren();
        if (children.size() != 1) {
            throw new JDOMException("<lockscope> must have exactly one child element");
        }
        this.lockInfo_lockScope = ((Element)children.get(0)).getName();
        if (!("exclusive".equals(this.lockInfo_lockScope) || "shared".equals(this.lockInfo_lockScope) || "local".equals(this.lockInfo_lockScope))) {
            throw new JDOMException("<lockscope> can only contain one of <exclusive> or <shared> or <local>");
        }
    }

    private void parseLockType(Element lockTypeElement) throws JDOMException {
        if (lockTypeElement == null) {
            throw new JDOMException("Expected <locktype> element");
        }
        List children = lockTypeElement.getChildren();
        if (children.size() != 1) {
            throw new JDOMException("<locktype> must have exactly one child element");
        }
        String lockTypeName = ((Element)children.get(0)).getName();
        if (!"write".equals(lockTypeName) && !"transaction".equals(lockTypeName)) {
            throw new JDOMException("Only write and transaction locks are supported");
        }
        this.lockInfo_lockType = ((Element)children.get(0)).getName();
    }

    private void parseOwner(Element ownerElement) throws JDOMException {
        if (ownerElement == null) {
            this.lockInfo_lockOwner = DEFAULT_LOCK_OWNER;
            return;
        }
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xmlOutputter = new XMLOutputter();
        try {
            xmlOutputter.outputElementContent(ownerElement, (Writer)stringWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lockInfo_lockOwner = stringWriter.toString();
        if (this.lockInfo_lockOwner.length() == 0) {
            this.lockInfo_lockOwner = DEFAULT_LOCK_OWNER;
        }
    }

    protected void executeRequest() throws WebdavException {
        this.slideToken.setForceStoreEnlistment(true);
        SubjectNode toLockSubject = null;
        boolean isCollection = this.isCollection(this.lockInfo_lockSubject);
        boolean inheritance = false;
        Date lockDate = null;
        switch (this.lockType) {
            case 0: {
                if (this.lockInfo_lockType.equals("transaction")) {
                    try {
                        NamespaceConfig namespaceConfig = this.token.getNamespaceConfig();
                        toLockSubject = this.getToLockSubject();
                        if (lockDate == null) {
                            lockDate = new Date(new Date().getTime() + (long)this.lockDuration * 1000L);
                        }
                        NodeLock lockToken = new NodeLock(toLockSubject.getUri(), ((SubjectNode)this.security.getPrincipal(this.slideToken)).getUri(), namespaceConfig.getCreateObjectAction().getUri(), lockDate, inheritance, 2, this.lockInfo_lockOwner);
                        this.token.setTransactionTimeout(this.lockDuration * 1000);
                        Transaction transaction = this.token.getTransactionManager().suspend();
                        String fullTxId = "<opaquelocktoken:" + lockToken.getLockId() + ">";
                        ExternalTransactionContext.registerContext((Object)fullTxId, (Transaction)transaction);
                        this.slideToken.setExternalTx();
                        this.resp.setHeader("Lock-Token", fullTxId);
                        this.showLockDiscoveryInfo(lockToken);
                        break;
                    }
                    catch (Exception e) {
                        int statusCode = this.getErrorCode(e);
                        this.sendError(statusCode, e);
                        throw new WebdavException(statusCode);
                    }
                }
                if (!this.lockInfo_lockType.equals("write")) break;
                try {
                    boolean exclusive;
                    if (!this.checkIfHeaders()) {
                        return;
                    }
                    NamespaceConfig namespaceConfig = this.token.getNamespaceConfig();
                    toLockSubject = this.getToLockSubject();
                    NodeLock lockToken = null;
                    inheritance = this.depth != 0;
                    boolean bl = exclusive = !this.lockInfo_lockScope.equals("shared");
                    if (lockDate == null) {
                        lockDate = new Date(new Date().getTime() + (long)this.lockDuration * 1000L);
                    }
                    lockToken = new NodeLock((ObjectNode)toLockSubject, (SubjectNode)this.security.getPrincipal(this.slideToken), namespaceConfig.getCreateObjectAction(), lockDate, inheritance, exclusive, this.lockInfo_lockOwner);
                    this.lock.lock(this.slideToken, lockToken);
                    this.resp.setHeader("Lock-Token", "<opaquelocktoken:" + lockToken.getLockId() + ">");
                    this.resp.setStatus(200);
                    this.showLockDiscoveryInfo(lockToken);
                    break;
                }
                catch (ObjectIsAlreadyLockedException e) {
                    if (inheritance && LockMethod.generateMultiStatusResponse(isCollection, (NestedSlideException)((Object)e), this.requestUri)) {
                        String errorMessage = this.generateErrorMessage((NestedSlideException)((Object)e));
                        this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                        this.resp.setStatus(207);
                        try {
                            this.resp.getWriter().write(errorMessage);
                        }
                        catch (IOException ex) {
                            int statusCode = 500;
                            this.sendError(statusCode, e);
                            throw new WebdavException(statusCode);
                        }
                    } else {
                        this.resp.setStatus(423);
                    }
                    throw new WebdavException(202, false);
                }
                catch (Exception e) {
                    int statusCode = this.getErrorCode(e);
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
            case 1: {
                try {
                    Enumeration lockTokens = this.lock.enumerateLocks(this.slideToken, this.lockInfo_lockSubject, false);
                    NodeLock currentLockToken = null;
                    Date newExpirationDate = new Date(new Date().getTime() + (long)this.lockDuration * 1000L);
                    while (lockTokens.hasMoreElements()) {
                        currentLockToken = (NodeLock)lockTokens.nextElement();
                        this.lock.renew(this.slideToken, currentLockToken, newExpirationDate);
                    }
                    this.showLockDiscoveryInfo(currentLockToken);
                    break;
                }
                catch (SlideException e) {
                    int statusCode = 412;
                    this.sendError(statusCode, e);
                    throw new WebdavException(statusCode);
                }
            }
        }
    }

    protected SubjectNode getToLockSubject() throws ObjectAlreadyExistsException, ObjectNotFoundException, AccessDeniedException, RevisionAlreadyExistException, LinkedObjectNotFoundException, ObjectLockedException, ServiceAccessException, VetoException {
        SubjectNode toLockSubject;
        try {
            toLockSubject = (SubjectNode)this.structure.retrieve(this.slideToken, this.lockInfo_lockSubject);
        }
        catch (ObjectNotFoundException ex) {
            toLockSubject = new SubjectNode();
            this.structure.create(this.slideToken, (ObjectNode)toLockSubject, this.lockInfo_lockSubject);
            NodeRevisionDescriptor revisionDescriptor = new NodeRevisionDescriptor(0L);
            XMLValue lockNull = new XMLValue(new Element("lock-null", DNSP));
            revisionDescriptor.setResourceType(lockNull.toString());
            NodeRevisionContent nrc = new NodeRevisionContent();
            nrc.setContent(new byte[0]);
            this.content.create(this.slideToken, this.lockInfo_lockSubject, revisionDescriptor, nrc);
        }
        return toLockSubject;
    }

    protected int getErrorCode(Exception ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException e) {
            return 412;
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }

    protected void showLockDiscoveryInfo(NodeLock token) throws WebdavException {
        Element prop = new Element("prop", DNSP);
        Element lockdiscovery = new Element("lockdiscovery", DNSP);
        prop.addContent((Content)lockdiscovery);
        XMLValue xmlValue = this.propertyHelper.computeLockDiscovery(token, this.getSlideContextPath());
        Iterator iterator = xmlValue.iterator();
        while (iterator.hasNext()) {
            lockdiscovery.addContent((Content)((Element)iterator.next()));
        }
        try {
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            PrintWriter writer = this.resp.getWriter();
            Format format = Format.getPrettyFormat();
            format.setIndent("    ");
            new XMLOutputter(format).output(new Document(prop), (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    private boolean checkIfHeaders() throws AccessDeniedException, LinkedObjectNotFoundException, ServiceAccessException, ObjectLockedException, VetoException, IOException {
        try {
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, this.requestUri);
            NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
            if (revisionDescriptor != null) {
                AbstractWebdavMethod.ResourceInfo resourceInfo = new AbstractWebdavMethod.ResourceInfo(this.requestUri, revisionDescriptor);
                return this.checkIfHeaders(this.req, this.resp, resourceInfo);
            }
            return this.checkIfHeaders(this.req, this.resp, new AbstractWebdavMethod.ResourceInfo(this.requestUri));
        }
        catch (RevisionDescriptorNotFoundException e) {
            return this.checkIfHeaders(this.req, this.resp, new AbstractWebdavMethod.ResourceInfo(this.requestUri));
        }
        catch (ObjectNotFoundException e) {
            return this.checkIfHeaders(this.req, this.resp, new AbstractWebdavMethod.ResourceInfo(this.requestUri));
        }
    }
}

