/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.Date;
import java.util.EventObject;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;

public class MkcolMethod
extends AbstractWebdavMethod
implements DeltavConstants,
WriteMethod {
    protected String colName;

    public MkcolMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        if (this.req.getContentLength() > 0) {
            int statusCode = 415;
            this.sendError(statusCode, this.getClass().getName() + ".requestBodyMustBeEmpty");
            throw new WebdavException(statusCode);
        }
        this.colName = this.requestUri;
        if (this.colName == null) {
            this.colName = "/";
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        UriHandler destinationUriHandler;
        this.slideToken.setForceStoreEnlistment(true);
        NodeRevisionDescriptor revisionDescriptor = null;
        boolean isLockNull = false;
        try {
            revisionDescriptor = this.content.retrieve(this.slideToken, this.content.retrieve(this.slideToken, this.colName));
            isLockNull = this.isLockNull(revisionDescriptor);
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Exception)((Object)e));
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (SlideException e) {
            // empty catch block
        }
        if (revisionDescriptor == null) {
            revisionDescriptor = new NodeRevisionDescriptor(0L);
        }
        if ((destinationUriHandler = UriHandler.getUriHandler(this.colName)).isRestrictedUri()) {
            int statusCode = 403;
            this.sendError(statusCode, this.getClass().getName() + ".restrictedDestinationUri", new Object[]{this.colName});
            throw new WebdavException(statusCode);
        }
        revisionDescriptor.setResourceType("<collection/>");
        revisionDescriptor.setCreationDate(new Date());
        revisionDescriptor.setLastModified(new Date());
        revisionDescriptor.setContentLength(0L);
        revisionDescriptor.setSource("");
        try {
            String creator = ((SubjectNode)this.security.getPrincipal(this.slideToken)).getPath().lastSegment();
            revisionDescriptor.setCreationUser(creator);
            revisionDescriptor.setOwner(creator);
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        if (Configuration.useVersionControl()) {
            VersioningHelper vHelp = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
            vHelp.setWorkspaceProperty(this.colName, revisionDescriptor);
        }
        if (this.isMsProprietarySupport()) {
            NodeProperty property = null;
            property = new NodeProperty("ishidden", (Object)"0", "MICROSOFT");
            revisionDescriptor.setProperty(property);
            property = new NodeProperty("iscollection", (Object)"1", "MICROSOFT");
            revisionDescriptor.setProperty(property);
            property = new NodeProperty("isreadonly", (Object)"0", "MICROSOFT");
            revisionDescriptor.setProperty(property);
            property = new NodeProperty("lastaccessed", (Object)new Date().toString(), "MICROSOFT");
            revisionDescriptor.setProperty(property);
        }
        this.resp.setStatus(201);
        try {
            if (WebdavEvent.MKCOL.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.MKCOL, (EventObject)new WebdavEvent(this));
            }
            if (!isLockNull) {
                SubjectNode collection = new SubjectNode();
                this.structure.create(this.slideToken, (ObjectNode)collection, this.colName);
                this.content.create(this.slideToken, this.colName, revisionDescriptor, null);
            } else {
                this.content.store(this.slideToken, this.colName, revisionDescriptor, null);
            }
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected int getErrorCode(Exception ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException e) {
            return 409;
        }
        catch (LinkedObjectNotFoundException e) {
            return 404;
        }
        catch (ObjectAlreadyExistsException e) {
            return 405;
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }
}

