/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.VersioningHelper;

public class MkworkspaceMethod
extends AbstractWebdavMethod
implements DeltavConstants,
WriteMethod {
    private String resourcePath;

    public MkworkspaceMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.resourcePath)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Throwable)e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            VersioningHelper vh = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
            vh.mkworkspace(this.resourcePath);
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        finally {
            this.resp.setHeader("Cache-Control", "no-cache");
        }
    }
}

