/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Writer;
import java.util.EventObject;
import java.util.Iterator;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.search.SearchLanguage;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.ReadMethod;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.BindConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.HistoryPathHandler;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.WorkspacePathHandler;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class OptionsMethod
extends AbstractWebdavMethod
implements DeltavConstants,
AclConstants,
BindConstants,
ReadMethod {
    private XMLOutputter xmlOut;
    private boolean versionHistoryCollectionSetRequested = false;
    private boolean workspaceCollectionSetRequested = false;
    private boolean responseBodyNeeded = false;

    public OptionsMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
        Format format = Format.getPrettyFormat();
        format.setIndent("    ");
        this.xmlOut = new XMLOutputter(format);
    }

    protected void parseRequest() throws WebdavException {
        if (this.req.getContentLength() > 0 || this.isRequestChunked()) {
            try {
                Iterator i = this.parseRequestContent("options").getChildren().iterator();
                while (i.hasNext()) {
                    Element e = (Element)i.next();
                    if (e.getName().equals("version-history-collection-set")) {
                        this.versionHistoryCollectionSetRequested = true;
                    }
                    if (!e.getName().equals("workspace-collection-set")) continue;
                    this.workspaceCollectionSetRequested = true;
                }
                if (this.versionHistoryCollectionSetRequested || this.workspaceCollectionSetRequested) {
                    this.responseBodyNeeded = true;
                }
            }
            catch (JDOMException e) {
                int statusCode = 400;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (IOException e) {
                int statusCode = 500;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }

    protected void executeRequest() throws WebdavException {
        String resourceUri;
        StringBuffer davHeader = new StringBuffer();
        davHeader.append("1");
        if (Configuration.useIntegratedLocking()) {
            davHeader.append(", ").append("2");
        }
        davHeader.append(", ").append("slide");
        if (Configuration.useIntegratedSecurity()) {
            davHeader.append(", ").append("access-control");
        }
        if (Configuration.useGlobalBinding()) {
            davHeader.append(", ").append("binding");
        }
        this.resp.addHeader("DAV", davHeader.toString());
        if (Configuration.useVersionControl()) {
            davHeader = new StringBuffer();
            davHeader.append("version-control");
            davHeader.append(", ").append("version-history");
            davHeader.append(", ").append("checkout-in-place");
            this.resp.addHeader("DAV", davHeader.toString());
            davHeader = new StringBuffer();
            davHeader.append("workspace");
            davHeader.append(", ").append("working-resource");
            davHeader.append(", ").append("update");
            davHeader.append(", ").append("label");
            this.resp.addHeader("DAV", davHeader.toString());
        }
        if ((resourceUri = this.requestUri) == null) {
            resourceUri = "/";
        }
        boolean resourceExists = false;
        SearchLanguage[] languages = this.token.getSearchHelper().getSupportedLanguages();
        ResourceKind resourceKind = null;
        try {
            if (WebdavEvent.OPTIONS.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.OPTIONS, (EventObject)new WebdavEvent(this));
            }
            NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, resourceUri);
            NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
            resourceKind = AbstractResourceKind.determineResourceKind(this.token, revisionDescriptors, revisionDescriptor);
            resourceExists = true;
        }
        catch (SlideException e) {
            resourceExists = resourceUri.equals("/");
        }
        StringBuffer methodsAllowed = new StringBuffer();
        if (resourceKind != null) {
            Iterator methodIterator = resourceKind.getSupportedMethods().iterator();
            while (methodIterator.hasNext()) {
                methodsAllowed.append((String)methodIterator.next());
                methodsAllowed.append(", ");
            }
            if (methodsAllowed.length() > 1) {
                methodsAllowed.setLength(methodsAllowed.length() - 2);
            }
        } else {
            methodsAllowed.append("OPTIONS, MKCOL, PUT");
            if (Configuration.useIntegratedLocking()) {
                methodsAllowed.append(", LOCK");
            }
        }
        this.resp.addHeader("Allow", methodsAllowed.toString());
        if (Configuration.useSearch() && languages != null && resourceExists) {
            for (int i = 0; i < languages.length; ++i) {
                this.resp.addHeader("DASL", "<" + languages[i].getGrammarUri() + languages[i].getName() + ">");
            }
        }
        this.resp.addHeader("MS-Author-Via", "DAV");
        if (this.responseBodyNeeded) {
            Element hre;
            Iterator i;
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            UriHandler uh = UriHandler.getUriHandler(resourceUri);
            String storeName = uh.getAssociatedBaseStoreName(this.token.getName());
            HistoryPathHandler hpath = HistoryPathHandler.getHistoryPathHandler();
            WorkspacePathHandler wspath = WorkspacePathHandler.getWorkspacePathHandler();
            Element ore = new Element("options-response", DNSP);
            if (this.versionHistoryCollectionSetRequested) {
                Element vhcse = new Element("version-history-collection-set", DNSP);
                i = hpath.getResolvedHistoryPaths(storeName).iterator();
                while (i.hasNext()) {
                    hre = new Element("href", DNSP);
                    hre.addContent(this.getFullPath(String.valueOf(i.next())));
                    vhcse.addContent((Content)hre);
                }
                ore.addContent((Content)vhcse);
            }
            if (this.workspaceCollectionSetRequested) {
                Element wscse = new Element("workspace-collection-set", DNSP);
                i = wspath.getResolvedWorkspacePaths(storeName).iterator();
                while (i.hasNext()) {
                    hre = new Element("href", DNSP);
                    hre.addContent(this.getFullPath(String.valueOf(i.next())));
                    wscse.addContent((Content)hre);
                }
                ore.addContent((Content)wscse);
            }
            try {
                this.xmlOut.output(new Document(ore), (Writer)this.resp.getWriter());
            }
            catch (IOException e) {
                int statusCode = 500;
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
        }
    }
}

