/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.EventObject;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.CheckedInVersionControlled;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;

public class PutMethod
extends AbstractWebdavMethod
implements DeltavConstants,
WriteMethod {
    protected VersioningHelper versioningHelper = null;
    protected String resourcePath;

    public PutMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        UriHandler destUh = UriHandler.getUriHandler(this.resourcePath);
        if (destUh.isRestrictedUri()) {
            boolean sendError = true;
            if (destUh.isWorkingresourceUri()) {
                try {
                    this.content.retrieve(this.slideToken, this.resourcePath);
                    sendError = false;
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (sendError) {
                int statusCode = 403;
                this.sendError(statusCode, this.getClass().getName() + ".restrictedDestinationUri", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        try {
            if (WebdavEvent.PUT.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.PUT, (EventObject)new WebdavEvent(this));
            }
            try {
                boolean isLockedNullResource = false;
                NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.slideToken, this.resourcePath);
                NodeRevisionNumber revisionNumber = revisionDescriptors.getLatestRevision();
                NodeRevisionDescriptor oldRevisionDescriptor = null;
                if (revisionNumber != null) {
                    try {
                        oldRevisionDescriptor = this.content.retrieve(this.slideToken, revisionDescriptors);
                    }
                    catch (RevisionDescriptorNotFoundException e) {
                        // empty catch block
                    }
                }
                if (WebdavUtils.isCollection(oldRevisionDescriptor)) {
                    int statusCode = 405;
                    this.sendError(statusCode, this.getClass().getName() + ".mustNotBeCollection");
                    throw new WebdavException(statusCode);
                }
                NodeRevisionDescriptor revisionDescriptor = null;
                if (oldRevisionDescriptor == null) {
                    revisionDescriptor = new NodeRevisionDescriptor();
                } else {
                    revisionDescriptor = oldRevisionDescriptor;
                    revisionDescriptor.setContentLength(-1L);
                }
                AbstractWebdavMethod.ResourceInfo resourceInfo = new AbstractWebdavMethod.ResourceInfo(this.resourcePath, revisionDescriptor);
                if (!this.checkIfHeaders(this.req, this.resp, resourceInfo)) {
                    return;
                }
                ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, this.resourcePath, revisionDescriptor);
                this.versioningHelper.isWriteLocked(this.slideToken, revisionDescriptors);
                ViolatedPrecondition violatedPrecondition = this.getPreconditionViolation(revisionDescriptors, revisionDescriptor, resourceKind);
                if (violatedPrecondition != null) {
                    throw new PreconditionViolationException(violatedPrecondition, this.resourcePath);
                }
                boolean mustCheckIn = false;
                if (Configuration.useVersionControl() && resourceKind instanceof CheckedInVersionControlled && this.versioningHelper.mustCheckoutAutoVersionedVCR(revisionDescriptors, revisionDescriptor)) {
                    this.versioningHelper.checkout(revisionDescriptors, revisionDescriptor, false, false, true);
                    mustCheckIn = this.versioningHelper.mustCheckinAutoVersionedVCR(this.slideToken, revisionDescriptors, revisionDescriptor);
                }
                NodeRevisionContent revisionContent = new NodeRevisionContent();
                revisionContent.setContent((InputStream)this.req.getInputStream());
                int contentLength = this.req.getContentLength();
                if (contentLength == -1) {
                    contentLength = revisionContent.getContentBytes().length;
                }
                revisionDescriptor.setContentLength((long)contentLength);
                revisionDescriptor.setLastModified(new Date());
                revisionDescriptor.setETag(PropertyHelper.computeEtag(this.resourcePath, revisionDescriptor));
                String contentType = this.req.getContentType();
                if (contentType == null) {
                    contentType = this.getConfig().getServletContext().getMimeType(this.resourcePath);
                }
                if (contentType == null) {
                    contentType = this.getConfig().getDefaultMimeType();
                }
                revisionDescriptor.setContentType(contentType);
                if (this.isLockNull(revisionDescriptor)) {
                    isLockedNullResource = true;
                    revisionDescriptor.setContentLanguage("en");
                    if (Configuration.useVersionControl()) {
                        this.versioningHelper.setWorkspaceProperty(this.resourcePath, revisionDescriptor);
                    }
                }
                revisionDescriptor.setResourceType("");
                if (isLockedNullResource) {
                    String creator = ((SubjectNode)this.security.getPrincipal(this.slideToken)).getPath().lastSegment();
                    revisionDescriptor.setCreationUser(creator);
                    revisionDescriptor.setOwner(creator);
                }
                this.content.store(this.slideToken, this.resourcePath, revisionDescriptor, revisionContent);
                if (isLockedNullResource && Configuration.useVersionControl() && this.isAutoVersionControl(this.resourcePath) && !this.isExcludedForVersionControl(this.resourcePath)) {
                    this.versioningHelper.versionControl(this.resourcePath);
                }
                if (Configuration.useVersionControl() && mustCheckIn) {
                    this.versioningHelper.checkin(revisionDescriptors, revisionDescriptor, false, false, true);
                }
                this.resp.setHeader("ETag", revisionDescriptor.getETag());
                this.resp.setStatus(204);
            }
            catch (LinkedObjectNotFoundException e) {
                int statusCode = this.getErrorCode((SlideException)((Object)e));
                this.sendError(statusCode, e);
                throw new WebdavException(statusCode);
            }
            catch (ObjectNotFoundException e) {
                SubjectNode subject = new SubjectNode();
                this.structure.create(this.slideToken, (ObjectNode)subject, this.resourcePath);
                NodeRevisionDescriptor revisionDescriptor = new NodeRevisionDescriptor((long)this.req.getContentLength());
                AbstractWebdavMethod.ResourceInfo resourceInfo = new AbstractWebdavMethod.ResourceInfo(this.resourcePath, revisionDescriptor);
                resourceInfo.exists = false;
                if (!this.checkIfHeaders(this.req, this.resp, resourceInfo)) {
                    int statusCode = 412;
                    this.sendError(statusCode, "Check If Header failed");
                    throw new WebdavException(statusCode);
                }
                revisionDescriptor.setResourceType("");
                revisionDescriptor.setSource("");
                revisionDescriptor.setContentLanguage("en");
                String contentType = this.req.getContentType();
                if (contentType == null) {
                    contentType = this.getConfig().getServletContext().getMimeType(this.resourcePath);
                }
                if (contentType == null) {
                    contentType = this.getConfig().getDefaultMimeType();
                }
                revisionDescriptor.setContentType(contentType);
                revisionDescriptor.setLastModified(new Date());
                revisionDescriptor.setETag(PropertyHelper.computeEtag(this.resourcePath, revisionDescriptor));
                revisionDescriptor.setCreationDate(new Date());
                String creator = ((SubjectNode)this.security.getPrincipal(this.slideToken)).getPath().lastSegment();
                revisionDescriptor.setCreationUser(creator);
                revisionDescriptor.setOwner(creator);
                if (Configuration.useVersionControl()) {
                    this.versioningHelper.setWorkspaceProperty(this.resourcePath, revisionDescriptor);
                }
                if (this.isMsProprietarySupport()) {
                    NodeProperty property = null;
                    property = new NodeProperty("ishidden", (Object)"0", "MICROSOFT");
                    revisionDescriptor.setProperty(property);
                    property = new NodeProperty("iscollection", (Object)"0", "MICROSOFT");
                    revisionDescriptor.setProperty(property);
                    property = new NodeProperty("isreadonly", (Object)"0", "MICROSOFT");
                    revisionDescriptor.setProperty(property);
                    property = new NodeProperty("lastaccessed", (Object)new Date().toString(), "MICROSOFT");
                    revisionDescriptor.setProperty(property);
                }
                NodeRevisionContent revisionContent = new NodeRevisionContent();
                revisionContent.setContent((InputStream)this.req.getInputStream());
                int contentLength = this.req.getContentLength();
                if (contentLength == -1) {
                    contentLength = revisionContent.getContentBytes().length;
                }
                revisionDescriptor.setContentLength((long)contentLength);
                this.content.create(this.slideToken, this.resourcePath, revisionDescriptor, revisionContent);
                if (Configuration.useVersionControl() && this.isAutoVersionControl(this.resourcePath) && !this.isExcludedForVersionControl(this.resourcePath)) {
                    this.versioningHelper.versionControl(this.resourcePath);
                }
                this.resp.setHeader("ETag", revisionDescriptor.getETag());
                this.resp.setStatus(201);
            }
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (SlideException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    private ViolatedPrecondition getPreconditionViolation(NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, ResourceKind resourceKind) throws ServiceAccessException {
        if (Configuration.useVersionControl()) {
            UriHandler uriHandler;
            if (resourceKind instanceof CheckedInVersionControlled) {
                String autoVersion = this.versioningHelper.getAutoVersionElementName(revisionDescriptor);
                if (autoVersion == null) {
                    autoVersion = "";
                }
                if (!("checkout-checkin".equals(autoVersion) || "checkout-unlocked-checkin".equals(autoVersion) || "checkout".equals(autoVersion) || "checkout-ignore-unlock".equals(autoVersion) || "locked-checkout".equals(autoVersion))) {
                    return new ViolatedPrecondition("cannot-modify-version-controlled-content", 403);
                }
                if ("locked-checkout".equals(autoVersion) && !this.versioningHelper.isWriteLocked(this.slideToken, revisionDescriptors)) {
                    return new ViolatedPrecondition("cannot-modify-version-controlled-content", 403);
                }
            }
            if ((uriHandler = UriHandler.getUriHandler(this.resourcePath)).isVersionUri()) {
                return new ViolatedPrecondition("cannot-modify-version", 403);
            }
        }
        return null;
    }

    protected int getErrorCode(SlideException ex) {
        try {
            throw ex;
        }
        catch (RevisionAlreadyExistException e) {
            return 409;
        }
        catch (ObjectAlreadyExistsException e) {
            return 409;
        }
        catch (ObjectNotFoundException e) {
            return 409;
        }
        catch (LinkedObjectNotFoundException e) {
            return 404;
        }
        catch (SlideException e) {
            return super.getErrorCode(e);
        }
        catch (Exception e) {
            return super.getErrorCode(e);
        }
    }
}

