/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Writer;
import java.util.EventObject;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.ReadMethod;
import org.apache.slide.webdav.method.report.AbstractReport;
import org.apache.slide.webdav.method.report.AclPrincipalPropSetReport;
import org.apache.slide.webdav.method.report.ExpandPropertyReport;
import org.apache.slide.webdav.method.report.LocateByHistoryReport;
import org.apache.slide.webdav.method.report.PrincipalMatchReport;
import org.apache.slide.webdav.method.report.PrincipalPropertySearchReport;
import org.apache.slide.webdav.method.report.PrincipalSearchPropertySetReport;
import org.apache.slide.webdav.method.report.VersionTreeReport;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.VersioningHelper;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ReportMethod
extends AbstractWebdavMethod
implements DeltavConstants,
AclConstants,
ReadMethod {
    private String resourcePath;
    private AbstractReport reportWorker;
    private String servletPath;
    private VersioningHelper versioningHelper;
    static /* synthetic */ Class class$org$apache$slide$common$SlideToken;
    static /* synthetic */ Class class$org$apache$slide$common$NamespaceAccessToken;
    static /* synthetic */ Class class$org$apache$slide$webdav$WebdavServletConfig;
    static /* synthetic */ Class class$java$lang$String;

    public ReportMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        this.servletPath = this.req.getServletPath();
        this.versioningHelper = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.config);
        try {
            Element reportElm = this.parseRequestContent().getRootElement();
            String reportName = reportElm.getName();
            this.reportWorker = this.getExternalReportWorker(reportName);
            if (this.reportWorker == null) {
                if ("expand-property".equals(reportName)) {
                    this.reportWorker = new ExpandPropertyReport(this.slideToken, this.token, this.config, this.getSlideContextPath());
                } else if ("version-tree".equals(reportName)) {
                    this.reportWorker = new VersionTreeReport(this.slideToken, this.token, this.config, this.getSlideContextPath());
                    ((VersionTreeReport)this.reportWorker).setVersioningHelper(this.versioningHelper);
                } else if ("locate-by-history".equals(reportName)) {
                    this.reportWorker = new LocateByHistoryReport(this.slideToken, this.token, this.config, this.getSlideContextPath());
                } else if ("acl-principal-prop-set".equals(reportName)) {
                    this.reportWorker = new AclPrincipalPropSetReport(this.slideToken, this.token, this.config, this.getSlideContextPath());
                } else if ("principal-match".equals(reportName)) {
                    this.reportWorker = new PrincipalMatchReport(this.slideToken, this.token, this.config, this.getSlideContextPath());
                } else if ("principal-property-search".equals(reportName)) {
                    this.reportWorker = new PrincipalPropertySearchReport(this.slideToken, this.token, this.config, this.getSlideContextPath());
                } else if ("principal-search-property-set".equals(reportName)) {
                    this.reportWorker = new PrincipalSearchPropertySetReport(this.slideToken, this.token, this.config, this.getSlideContextPath());
                }
            }
            if (this.reportWorker == null) {
                int statusCode = 400;
                this.sendError(statusCode, new Exception("Unknown report " + reportName));
                throw new WebdavException(statusCode);
            }
            this.reportWorker.init(this.resourcePath, reportElm);
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (PreconditionViolationException e) {
            try {
                this.sendPreconditionViolation(e);
                throw e;
            }
            catch (IOException x) {
                throw new WebdavException(e.getStatusCode());
            }
        }
    }

    private AbstractReport getExternalReportWorker(String reportName) throws JDOMException, WebdavException {
        AbstractReport result = null;
        String clsName = this.config.getExternalReport(reportName);
        if (clsName != null) {
            try {
                Class<?> cls = Class.forName(clsName);
                Class[] parmtypes = new Class[]{class$org$apache$slide$common$SlideToken == null ? (class$org$apache$slide$common$SlideToken = ReportMethod.class$("org.apache.slide.common.SlideToken")) : class$org$apache$slide$common$SlideToken, class$org$apache$slide$common$NamespaceAccessToken == null ? (class$org$apache$slide$common$NamespaceAccessToken = ReportMethod.class$("org.apache.slide.common.NamespaceAccessToken")) : class$org$apache$slide$common$NamespaceAccessToken, class$org$apache$slide$webdav$WebdavServletConfig == null ? (class$org$apache$slide$webdav$WebdavServletConfig = ReportMethod.class$("org.apache.slide.webdav.WebdavServletConfig")) : class$org$apache$slide$webdav$WebdavServletConfig, class$java$lang$String == null ? (class$java$lang$String = ReportMethod.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ReportMethod.class$("java.lang.String")) : class$java$lang$String};
                Object[] initargs = new Object[]{this.slideToken, this.token, this.config, this.servletPath, this.getSlideContextPath()};
                result = (AbstractReport)cls.getConstructor(parmtypes).newInstance(initargs);
            }
            catch (Exception e) {
                int statusCode = 400;
                this.sendError(statusCode, new Exception("Cannot create " + reportName + " report worker " + clsName + " [" + e + "]"));
                throw new WebdavException(statusCode);
            }
        }
        return result;
    }

    protected void executeRequest() throws WebdavException, IOException {
        try {
            if (this.isLockNull(this.resourcePath)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            Element rootElm;
            if (WebdavEvent.REPORT.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.REPORT, (EventObject)new WebdavEvent(this));
            }
            this.reportWorker.checkPreconditions(this.resourcePath, this.getDepth());
            if (this.reportWorker instanceof PrincipalSearchPropertySetReport) {
                rootElm = new Element("principal-search-property-set", DNSP);
                this.reportWorker.execute(this.resourcePath, rootElm, this.getDepth());
                this.resp.setStatus(200);
            } else {
                rootElm = new Element("multistatus", DNSP);
                this.reportWorker.execute(this.resourcePath, rootElm, this.getDepth());
                this.resp.setStatus(207);
            }
            Format format = Format.getPrettyFormat();
            format.setIndent("    ");
            new XMLOutputter(format).output(new Document(rootElm), (Writer)this.resp.getWriter());
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    private int getDepth() throws WebdavException {
        int depth = this.requestHeaders.getDepth(0);
        if (depth > this.config.getDepthLimit()) {
            depth = this.config.getDepthLimit();
        }
        return depth;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

