/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.io.Writer;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.SlideException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.search.BadGatewayException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.InvalidScopeException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.Search;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchQueryResult;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.StructureException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.ReadMethod;
import org.apache.slide.webdav.util.ComputedPropertyProvider;
import org.apache.slide.webdav.util.PropertyRetriever;
import org.apache.slide.webdav.util.PropertyRetrieverImpl;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.WebdavStatus;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class SearchMethod
extends AbstractWebdavMethod
implements WebdavConstants,
ReadMethod {
    private SearchQuery searchQuery = null;
    private Search searchHelper = null;
    private RequestedProperties requestedProperties = null;
    private PropertyRetriever retriever;
    protected boolean extendedAllprop = false;

    public SearchMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseRequest() throws WebdavException {
        this.searchHelper = this.token.getSearchHelper();
        this.retriever = new PropertyRetrieverImpl(this.token, this.slideToken, this.getConfig());
        String slidePath = null;
        this.extendedAllprop = this.getBooleanInitParameter("extendedAllprop");
        if (Configuration.useSearch()) {
            try {
                Element queryElement = this.getQueryElement();
                String grammarNamespace = queryElement.getNamespaceURI();
                int maxDepth = this.getConfig().getDepthLimit();
                this.searchQuery = this.searchHelper.createSearchQuery(grammarNamespace, queryElement, this.slideToken, maxDepth, (PropertyProvider)new ComputedPropertyProvider(this.token, this.slideToken, this.getSlideContextPath(), this.getConfig()), this.req.getRequestURI());
                this.requestedProperties = this.searchQuery.requestedProperties();
                if (!(this.searchQuery instanceof IBasicQuery)) return;
                QueryScope scope = ((IBasicQuery)this.searchQuery).getScope();
                slidePath = ((IBasicQuery)this.searchQuery).getSlidePath();
                this.token.getContentHelper().retrieve(this.slideToken, slidePath);
                scope.setIsCollection(WebdavUtils.isCollection(this.token, this.slideToken, slidePath));
                return;
            }
            catch (JDOMException e) {
                this.resp.setStatus(400);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(1, e.getMessage());
                throw new WebdavException(400);
            }
            catch (InvalidQueryException e) {
                this.resp.setStatus(422);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(4, e.getMessage());
                throw new WebdavException(422);
            }
            catch (BadGatewayException e) {
                this.resp.setStatus(502);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(5, e.getMessage());
                throw new WebdavException(502);
            }
            catch (InvalidScopeException e) {
                this.resp.setStatus(400);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(2, e.getMessage());
                throw new WebdavException(400);
            }
            catch (BadQueryException e) {
                this.resp.setStatus(400);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(1, e.getMessage());
                throw new WebdavException(400);
            }
            catch (AccessDeniedException e) {
                String contextPath = this.getSlideContextPath();
                AccessDeniedException ade = new AccessDeniedException(contextPath + e.getObjectUri(), contextPath + e.getSubjectUri(), contextPath + e.getActionUri());
                String msg = ade.getMessage();
                this.resp.setStatus(403);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(6, msg);
                throw new WebdavException(403);
            }
            catch (ObjectNotFoundException e) {
                this.resp.setStatus(400);
                this.resp.setContentType("text/xml; charset=\"UTF-8\"");
                this.createErrorResult(2, "scope " + slidePath + " is invalid");
                throw new WebdavException(400);
            }
            catch (SlideException e) {
                e.printStackTrace();
                return;
            }
        } else {
            this.resp.setStatus(400);
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            this.createErrorResult(1, "SEARCH not implemented on this server");
            throw new WebdavException(400);
        }
    }

    protected void executeRequest() throws WebdavException {
        SearchQueryResult result = null;
        try {
            if (WebdavEvent.SEARCH.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.SEARCH, (EventObject)new WebdavEvent(this));
            }
            this.resp.setContentType("text/xml; charset=\"UTF-8\"");
            result = this.searchHelper.search(this.slideToken, this.searchQuery);
            WebdavResult webdavResult = new WebdavResult(result, this.retriever);
            this.resp.setStatus(webdavResult.getWebdavStatus());
            Document responseDoc = webdavResult.getWebdavResultDocument();
            this.sendResult(responseDoc);
        }
        catch (StructureException e) {
            try {
                this.resp.sendError(404, WebdavStatus.getStatusText(404));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw new WebdavException(404);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.resp.setStatus(this.getErrorCode(e));
            throw new WebdavException(202, false);
        }
        catch (Exception e) {
            this.resp.setStatus(this.getErrorCode(e));
            throw new WebdavException(202, false);
        }
    }

    private Element getQueryElement() throws WebdavException, JDOMException {
        Element queryElement = null;
        try {
            Document document = this.parseRequestContent();
            Element rootElement = document.getRootElement();
            List children = rootElement.getChildren();
            if (children.size() > 0) {
                queryElement = (Element)children.get(0);
            }
            return queryElement;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.resp.setStatus(500);
            throw new WebdavException(500);
        }
    }

    private void sendResult(Document responseDoc) throws JDOMException, IOException {
        Format format = Format.getPrettyFormat();
        format.setIndent("    ");
        XMLOutputter xmlWriter = new XMLOutputter(format);
        xmlWriter.output(responseDoc, (Writer)this.resp.getWriter());
    }

    private void createErrorResult(int queryStatus, String message) {
        SearchQueryResult result = new SearchQueryResult();
        result.setStatus(queryStatus);
        result.setDescription(message);
        result.setHref(this.getSlideContextPath());
        try {
            WebdavResult webdavResult = new WebdavResult(result, this.retriever);
            Document responseDoc = webdavResult.getWebdavResultDocument();
            this.sendResult(responseDoc);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    class WebdavResult {
        private SearchQueryResult queryResult;
        private Document responseDoc;
        private PropertyRetriever retriever;
        private int webdavStatus = 207;

        WebdavResult(SearchQueryResult queryResult, PropertyRetriever retriever) throws JDOMException, SlideException {
            this.queryResult = queryResult;
            this.retriever = retriever;
            this.init();
        }

        int getWebdavStatus() {
            return this.webdavStatus;
        }

        Document getWebdavResultDocument() {
            return this.responseDoc;
        }

        private void init() throws JDOMException, SlideException {
            String href = null;
            int errorStatus = this.webdavStatus;
            Element rootElement = new Element("multistatus", AbstractWebdavMethod.DNSP);
            this.responseDoc = new Document(rootElement);
            Iterator it = this.queryResult.iterator();
            while (it.hasNext()) {
                Element responseElement = new Element("response", AbstractWebdavMethod.DNSP);
                rootElement.addContent((Content)responseElement);
                Element hrefElement = new Element("href", AbstractWebdavMethod.DNSP);
                RequestedResource resource = (RequestedResource)it.next();
                String internalUri = resource.getUri();
                String absUri = WebdavUtils.getAbsolutePath(internalUri, SearchMethod.this.req, SearchMethod.this.getConfig());
                hrefElement.addContent(absUri);
                responseElement.addContent((Content)hrefElement);
                List propstatList = this.retriever.getPropertiesOfObject(SearchMethod.this.requestedProperties, resource, SearchMethod.this.getSlideContextPath(), SearchMethod.this.extendedAllprop);
                Iterator iterator = propstatList.iterator();
                while (iterator.hasNext()) {
                    responseElement.addContent((Content)((Element)iterator.next()));
                }
            }
            int status = this.queryResult.getStatus();
            if (status != 0) {
                switch (status) {
                    case 1: {
                        this.webdavStatus = 400;
                        errorStatus = 400;
                        href = this.queryResult.getHref();
                        break;
                    }
                    case 2: {
                        this.webdavStatus = 400;
                        errorStatus = 404;
                        href = this.queryResult.getHref();
                        break;
                    }
                    case 3: {
                        errorStatus = 507;
                        href = SearchMethod.this.getSlideContextPath();
                        break;
                    }
                    case 4: {
                        errorStatus = 422;
                        href = SearchMethod.this.getSlideContextPath();
                        break;
                    }
                    case 5: {
                        errorStatus = 502;
                        href = this.queryResult.getHref();
                        break;
                    }
                    case 6: {
                        errorStatus = 403;
                        href = this.queryResult.getHref();
                        break;
                    }
                    default: {
                        throw new WebdavException(500);
                    }
                }
                Element responseElement = new Element("response", AbstractWebdavMethod.DNSP);
                Element hrefElement = new Element("href", AbstractWebdavMethod.DNSP);
                hrefElement.addContent(href);
                Element statusElement = new Element("status", AbstractWebdavMethod.DNSP);
                statusElement.addContent(this.getStatusText(errorStatus));
                responseElement.addContent((Content)hrefElement);
                responseElement.addContent((Content)statusElement);
                String description = this.queryResult.getDescription();
                if (description != null) {
                    Element responseDescriptionElement = new Element("responsedescription", AbstractWebdavMethod.DNSP);
                    responseDescriptionElement.addContent(description);
                    responseElement.addContent((Content)responseDescriptionElement);
                }
                if (status == 2) {
                    responseElement.addContent((Content)new Element("scopeerror", AbstractWebdavMethod.DNSP));
                }
                rootElement.addContent((Content)responseElement);
            }
        }

        private String getStatusText(int status) {
            return "HTTP/1.1 " + status + " " + WebdavStatus.getStatusText(status);
        }
    }
}

