/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.util.EventObject;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.NotificationTrigger;
import org.apache.slide.webdav.event.Subscriber;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.util.NotificationConstants;

public class SubscribeMethod
extends AbstractWebdavMethod
implements NotificationConstants {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$webdav$method$SubscribeMethod == null ? (class$org$apache$slide$webdav$method$SubscribeMethod = SubscribeMethod.class$("org.apache.slide.webdav.method.SubscribeMethod")) : class$org$apache$slide$webdav$method$SubscribeMethod).getName();
    private static final int DEFAULT_SUBSCRIPTION_LIFETIME = 3600;
    static /* synthetic */ Class class$org$apache$slide$webdav$method$SubscribeMethod;

    public SubscribeMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
    }

    protected void executeRequest() throws WebdavException {
        try {
            if (WebdavEvent.SUBSCRIBE.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.SUBSCRIBE, (EventObject)new WebdavEvent(this));
            }
            String contentType = this.requestHeaders.getContentType();
            String callback = this.requestHeaders.getCallback();
            String notificationType = this.requestHeaders.getNotificationType();
            int notificationDelay = this.requestHeaders.getNotificationDelay(0);
            int subscriptionLifetime = this.requestHeaders.getSubscriptionLifetime(3600);
            int depth = this.requestHeaders.getDepth(Integer.MAX_VALUE);
            int[] subscriptionIDs = this.requestHeaders.getSubscriptionId();
            if (subscriptionIDs.length > 0) {
                for (int i = 0; i < subscriptionIDs.length; ++i) {
                    Subscriber subscriber = NotificationTrigger.getInstance().getSubscriber(subscriptionIDs[i]);
                    if (subscriber == null) continue;
                    NotificationTrigger.getInstance().refreshSubscriber(subscriber, true);
                }
            } else {
                if (notificationType == null) {
                    this.sendError(400, "Notification-Type header missing.");
                    return;
                }
                Subscriber subscriber = new Subscriber(this.requestUri, callback, notificationType, notificationDelay, subscriptionLifetime, depth);
                int subscriptionID = NotificationTrigger.getInstance().addSubscriber(subscriber);
                this.resp.setHeader("Call-back", callback);
                this.resp.setHeader("Notification-type", notificationType);
                this.resp.setHeader("Subscription-lifetime", String.valueOf(subscriptionLifetime));
                this.resp.setHeader("Subscription-ID", String.valueOf(subscriptionID));
                this.resp.setHeader("Content-Location", this.getSlideContextPath() + this.requestUri);
                this.resp.setStatus(200);
            }
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

