/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.MethodUtil;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.BindConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.jdom.JDOMException;

public class UnbindMethod
extends AbstractWebdavMethod
implements BindConstants,
WriteMethod {
    private String collectionUri;
    private String segment;
    private ObjectNode collectionNode = null;

    public UnbindMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    protected void parseRequest() throws WebdavException {
        this.collectionUri = this.requestUri;
        if (this.collectionUri == null) {
            this.collectionUri = "/";
        }
        try {
            List content = this.parseRequestContent("unbind").getChildren();
            this.segment = MethodUtil.getChildText(content, "segment");
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        this.collectionUri = this.requestUri;
        if (this.collectionUri == null) {
            this.collectionUri = "/";
        }
    }

    private void checkPreconditions() throws PreconditionViolationException, ServiceAccessException {
        this.resp.setStatus(200);
        try {
            this.collectionNode = this.structure.retrieve(this.slideToken, this.collectionUri);
        }
        catch (ServiceAccessException e) {
            throw e;
        }
        catch (SlideException slideException) {
            // empty catch block
        }
        if (this.collectionNode == null || !this.isCollection(this.collectionUri)) {
            throw new PreconditionViolationException(new ViolatedPrecondition("unbind-from-collection", 409), this.collectionUri);
        }
        if (!this.collectionNode.hasBinding(this.segment)) {
            throw new PreconditionViolationException(new ViolatedPrecondition("unbind-source-exists", 409), this.collectionUri);
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.collectionUri)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.collectionUri});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Throwable)e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            if (WebdavEvent.UNBIND.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.UNBIND, (EventObject)new WebdavEvent(this));
            }
            this.checkPreconditions();
            this.structure.removeBinding(this.slideToken, this.collectionNode, this.segment);
        }
        catch (ObjectLockedException e) {
            ViolatedPrecondition violatedPrecondition = this.collectionUri.equals(e.getObjectUri()) ? new ViolatedPrecondition("locked-update-allowed", 423) : new ViolatedPrecondition("protected-url-deletion-allowed", 409);
            this.sendPreconditionViolation(new PreconditionViolationException(violatedPrecondition, this.collectionNode.getUri()));
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }
}

