/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method;

import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import org.apache.slide.common.Domain;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.event.EventDispatcher;
import org.apache.slide.event.VetoableEventMethod;
import org.apache.slide.macro.ForbiddenException;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.event.WebdavEvent;
import org.apache.slide.webdav.method.AbstractWebdavMethod;
import org.apache.slide.webdav.method.WriteMethod;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.jdom.Element;
import org.jdom.JDOMException;

public class VersionControlMethod
extends AbstractWebdavMethod
implements DeltavConstants,
WriteMethod {
    private String resourcePath;
    private String existingVersionPath;

    public VersionControlMethod(NamespaceAccessToken token, WebdavServletConfig config) {
        super(token, config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseRequest() throws WebdavException {
        this.resourcePath = this.requestUri;
        if (this.resourcePath == null) {
            this.resourcePath = "/";
        }
        if (this.req.getContentLength() <= 0) return;
        try {
            Element ve = null;
            Iterator i = this.parseRequestContent("version-control").getChildren().iterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                if (!e.getName().equals("version")) continue;
                ve = e;
                try {
                    Element hre = (Element)ve.getChildren().get(0);
                    if (hre == null || !hre.getName().equals("href")) {
                        throw new Exception();
                    }
                    this.existingVersionPath = this.getSlidePath(hre.getText());
                    return;
                }
                catch (Exception x) {
                    Domain.warn((Object)"version element must contain href element");
                    throw new JDOMException("<version> element must contain <href> element");
                    return;
                }
            }
        }
        catch (JDOMException e) {
            int statusCode = 400;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        catch (IOException e) {
            int statusCode = 500;
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }

    protected void executeRequest() throws WebdavException, IOException {
        this.slideToken.setForceStoreEnlistment(true);
        try {
            if (this.isLockNull(this.resourcePath)) {
                int statusCode = 404;
                this.sendError(statusCode, "lock-null resource", new Object[]{this.resourcePath});
                throw new WebdavException(statusCode);
            }
        }
        catch (ServiceAccessException e) {
            int statusCode = this.getErrorCode((Throwable)e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
        try {
            UriHandler rUh = UriHandler.getUriHandler(this.resourcePath);
            if (this.isExcludedForVersionControl(this.resourcePath)) {
                throw new ForbiddenException(this.resourcePath, (Throwable)new Exception("The resource path has been excluded from version-control"));
            }
            if (WebdavEvent.VERSION_CONTROL.isEnabled()) {
                EventDispatcher.getInstance().fireVetoableEvent((VetoableEventMethod)WebdavEvent.VERSION_CONTROL, (EventObject)new WebdavEvent(this));
            }
            VersioningHelper vh = VersioningHelper.getVersioningHelper(this.slideToken, this.token, this.req, this.resp, this.getConfig());
            if (this.existingVersionPath == null) {
                vh.versionControl(this.resourcePath);
            } else {
                vh.versionControl(this.resourcePath, this.existingVersionPath);
            }
        }
        catch (PreconditionViolationException e) {
            this.sendPreconditionViolation(e);
            throw e;
        }
        catch (Exception e) {
            int statusCode = this.getErrorCode(e);
            this.sendError(statusCode, e);
            throw new WebdavException(statusCode);
        }
    }
}

