/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method.report;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.search.Search;
import org.apache.slide.security.Security;
import org.apache.slide.structure.Structure;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.PropertyRetriever;
import org.apache.slide.webdav.util.PropertyRetrieverImpl;
import org.apache.slide.webdav.util.WebdavStatus;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class AbstractReport
implements DeltavConstants,
AclConstants {
    protected static final Namespace DNSP = NodeProperty.NamespaceCache.DEFAULT_NAMESPACE;
    protected static final String HTTP_VERSION = "HTTP/1.1";
    protected SlideToken slideToken;
    protected NamespaceAccessToken token;
    protected WebdavServletConfig config;
    protected String slideContextPath;
    protected Structure structure;
    protected Content content;
    protected Security security;
    protected Search search;
    protected PropertyRetriever retriever;

    public AbstractReport(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, String slideContextPath) {
        this.slideToken = slideToken;
        this.token = token;
        this.config = config;
        this.slideContextPath = slideContextPath;
        this.structure = token.getStructureHelper();
        this.content = token.getContentHelper();
        this.security = token.getSecurityHelper();
        this.search = token.getSearchHelper();
        this.retriever = new PropertyRetrieverImpl(token, slideToken, config);
    }

    public abstract void init(String var1, Element var2) throws PreconditionViolationException;

    public abstract void execute(String var1, Element var2, int var3) throws SlideException, IOException;

    public void checkPreconditions(String resourcePath, int depth) throws PreconditionViolationException, ServiceAccessException {
    }

    protected Element getResponseElement(SlideToken slideToken, String resourcePath, NodeRevisionNumber revisionNumber, RequestedProperties requestedProperties) {
        Element responseElm = new Element("response", DNSP);
        Element hrefElm = new Element("href", DNSP);
        String absUri = WebdavUtils.getAbsolutePath(resourcePath, this.slideContextPath, this.config);
        hrefElm.setText(absUri);
        responseElm.addContent((org.jdom.Content)hrefElm);
        try {
            List propstatList = this.retriever.getPropertiesOfObject(requestedProperties, resourcePath, revisionNumber, this.slideContextPath, true);
            Iterator iterator = propstatList.iterator();
            while (iterator.hasNext()) {
                responseElm.addContent((org.jdom.Content)((Element)iterator.next()));
            }
        }
        catch (Exception e) {
            responseElm = this.getErrorResponse(resourcePath, WebdavUtils.getErrorCode(e), null);
        }
        return responseElm;
    }

    protected Element getErrorResponse(String resourcePath, int statusCode, String condition) {
        Element responseElm = new Element("response", DNSP);
        Element hrefElm = new Element("href", DNSP);
        hrefElm.setText(WebdavUtils.getAbsolutePath(resourcePath, this.slideContextPath, this.config));
        responseElm.addContent((org.jdom.Content)hrefElm);
        Element propStatElm = new Element("propstat", DNSP);
        responseElm.addContent((org.jdom.Content)propStatElm);
        Element statusElm = new Element("status", DNSP);
        statusElm.setText("HTTP/1.1 " + statusCode + " " + WebdavStatus.getStatusText(statusCode));
        propStatElm.addContent((org.jdom.Content)statusElm);
        if (condition != null) {
            Element responseDescriptiont = new Element("responsedescription", DNSP);
            Element errorElm = new Element("error", DNSP);
            responseDescriptiont.addContent((org.jdom.Content)errorElm);
            Element conditionElm = new Element(condition, DNSP);
            errorElm.addContent((org.jdom.Content)conditionElm);
            propStatElm.addContent((org.jdom.Content)responseDescriptiont);
        }
        return responseElm;
    }
}

