/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method.report;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.security.NodePermission;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.report.AbstractReport;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.jdom.Content;
import org.jdom.Element;

public class AclPrincipalPropSetReport
extends AbstractReport
implements AclConstants {
    private RequestedProperties requestedProperties = null;

    public AclPrincipalPropSetReport(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, String slideContextPath) {
        super(slideToken, token, config, slideContextPath);
    }

    public void init(String resourcePath, Element aclPrincipalPropSetElm) throws PreconditionViolationException {
        if (aclPrincipalPropSetElm.getChildren().size() == 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("at-least-one-child-element", 400, "DAV:acl-principal-prop-set element must have at least one child"), resourcePath);
        }
        List propElmL = aclPrincipalPropSetElm.getChildren("prop", DNSP);
        if (propElmL.size() > 1) {
            throw new PreconditionViolationException(new ViolatedPrecondition("at-most-one-prop-element", 400, "DAV:acl-principal-prop-set element must have at most one DAV:prop child"), resourcePath);
        }
        if (propElmL.size() == 1) {
            Element propElm = (Element)propElmL.get(0);
            try {
                this.requestedProperties = new RequestedPropertiesImpl(propElm);
            }
            catch (PropertyParseException e) {
                throw new PreconditionViolationException(new ViolatedPrecondition("invalid-prop", 400, e.getMessage()), resourcePath);
            }
        }
    }

    public void execute(String resourcePath, Element multistatusElm, int depth) throws SlideException, IOException {
        NodeRevisionDescriptors nrds = this.content.retrieve(this.slideToken, resourcePath);
        NodeRevisionDescriptor nrd = this.content.retrieve(this.slideToken, nrds);
        Enumeration permissions = this.security.enumeratePermissions(this.slideToken, resourcePath, true);
        while (permissions != null && permissions.hasMoreElements()) {
            NodePermission p = (NodePermission)permissions.nextElement();
            SubjectNode principalNode = SubjectNode.getSubjectNode((String)p.getSubjectUri());
            String principalPath = this.getPrincipalPath(principalNode, nrd);
            if (principalPath == null) continue;
            multistatusElm.addContent((Content)this.getResponseElement(this.slideToken, principalPath, new NodeRevisionNumber(), this.requestedProperties));
        }
    }

    private String getPrincipalPath(SubjectNode principalNode, NodeRevisionDescriptor nrd) throws SlideException {
        if (principalNode.equals((Object)SubjectNode.ALL) || principalNode.equals((Object)SubjectNode.SELF) || principalNode.equals((Object)SubjectNode.AUTHENTICATED) || principalNode.equals((Object)SubjectNode.UNAUTHENTICATED)) {
            return null;
        }
        if (principalNode.equals((Object)SubjectNode.OWNER)) {
            NodeProperty ownerProp = nrd.getProperty("owner");
            if (ownerProp != null) {
                return this.token.getNamespaceConfig().getUsersPath() + "/" + ownerProp.getValue();
            }
            return null;
        }
        return principalNode.getUri();
    }

    public void checkPreconditions(String resourcePath, int depth) throws PreconditionViolationException, ServiceAccessException {
        if (depth != 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("depth-must-be-zero", 400, "This report is only defined for depth=0."), resourcePath);
        }
    }
}

