/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method.report;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.report.AbstractReport;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.VersionControlled;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class LocateByHistoryReport
extends AbstractReport
implements DeltavConstants {
    protected RequestedProperties requestedProperties = null;
    protected XMLValue versionHistorySet = null;

    public LocateByHistoryReport(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, String slideContextPath) {
        super(slideToken, token, config, slideContextPath);
    }

    public void init(String resourcePath, Element locateByHistoryElm) throws PreconditionViolationException {
        List childrenList = locateByHistoryElm.getChildren();
        if (childrenList.size() != 2) {
            throw new PreconditionViolationException(new ViolatedPrecondition("invalid-locate-by-history", 400, "DAV:locate-by-history element must have 2 children: DAV:version-history-set and DAV:prop"), resourcePath);
        }
        Element versionHistorySetElm = null;
        Element propElm = null;
        if ("version-history-set".equals(((Element)childrenList.get(0)).getName()) && "prop".equals(((Element)childrenList.get(1)).getName())) {
            versionHistorySetElm = (Element)childrenList.get(0);
            propElm = (Element)childrenList.get(1);
        } else if ("prop".equals(((Element)childrenList.get(0)).getName()) && "version-history-set".equals(((Element)childrenList.get(1)).getName())) {
            propElm = (Element)childrenList.get(0);
            versionHistorySetElm = (Element)childrenList.get(1);
        } else {
            throw new PreconditionViolationException(new ViolatedPrecondition("invalid-locate-by-history", 400, "DAV:locate-by-history element must have 2 children: DAV:version-history-set and DAV:prop"), resourcePath);
        }
        if (!WebdavUtils.isCollection(this.token, this.slideToken, resourcePath)) {
            throw new PreconditionViolationException(new ViolatedPrecondition("must-be-collection", 400, "the request-URI must specify a collection"), resourcePath);
        }
        this.versionHistorySet = new XMLValue(versionHistorySetElm.getChildren("href", DNSP));
        UriHandler uriHandler = null;
        String href = null;
        boolean isVersionHistory = false;
        Iterator iterator = this.versionHistorySet.getHrefStrings().iterator();
        while (iterator.hasNext() && (isVersionHistory = (uriHandler = UriHandler.getUriHandler(WebdavUtils.getSlidePath(href = (String)iterator.next(), this.slideContextPath))).isHistoryUri())) {
        }
        if (!isVersionHistory) {
            throw new PreconditionViolationException(new ViolatedPrecondition("must-be-version-history", 409), resourcePath);
        }
        try {
            this.requestedProperties = new RequestedPropertiesImpl(propElm);
        }
        catch (PropertyParseException e) {
            throw new PreconditionViolationException(new ViolatedPrecondition("invalid-prop", 400, e.getMessage()), resourcePath);
        }
    }

    public void execute(String resourcePath, Element multistatusElm, int depth) throws SlideException, IOException {
        if (depth < 0) {
            return;
        }
        NodeRevisionDescriptor nrd = null;
        NodeRevisionDescriptors nrds = null;
        ResourceKind resourceKind = null;
        String versionHistoryUri = null;
        ObjectNode collectionNode = this.structure.retrieve(this.slideToken, resourcePath);
        Enumeration children = this.structure.getChildren(this.slideToken, collectionNode);
        while (children.hasMoreElements()) {
            ObjectNode child = (ObjectNode)children.nextElement();
            if (child.hasChildren()) {
                this.execute(child.getUri(), multistatusElm, depth - 1);
                continue;
            }
            nrds = this.content.retrieve(this.slideToken, child.getUri());
            nrd = this.content.retrieve(this.slideToken, nrds);
            resourceKind = AbstractResourceKind.determineResourceKind(this.token, child.getUri(), nrd);
            versionHistoryUri = null;
            if (resourceKind instanceof VersionControlled) {
                versionHistoryUri = this.getHistoryUriOfVCR(nrd);
            }
            if (versionHistoryUri == null) continue;
            boolean found = false;
            Iterator iterator = this.versionHistorySet.iterator();
            String currentHistoryUri = null;
            while (!found && iterator.hasNext()) {
                currentHistoryUri = ((Element)iterator.next()).getText();
                if (currentHistoryUri != null) {
                    currentHistoryUri = WebdavUtils.getSlidePath(currentHistoryUri, this.slideContextPath);
                }
                found = versionHistoryUri.equals(currentHistoryUri);
            }
            if (!found) continue;
            multistatusElm.addContent((Content)this.getResponseElement(this.slideToken, child.getUri(), nrd.getRevisionNumber(), this.requestedProperties));
        }
    }

    private String getHistoryUriOfVCR(NodeRevisionDescriptor revisionDescriptor) {
        String historyUri = null;
        NodeProperty property = revisionDescriptor.getProperty("checked-in");
        if (property == null) {
            property = revisionDescriptor.getProperty("checked-out");
        }
        if (property != null && property.getValue() != null) {
            try {
                String vrUri;
                UriHandler uriHandler;
                XMLValue xmlValue = new XMLValue(property.getValue().toString());
                Iterator iterator = xmlValue.iterator();
                if (iterator.hasNext() && (uriHandler = UriHandler.getUriHandler(vrUri = ((Element)iterator.next()).getText())).isVersionUri()) {
                    historyUri = uriHandler.getAssociatedHistoryUri();
                }
            }
            catch (JDOMException e) {
                // empty catch block
            }
        }
        return historyUri;
    }
}

