/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.report.AbstractReport;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.WebdavUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PrincipalMatchReport
extends AbstractReport
implements AclConstants {
    private RequestedProperties requestedProperties = null;
    private SubjectNode matchSubjectNode = null;

    public PrincipalMatchReport(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, String slideContextPath) {
        super(slideToken, token, config, slideContextPath);
    }

    public void init(String resourcePath, Element principalMatchElm) throws PreconditionViolationException {
        if (principalMatchElm.getChildren().size() == 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("at-least-one-child-element", 400, "DAV:principal-match element must have at least one child"), resourcePath);
        }
        List principalPropertyElmL = principalMatchElm.getChildren("principal-property", DNSP);
        List selfElmL = principalMatchElm.getChildren("self", DNSP);
        if (principalPropertyElmL.size() + selfElmL.size() != 1) {
            throw new PreconditionViolationException(new ViolatedPrecondition("either-one-principal-property-or-one-self-element", 400, "DAV:principal-match element must contain either a DAV:principal-property or a DAV:self element"), resourcePath);
        }
        if (principalPropertyElmL.size() == 1) {
            Element principalPropertyElm = (Element)principalPropertyElmL.get(0);
            if (principalPropertyElm.getChildren("owner", DNSP).size() > 0) {
                this.matchSubjectNode = SubjectNode.OWNER;
            }
        } else {
            this.matchSubjectNode = SubjectNode.SELF;
        }
        List propElmL = principalMatchElm.getChildren("prop", DNSP);
        if (propElmL.size() > 1) {
            throw new PreconditionViolationException(new ViolatedPrecondition("at-most-one-prop-element", 400, "DAV:principal-match element must have at most one DAV:prop child"), resourcePath);
        }
        if (propElmL.size() == 1) {
            Element propElm = (Element)propElmL.get(0);
            try {
                this.requestedProperties = new RequestedPropertiesImpl(propElm);
            }
            catch (PropertyParseException e) {
                throw new PreconditionViolationException(new ViolatedPrecondition("invalid-prop", 400, e.getMessage()), resourcePath);
            }
        }
    }

    public void execute(String resourcePath, Element multistatusElm, int depth) throws SlideException, IOException {
        SubjectNode currentUserNode = (SubjectNode)this.security.getPrincipal(this.slideToken);
        Element queryElm = this.getQueryElement(resourcePath, currentUserNode);
        new XMLOutputter(Format.getPrettyFormat()).output(queryElm, (OutputStream)System.out);
        String absUri = WebdavUtils.getAbsolutePath(resourcePath, this.slideContextPath, this.config);
        SearchQuery query = this.search.createSearchQuery(queryElm.getNamespaceURI(), queryElm, this.slideToken, this.config.getDepthLimit(), absUri);
        Iterator result = query.execute().iterator();
        while (result.hasNext()) {
            RequestedResource r = (RequestedResource)result.next();
            multistatusElm.addContent((Content)this.getResponseElement(this.slideToken, r.getUri(), new NodeRevisionNumber(), this.requestedProperties));
        }
    }

    private Element getQueryElement(String resourcePath, SubjectNode currentUserNode) throws SlideException {
        if (this.matchSubjectNode.equals((Object)SubjectNode.OWNER)) {
            return this.getOwnerQueryElement(resourcePath, currentUserNode);
        }
        if (this.matchSubjectNode.equals((Object)SubjectNode.SELF)) {
            return this.getSelfQueryElement(resourcePath, currentUserNode);
        }
        return null;
    }

    private Element getSelfQueryElement(String resourcePath, SubjectNode currentUserNode) {
        Element result = new Element("basicsearch", DNSP);
        Element selectElm = new Element("select", DNSP);
        result.addContent((Content)selectElm);
        Element propElm = new Element("prop", DNSP);
        selectElm.addContent((Content)propElm);
        Iterator props = this.requestedProperties.getRequestedProperties();
        while (props.hasNext()) {
            RequestedProperty p = (RequestedProperty)props.next();
            Namespace nsp = DNSP.getURI().equals(p.getNamespace()) ? DNSP : Namespace.getNamespace((String)p.getNamespace());
            propElm.addContent((Content)new Element(p.getName(), nsp));
        }
        Element fromElm = new Element("from", DNSP);
        result.addContent((Content)fromElm);
        Element scopeElm = new Element("scope", DNSP);
        fromElm.addContent((Content)scopeElm);
        Element hrefElm = new Element("href", DNSP);
        hrefElm.setText(WebdavUtils.getAbsolutePath(resourcePath, this.slideContextPath, this.config));
        scopeElm.addContent((Content)hrefElm);
        Element whereElm = new Element("where", DNSP);
        result.addContent((Content)whereElm);
        Element propcontainsElm = new Element("propcontains", Namespace.getNamespace((String)"http://jakarta.apache.org/slide/"));
        whereElm.addContent((Content)propcontainsElm);
        propElm = new Element("prop", DNSP);
        propElm.addContent((Content)new Element("group-member-set", DNSP));
        Element literalElm = new Element("literal", DNSP);
        literalElm.addContent("/" + currentUserNode.getPath().lastSegment() + "<");
        propcontainsElm.addContent((Content)propElm);
        propcontainsElm.addContent((Content)literalElm);
        return result;
    }

    private Element getOwnerQueryElement(String resourcePath, SubjectNode currentUserNode) {
        Element result = new Element("basicsearch", DNSP);
        Element selectElm = new Element("select", DNSP);
        result.addContent((Content)selectElm);
        Element propElm = new Element("prop", DNSP);
        selectElm.addContent((Content)propElm);
        Iterator props = this.requestedProperties.getRequestedProperties();
        while (props.hasNext()) {
            RequestedProperty p = (RequestedProperty)props.next();
            Namespace nsp = DNSP.getURI().equals(p.getNamespace()) ? DNSP : Namespace.getNamespace((String)p.getNamespace());
            propElm.addContent((Content)new Element(p.getName(), nsp));
        }
        Element fromElm = new Element("from", DNSP);
        result.addContent((Content)fromElm);
        Element scopeElm = new Element("scope", DNSP);
        fromElm.addContent((Content)scopeElm);
        Element hrefElm = new Element("href", DNSP);
        hrefElm.setText(WebdavUtils.getAbsolutePath(resourcePath, this.slideContextPath, this.config));
        scopeElm.addContent((Content)hrefElm);
        Element whereElm = new Element("where", DNSP);
        result.addContent((Content)whereElm);
        Element eqElm = new Element("eq", DNSP);
        whereElm.addContent((Content)eqElm);
        propElm = new Element("prop", DNSP);
        propElm.addContent((Content)new Element("owner", DNSP));
        Element literalElm = new Element("literal", DNSP);
        literalElm.addContent(currentUserNode.getPath().lastSegment());
        eqElm.addContent((Content)propElm);
        eqElm.addContent((Content)literalElm);
        return result;
    }

    public void checkPreconditions(String resourcePath, int depth) throws PreconditionViolationException, ServiceAccessException {
        if (depth != 0) {
            throw new PreconditionViolationException(new ViolatedPrecondition("depth-must-be-zero", 400, "This report is only defined for depth=0."), resourcePath);
        }
    }
}

