/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.method.report;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyParseException;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.report.AbstractReport;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PreconditionViolationException;
import org.apache.slide.webdav.util.UriHandler;
import org.apache.slide.webdav.util.VersioningHelper;
import org.apache.slide.webdav.util.ViolatedPrecondition;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.apache.slide.webdav.util.resourcekind.Version;
import org.apache.slide.webdav.util.resourcekind.VersionControlled;
import org.apache.slide.webdav.util.resourcekind.VersionHistory;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class VersionTreeReport
extends AbstractReport
implements DeltavConstants {
    private RequestedProperties requestedProperties = null;
    private VersioningHelper versioningHelper = null;

    public VersionTreeReport(SlideToken slideToken, NamespaceAccessToken token, WebdavServletConfig config, String slideContextPath) {
        super(slideToken, token, config, slideContextPath);
    }

    public void init(String resourcePath, Element versionTreeElm) throws PreconditionViolationException {
        List childrenList = versionTreeElm.getChildren("prop", DNSP);
        if (childrenList.size() == 0) {
            return;
        }
        if (childrenList.size() > 1) {
            throw new PreconditionViolationException(new ViolatedPrecondition("at-most-one-prop-element", 400, "the DAV:version-tree element must contain at most one DAV:prop element"), resourcePath);
        }
        Element propElm = (Element)childrenList.get(0);
        try {
            this.requestedProperties = new RequestedPropertiesImpl(propElm);
        }
        catch (PropertyParseException e) {
            throw new PreconditionViolationException(new ViolatedPrecondition("invalid-prop-element", 400, e.getMessage()), resourcePath);
        }
    }

    public void execute(String resourcePath, Element multistatusElm, int depth) throws SlideException, IOException {
        if (depth < 0) {
            return;
        }
        this.writeReport(resourcePath, multistatusElm);
        ObjectNode onode = this.structure.retrieve(this.slideToken, resourcePath);
        Enumeration childrenEnum = this.structure.getChildren(this.slideToken, onode);
        while (childrenEnum.hasMoreElements()) {
            ObjectNode cnode = (ObjectNode)childrenEnum.nextElement();
            this.execute(cnode.getUri(), multistatusElm, depth - 1);
        }
    }

    public void setVersioningHelper(VersioningHelper versioningHelper) {
        this.versioningHelper = versioningHelper;
    }

    /*
     * WARNING - void declaration
     */
    private void writeReport(String resourcePath, Element multistatusElm) throws SlideException {
        NodeRevisionDescriptor nrd;
        NodeRevisionDescriptors nrds = this.content.retrieve(this.slideToken, resourcePath);
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.token, nrds, nrd = this.content.retrieve(this.slideToken, nrds));
        if (resourceKind instanceof VersionControlled) {
            resourcePath = this.versioningHelper.getUriOfAssociatedVR(resourcePath);
            nrds = this.content.retrieve(this.slideToken, resourcePath);
            nrd = this.content.retrieve(this.slideToken, nrds);
            resourceKind = AbstractResourceKind.determineResourceKind(this.token, nrds, nrd);
        } else if (resourceKind instanceof VersionHistory) {
            NodeProperty rootVersion = nrd.getProperty("root-version");
            if (rootVersion != null) {
                void var7_7;
                XMLValue value;
                if (rootVersion.getValue() instanceof XMLValue) {
                    value = (XMLValue)rootVersion.getValue();
                } else {
                    try {
                        value = new XMLValue(rootVersion.getValue().toString());
                    }
                    catch (JDOMException e) {
                        throw new SlideException("Could not parse DAV:root-version: " + nrds.getUri());
                    }
                }
                Iterator i = var7_7.iterator();
                if (i.hasNext()) {
                    resourcePath = ((Element)i.next()).getText();
                }
            }
            resourcePath = resourcePath + "/";
            resourcePath = resourcePath + nrds.getInitialRevision();
            nrds = this.content.retrieve(this.slideToken, resourcePath);
            nrd = this.content.retrieve(this.slideToken, nrds);
            resourceKind = AbstractResourceKind.determineResourceKind(this.token, nrds, nrd);
        }
        if (Configuration.useVersionControl() && resourceKind instanceof Version) {
            this.writeReport(nrds, this.slideToken, multistatusElm);
        } else {
            multistatusElm.addContent((Content)this.getErrorResponse(resourcePath, 403, "supported-report"));
        }
    }

    private void writeReport(NodeRevisionDescriptors nrds, SlideToken slideToken, Element multistatusElm) throws SlideException {
        NodeRevisionDescriptor hNrd = this.content.retrieve(slideToken, nrds, NodeRevisionNumber.HIDDEN_0_0);
        NodeProperty versionSetProperty = hNrd.getProperty("version-set");
        if (versionSetProperty != null && versionSetProperty.getValue() != null) {
            XMLValue xmlValue;
            try {
                xmlValue = new XMLValue(versionSetProperty.getValue().toString());
            }
            catch (JDOMException e) {
                throw new SlideException("Could not parse DAV:version-set: " + nrds.getUri());
            }
            Iterator hrefIterator = xmlValue.iterator();
            NodeRevisionNumber currentNrn = null;
            UriHandler currentUh = null;
            String currentPath = null;
            while (hrefIterator.hasNext()) {
                currentPath = ((Element)hrefIterator.next()).getText();
                currentUh = UriHandler.getUriHandler(currentPath);
                currentNrn = new NodeRevisionNumber(currentUh.getVersionName());
                multistatusElm.addContent((Content)this.getResponseElement(slideToken, currentPath, currentNrn, this.getRequestedVersionTreeProperties()));
            }
        }
    }

    private RequestedProperties getRequestedVersionTreeProperties() {
        if (this.requestedProperties == null) {
            this.requestedProperties = new RequestedPropertiesImpl();
        }
        return this.requestedProperties;
    }
}

