/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.PropertyName;
import org.apache.slide.common.RequestedProperties;
import org.apache.slide.common.RequestedPropertiesImpl;
import org.apache.slide.common.RequestedProperty;
import org.apache.slide.common.RequestedPropertyImpl;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.UriPath;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.Lock;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.Security;
import org.apache.slide.store.Store;
import org.apache.slide.structure.Structure;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.util.AbstractWebdavHelper;
import org.apache.slide.webdav.util.AclConstants;
import org.apache.slide.webdav.util.BindConstants;
import org.apache.slide.webdav.util.ComputedPropertyProvider;
import org.apache.slide.webdav.util.DeltavConstants;
import org.apache.slide.webdav.util.PropertyHelper;
import org.apache.slide.webdav.util.PropertyRetriever;
import org.apache.slide.webdav.util.ResourceWithProvidedProperties;
import org.apache.slide.webdav.util.WebdavConstants;
import org.apache.slide.webdav.util.WebdavStatus;
import org.apache.slide.webdav.util.WebdavUtils;
import org.apache.slide.webdav.util.resourcekind.AbstractResourceKind;
import org.apache.slide.webdav.util.resourcekind.ResourceKind;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class PropertyRetrieverImpl
extends AbstractWebdavHelper
implements PropertyRetriever,
WebdavConstants,
DeltavConstants,
AclConstants,
BindConstants {
    protected Content content = null;
    protected Lock lock = null;
    protected Security security = null;
    protected Structure structure = null;
    protected PropertyHelper propertyHelper = null;
    protected WebdavServletConfig config = null;

    public PropertyRetrieverImpl(NamespaceAccessToken token, SlideToken slideToken, WebdavServletConfig sConf) {
        super(slideToken, token);
        this.structure = token.getStructureHelper();
        this.content = token.getContentHelper();
        this.security = token.getSecurityHelper();
        this.lock = token.getLockHelper();
        this.config = sConf;
        this.propertyHelper = PropertyHelper.getPropertyHelper(slideToken, token, sConf);
    }

    protected PropertyHelper getPropertyHelper() {
        return this.propertyHelper;
    }

    public List getPropertiesOfObject(RequestedProperties requestedProperties, String uri, String servletContextPath, boolean extendedAllprop) throws SlideException, JDOMException {
        NodeRevisionDescriptor revisionDescriptor;
        NodeRevisionDescriptors revisionDescriptors;
        block5: {
            revisionDescriptors = null;
            revisionDescriptor = null;
            try {
                revisionDescriptors = this.content.retrieve(this.sToken, uri);
                try {
                    revisionDescriptor = this.content.retrieve(this.sToken, revisionDescriptors);
                }
                catch (RevisionDescriptorNotFoundException e) {
                    revisionDescriptor = new NodeRevisionDescriptor(0L);
                    if (!Configuration.useBinding((Store)this.nsaToken.getUri(this.sToken, uri).getStore())) {
                        revisionDescriptor.setName(new UriPath(uri).lastSegment());
                    }
                }
            }
            catch (AccessDeniedException e) {
                if (revisionDescriptor != null) break block5;
                revisionDescriptor = new NodeRevisionDescriptor(0L);
            }
        }
        return this.getPropertiesOfObject(requestedProperties, revisionDescriptors, revisionDescriptor, servletContextPath, extendedAllprop);
    }

    public List getPropertiesOfObject(RequestedProperties requestedProperties, String uri, NodeRevisionNumber revisionNumber, String servletContextPath, boolean extendedAllprop) throws SlideException, JDOMException {
        NodeRevisionDescriptors revisionDescriptors = this.content.retrieve(this.sToken, uri);
        NodeRevisionDescriptor revisionDescriptor = this.content.retrieve(this.sToken, revisionDescriptors, revisionNumber);
        return this.getPropertiesOfObject(requestedProperties, revisionDescriptors, revisionDescriptor, servletContextPath, extendedAllprop);
    }

    public List getPropertiesOfObject(RequestedProperties requestedProperties, NodeRevisionDescriptors revisionDescriptors, NodeRevisionDescriptor revisionDescriptor, String servletContextPath, boolean extendedAllprop) throws SlideException, JDOMException {
        ComputedPropertyProvider propertyProvider = new ComputedPropertyProvider(this.nsaToken, this.sToken, this.propertyHelper, servletContextPath);
        return this.getPropertiesOfObject(requestedProperties, new ResourceWithProvidedProperties(revisionDescriptors, revisionDescriptor, propertyProvider), servletContextPath, extendedAllprop);
    }

    public List getPropertiesOfObject(RequestedProperties requestedProperties, RequestedResource requestedResource, String servletContextPath, boolean extendedAllprop) throws SlideException, JDOMException {
        List elementList = new ArrayList();
        elementList = requestedProperties.isAllProp() ? this.getAllPropertiesOfObject(requestedResource, servletContextPath, extendedAllprop) : this.getRequestedPropertiesOfObject(requestedProperties, requestedResource, servletContextPath);
        return elementList;
    }

    protected List getRequestedPropertiesOfObject(RequestedProperties requestedProperties, RequestedResource requestedResource, String servletContextPath) throws SlideException {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Iterator propertyIterator = requestedProperties.getRequestedProperties();
        Element propstat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propstat.addContent((org.jdom.Content)prop);
        Element propertyElement = null;
        boolean anyPropertyFound = false;
        HashMap<Integer, ArrayList<PropertyName>> erroneousPropertiesMap = new HashMap<Integer, ArrayList<PropertyName>>();
        String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
        while (propertyIterator.hasNext()) {
            RequestedProperty property = (RequestedProperty)propertyIterator.next();
            NodeProperty currentProperty = null;
            Integer errorCode = null;
            try {
                currentProperty = requestedResource.getProperty(property.getName(), property.getNamespace());
                if (currentProperty == null) {
                    errorCode = new Integer(404);
                }
            }
            catch (AccessDeniedException e) {
                errorCode = new Integer(403);
            }
            if (errorCode != null) {
                ArrayList<PropertyName> erroneousPropertiesList = (ArrayList<PropertyName>)erroneousPropertiesMap.get(errorCode);
                if (erroneousPropertiesList == null) {
                    erroneousPropertiesList = new ArrayList<PropertyName>();
                    erroneousPropertiesMap.put(errorCode, erroneousPropertiesList);
                }
                erroneousPropertiesList.add(new PropertyName(property.getName(), property.getNamespace()));
                continue;
            }
            propertyElement = this.getPropertyElement(currentProperty, servletContextPath);
            if (propertyElement == null) continue;
            anyPropertyFound = true;
            prop.addContent((org.jdom.Content)propertyElement);
        }
        if (anyPropertyFound) {
            Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            statusElement.setText(status);
            propstat.addContent((org.jdom.Content)statusElement);
            elementList.add(propstat);
        }
        elementList.addAll(this.getPropstatForErroneousProperties(erroneousPropertiesMap, servletContextPath));
        return elementList;
    }

    protected List getAllPropertiesOfObject(RequestedResource requestedResource, String servletContextPath, boolean extendedAllprop) throws SlideException {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Element propstat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        elementList.add(propstat);
        Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        propstat.addContent((org.jdom.Content)prop);
        Element propertyElement = null;
        HashMap<Integer, ArrayList<PropertyName>> erroneousPropertiesMap = new HashMap<Integer, ArrayList<PropertyName>>();
        String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
        Iterator propertyNameIterator = requestedResource.getAllPropertiesNames();
        while (propertyNameIterator.hasNext()) {
            PropertyName currentPropertyName = (PropertyName)propertyNameIterator.next();
            if (currentPropertyName == null || !extendedAllprop && "DAV:".equals(currentPropertyName.getNamespace()) && (DeltavConstants.DELTAV_PROPERTY_LIST.contains(currentPropertyName.getName()) || BindConstants.BIND_PROPERTY_LIST.contains(currentPropertyName.getName()) || AclConstants.ACL_PROPERTY_LIST.contains(currentPropertyName.getName()))) continue;
            NodeProperty currentProperty = null;
            Integer errorCode = null;
            try {
                currentProperty = requestedResource.getProperty(currentPropertyName);
                if (currentProperty == null) {
                    errorCode = new Integer(404);
                }
            }
            catch (AccessDeniedException e) {
                errorCode = new Integer(403);
            }
            if (errorCode != null) {
                ArrayList<PropertyName> erroneousPropertiesList = (ArrayList<PropertyName>)erroneousPropertiesMap.get(errorCode);
                if (erroneousPropertiesList == null) {
                    erroneousPropertiesList = new ArrayList<PropertyName>();
                    erroneousPropertiesMap.put(errorCode, erroneousPropertiesList);
                }
                erroneousPropertiesList.add(currentPropertyName);
                continue;
            }
            propertyElement = this.getPropertyElement(currentProperty, servletContextPath);
            if (propertyElement == null) continue;
            prop.addContent((org.jdom.Content)propertyElement);
        }
        Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        statusElement.setText(status);
        propstat.addContent((org.jdom.Content)statusElement);
        elementList.addAll(this.getPropstatForErroneousProperties(erroneousPropertiesMap, servletContextPath));
        return elementList;
    }

    protected List getPropstatForErroneousProperties(Map erroneousPropertiesMap, String servletContextPath) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        Iterator iterator = erroneousPropertiesMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer errorCode = (Integer)iterator.next();
            List erroneousPropertiesList = (List)erroneousPropertiesMap.get(errorCode);
            Element propstat = new Element("propstat", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            elementList.add(propstat);
            Element prop = new Element("prop", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            propstat.addContent((org.jdom.Content)prop);
            String status = new String("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText(errorCode));
            Iterator propertyIterator = erroneousPropertiesList.iterator();
            while (propertyIterator.hasNext()) {
                PropertyName erroneousProperty = (PropertyName)propertyIterator.next();
                Element propertyElement = this.getPropertyElement(erroneousProperty.getNamespace(), erroneousProperty.getName(), null, servletContextPath);
                if (propertyElement == null) continue;
                prop.addContent((org.jdom.Content)propertyElement);
            }
            Element statusElement = new Element("status", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
            statusElement.setText(status);
            propstat.addContent((org.jdom.Content)statusElement);
        }
        return elementList;
    }

    private Element getPropertyElement(NodeProperty property, String servletContextPath) {
        if (property != null) {
            return this.getPropertyElement(property.getNamespace(), property.getName(), property.getValue(), servletContextPath);
        }
        return null;
    }

    private Element getPropertyElement(String namespaceString, String propertyName, Object propertyValue, String servletContextPath) {
        Element property = null;
        Namespace namespace = Namespace.NO_NAMESPACE;
        Namespace valueDefaultNamespace = null;
        if (namespaceString != null && "DAV:".equals((namespace = NodeProperty.NamespaceCache.getNamespace((String)namespaceString)).getURI())) {
            valueDefaultNamespace = namespace;
        }
        property = new Element(propertyName, namespace);
        if (propertyValue != null && propertyValue.toString().length() > 0) {
            if (propertyValue.toString().indexOf(60) >= 0) {
                try {
                    XMLValue xmlValue = new XMLValue(propertyValue.toString(), valueDefaultNamespace);
                    if (AbstractResourceKind.isLiveProperty(propertyName)) {
                        PropertyRetrieverImpl.convertHrefValueToAbsoluteURL(xmlValue, servletContextPath, this.config);
                    }
                    Iterator iterator = xmlValue.iterator();
                    while (iterator.hasNext()) {
                        Object o = iterator.next();
                        if (o instanceof Element) {
                            property.addContent((org.jdom.Content)((Element)o));
                            continue;
                        }
                        if (o instanceof Text) {
                            property.addContent((org.jdom.Content)((Text)o));
                            continue;
                        }
                        if (o instanceof Comment) {
                            property.addContent((org.jdom.Content)((Comment)o));
                            continue;
                        }
                        if (o instanceof ProcessingInstruction) {
                            property.addContent((org.jdom.Content)((ProcessingInstruction)o));
                            continue;
                        }
                        if (o instanceof CDATA) {
                            property.addContent((org.jdom.Content)((CDATA)o));
                            continue;
                        }
                        if (!(o instanceof EntityRef)) continue;
                        property.addContent((org.jdom.Content)((EntityRef)o));
                    }
                }
                catch (JDOMException e) {
                    property.setText(propertyValue.toString());
                }
            } else {
                property.setText(propertyValue.toString());
            }
        }
        return property;
    }

    protected static void convertHrefValueToAbsoluteURL(XMLValue xmlValue, String servletContextPath, WebdavServletConfig config) {
        if (xmlValue != null) {
            Iterator iterator = xmlValue.iterator();
            Element element = null;
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof Element)) continue;
                element = (Element)o;
                PropertyRetrieverImpl.convertHrefValueToAbsoluteURL(element, servletContextPath, config);
            }
        }
    }

    private static void convertHrefValueToAbsoluteURL(Element element, String servletContextPath, WebdavServletConfig config) {
        if (element.getChildren().size() > 0) {
            Iterator i = element.getChildren().iterator();
            while (i.hasNext()) {
                Element child = (Element)i.next();
                if (element.getName().equals("activelock") && child.getName().equals("owner")) continue;
                PropertyRetrieverImpl.convertHrefValueToAbsoluteURL(child, servletContextPath, config);
            }
        }
        if ("href".equals(element.getName()) && element.getText() != null && !PropertyHelper.isAbsoluteURL(servletContextPath, element.getText())) {
            element.setText(WebdavUtils.getAbsolutePath(element.getText(), servletContextPath, config));
        }
    }

    public RequestedProperties getAllPropertyNames(String resourcePath, boolean liveOnly) throws SlideException {
        NodeRevisionDescriptor nrd = this.content.retrieve(this.sToken, this.content.retrieve(this.sToken, resourcePath));
        ResourceKind resourceKind = AbstractResourceKind.determineResourceKind(this.nsaToken, resourcePath, nrd);
        RequestedPropertiesImpl result = (RequestedPropertiesImpl)this.getAllPropertyNames(resourceKind);
        if (!liveOnly) {
            Enumeration props = nrd.enumerateProperties();
            while (props.hasMoreElements()) {
                NodeProperty np = (NodeProperty)props.nextElement();
                if (result.contains(np)) continue;
                result.addProperty((RequestedProperty)new RequestedPropertyImpl(np.getName(), np.getNamespace()));
            }
        }
        return result;
    }

    public RequestedProperties getAllPropertyNames(ResourceKind resourceKind) throws SlideException {
        RequestedPropertiesImpl result = new RequestedPropertiesImpl();
        Iterator liveprops = resourceKind.getSupportedLiveProperties().iterator();
        while (liveprops.hasNext()) {
            result.addProperty((RequestedProperty)new RequestedPropertyImpl((String)liveprops.next(), DNSP.getURI()));
        }
        return result;
    }
}

