/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import org.apache.slide.webdav.util.WebdavStatus;

public class ViolatedPrecondition {
    public static final String PRECONDITION_MUST_NOT_BE_NULL = "Parameter 'precondition' must not be null";
    protected int statusCode = 403;
    protected String precondition = null;
    protected String explanation = null;
    protected String stringRepresentation = null;

    public ViolatedPrecondition(String precondition, int statusCode) {
        this(precondition, statusCode, null);
    }

    public ViolatedPrecondition(String precondition, int statusCode, String explanation) {
        if (precondition == null) {
            throw new IllegalArgumentException(PRECONDITION_MUST_NOT_BE_NULL);
        }
        this.precondition = precondition;
        this.statusCode = statusCode;
        this.explanation = explanation;
    }

    public String getPrecondition() {
        return this.precondition;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other instanceof ViolatedPrecondition) {
            ViolatedPrecondition otherViolatedPrecondition = (ViolatedPrecondition)other;
            isEqual = this.getPrecondition().equals(otherViolatedPrecondition.getPrecondition());
            isEqual &= this.getStatusCode() == otherViolatedPrecondition.getStatusCode();
        }
        return isEqual;
    }

    public int hashCode() {
        return 13 * this.getPrecondition().hashCode() + this.getStatusCode();
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuffer buffer = new StringBuffer("ViolatedPrecondition[");
            buffer.append(this.getPrecondition());
            buffer.append(", ");
            buffer.append(this.getStatusCode());
            buffer.append(" ");
            buffer.append(WebdavStatus.getStatusText(this.getStatusCode()));
            buffer.append("]");
            this.stringRepresentation = buffer.toString();
        }
        return this.stringRepresentation;
    }
}

