/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.webdav.util;

import java.net.SocketException;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.SlideTokenImpl;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.event.VetoException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.macro.ForbiddenException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.Configuration;
import org.apache.slide.webdav.WebdavException;
import org.apache.slide.webdav.WebdavServletConfig;
import org.apache.slide.webdav.method.MethodNotAllowedException;
import org.apache.slide.webdav.util.URLUtil;
import org.apache.slide.webdav.util.UriHandler;

public class WebdavUtils {
    private static final String CREDENTIALS_ATTRIBUTE = "org.apache.slide.webdav.method.credentials";

    public static String decodeURL(String path) {
        return WebdavUtils.decodeURL(path, Configuration.urlEncoding());
    }

    public static String decodeURL(String path, String enc) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = URLUtil.URLDecode(path, enc);
        if (normalized == null) {
            return null;
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String encodeURL(String path) {
        return URLUtil.URLEncode(path, Configuration.urlEncoding());
    }

    public static String encodeURL(String path, String enc) {
        return URLUtil.URLEncode(path, enc);
    }

    public static String getAbsolutePath(String uri, HttpServletRequest req, WebdavServletConfig config) {
        return WebdavUtils.getAbsolutePath(uri, req.getContextPath(), req.getServletPath(), config);
    }

    public static String getAbsolutePath(String uri, String contextPath, String servletPath, WebdavServletConfig config) {
        String result = uri;
        int scopeLength = config.getScope().length();
        if (scopeLength > 0) {
            result = uri.substring(scopeLength);
        }
        if (!config.isDefaultServlet()) {
            contextPath = contextPath + servletPath;
        }
        result = contextPath + result;
        return WebdavUtils.encodeURL(result);
    }

    public static String getAbsolutePath(String uri, String slideContextPath, WebdavServletConfig config) {
        String result = uri;
        int scopeLength = config.getScope().length();
        if (scopeLength > 0) {
            result = uri.substring(scopeLength);
        }
        result = slideContextPath + result;
        return WebdavUtils.encodeURL(result);
    }

    public static String getRelativePath(HttpServletRequest req, WebdavServletConfig config) {
        String result = null;
        result = config.isDefaultServlet() ? req.getServletPath() : req.getPathInfo();
        if (result == null || result.length() == 0) {
            result = "/";
        }
        result = config.getScope() + result;
        return WebdavUtils.decodeURL(WebdavUtils.fixTomcatURL(result, "UTF-8"));
    }

    public static String fixTomcatURL(String input, String fromEncoding) {
        if (input == null) {
            return null;
        }
        String result = null;
        try {
            result = WebdavUtils.encodeURL(new String(input.getBytes(fromEncoding), Configuration.urlEncoding()), Configuration.urlEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String fixTomcatHeader(String header, String toEncoding) {
        if (header == null) {
            return null;
        }
        String result = null;
        try {
            result = URLUtil.URLDecode(new String(header.getBytes("ISO-8859-1"), toEncoding), toEncoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static SlideToken getSlideToken(HttpServletRequest req) {
        CredentialsToken credentialsToken;
        Principal principal = req.getUserPrincipal();
        HttpSession session = req.getSession();
        if (principal == null) {
            String credentials = (String)session.getAttribute(CREDENTIALS_ATTRIBUTE);
            credentialsToken = new CredentialsToken(credentials == null ? "" : credentials);
        } else {
            session.setAttribute(CREDENTIALS_ATTRIBUTE, (Object)principal.getName());
            credentialsToken = new CredentialsToken(principal);
        }
        SlideTokenImpl token = new SlideTokenImpl(credentialsToken);
        token.setEnforceLockTokens(true);
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            token.addParameter(name, session.getAttribute(name));
        }
        return token;
    }

    public static boolean isCollection(NamespaceAccessToken token, SlideToken slideToken, String path) {
        if (Configuration.useVersionControl()) {
            UriHandler uh = UriHandler.getUriHandler(path);
            if (uh.isWorkspaceUri()) {
                return true;
            }
            if (uh.isHistoryUri()) {
                return true;
            }
            if (uh.isVersionUri()) {
                return false;
            }
        }
        try {
            Content content = token.getContentHelper();
            NodeRevisionDescriptors revisionDescriptors = content.retrieve(slideToken, path);
            if (revisionDescriptors.hasRevisions()) {
                NodeRevisionDescriptor revisionDescriptor = content.retrieve(slideToken, revisionDescriptors);
                return WebdavUtils.isCollection(revisionDescriptor);
            }
            return true;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
        catch (SlideException e) {
            return true;
        }
    }

    public static boolean isCollection(NodeRevisionDescriptor revisionDescriptor) {
        boolean result = false;
        if (revisionDescriptor == null) {
            return true;
        }
        if (revisionDescriptor.propertyValueContains("resourcetype", "collection")) {
            result = true;
        }
        return result;
    }

    public static String getSlidePath(String fullpath, String slideContextPath) {
        if (fullpath.indexOf("://") >= 0) {
            fullpath = fullpath.substring(fullpath.indexOf("://") + 3);
            fullpath = fullpath.substring(fullpath.indexOf("/"));
        }
        if (fullpath.startsWith(slideContextPath)) {
            fullpath = fullpath.substring(slideContextPath.length());
        }
        return fullpath;
    }

    public static int getErrorCode(Throwable ex) {
        if (!(ex instanceof SlideException)) {
            return 500;
        }
        return WebdavUtils.getErrorCode((SlideException)ex);
    }

    public static int getErrorCode(SlideException ex) {
        try {
            throw ex;
        }
        catch (ObjectNotFoundException e) {
            return 404;
        }
        catch (ConflictException e) {
            return 409;
        }
        catch (ForbiddenException e) {
            return 403;
        }
        catch (AccessDeniedException e) {
            return 403;
        }
        catch (ObjectAlreadyExistsException e) {
            return 412;
        }
        catch (ServiceAccessException e) {
            return WebdavUtils.getErrorCode((ServiceAccessException)((Object)ex));
        }
        catch (ObjectLockedException e) {
            return 423;
        }
        catch (WebdavException e) {
            return e.getStatusCode();
        }
        catch (MethodNotAllowedException e) {
            return 405;
        }
        catch (VetoException e) {
            return 406;
        }
        catch (SlideException e) {
            return 500;
        }
    }

    public static int getErrorCode(ServiceAccessException ex) {
        Throwable cause = ex.getCauseException();
        if (cause != null && cause instanceof SocketException) {
            return 412;
        }
        if (cause == null || !(cause instanceof SlideException)) {
            if (cause != null) {
                cause.printStackTrace();
            }
            return 500;
        }
        return WebdavUtils.getErrorCode((SlideException)cause);
    }
}

