/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.grammar.Tree;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ResultDocumentFactory
extends FactoryBase {
    private static Log log;
    private HashSet attrNames = new HashSet();

    public ResultDocumentFactory() {
        this.attrNames.add("href");
        this.attrNames.add("output-encoding");
        this.attrNames.add("output-method");
    }

    public String getName() {
        return "result-document";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        String string2 = FactoryBase.getAttribute(string, attributes, "href", parseContext);
        Tree tree = FactoryBase.parseAVT(string2, parseContext);
        String string3 = attributes.getValue("output-encoding");
        String string4 = attributes.getValue("output-method");
        if (string4 != null && !string4.equals("text") && !string4.equals("xml") && string4.indexOf(58) == -1) {
            throw new SAXParseException("Value of attribute `output-method' must be `xml', `text', or a qualified name. Found `" + string4 + "'", parseContext.locator);
        }
        FactoryBase.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, tree, string3, string4);
    }

    public final class Instance
    extends NodeBase {
        private Tree href;
        private String encoding;
        private String method;

        protected Instance(String string, NodeBase nodeBase, ParseContext parseContext, Tree tree, String string2, String string3) {
            super(string, nodeBase, parseContext, true);
            this.href = tree;
            this.encoding = string2;
            this.method = string3;
        }

        public short process(Context context) throws SAXException {
            super.process(context);
            if (this.encoding == null) {
                this.encoding = context.currentProcessor.getOutputEncoding();
            }
            String string = this.href.evaluate((Context)context, (NodeBase)this).string;
            StreamEmitter streamEmitter = null;
            try {
                Writer writer = context.emitter.getResultWriter(string, this.encoding, this.publicId, this.systemId, this.lineNo, this.colNo);
                Properties properties = (Properties)context.currentProcessor.outputProperties.clone();
                properties.setProperty("encoding", this.encoding);
                if (this.method != null) {
                    properties.setProperty("method", this.method);
                }
                streamEmitter = new StreamEmitter(writer, properties);
                this.localFieldStack.push(writer);
            }
            catch (IOException iOException) {
                context.errorHandler.error(iOException.toString(), this.publicId, this.systemId, this.lineNo, this.colNo);
                return 0;
            }
            context.emitter.pushEmitter(streamEmitter);
            context.emitter.startDocument();
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            context.emitter.endDocument(this.publicId, this.systemId, this.nodeEnd.lineNo, this.nodeEnd.colNo);
            context.emitter.popEmitter();
            try {
                ((Writer)this.localFieldStack.pop()).close();
            }
            catch (IOException iOException) {
                context.errorHandler.error(iOException.toString(), this.publicId, this.systemId, this.nodeEnd.lineNo, this.nodeEnd.colNo);
                return 0;
            }
            return super.processEnd(context);
        }
    }
}

