/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.instruction;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashSet;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.emitter.StringEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.instruction.FactoryBase;
import net.sf.joost.instruction.NodeBase;
import net.sf.joost.stx.Context;
import net.sf.joost.stx.ParseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TextFactory
extends FactoryBase {
    private HashSet attrNames = new HashSet();
    private static final String[] MARKUP_VALUES = new String[]{"error", "ignore", "serialize"};
    private int NO_MARKUP = 0;
    private int IGNORE_MARKUP = 1;
    private int SERIALIZE_MARKUP = 2;

    public TextFactory() {
        this.attrNames.add("markup");
    }

    public String getName() {
        return "text";
    }

    public NodeBase createNode(NodeBase nodeBase, String string, Attributes attributes, ParseContext parseContext) throws SAXParseException {
        int n = FactoryBase.getEnumAttValue("markup", attributes, MARKUP_VALUES, parseContext);
        if (n == -1) {
            n = this.NO_MARKUP;
        }
        FactoryBase.checkAttributes(string, attributes, this.attrNames, parseContext);
        return new Instance(string, nodeBase, parseContext, n);
    }

    public class Instance
    extends NodeBase {
        private StxEmitter stxEmitter;
        private StringBuffer buffer;
        private int recursionLevel = 0;

        public Instance(String string, NodeBase nodeBase, ParseContext parseContext, int n) throws SAXParseException {
            super(string, nodeBase, parseContext, true);
            if (n == TextFactory.this.SERIALIZE_MARKUP) {
                StringWriter stringWriter = new StringWriter();
                this.buffer = stringWriter.getBuffer();
                try {
                    this.stxEmitter = new StreamEmitter(stringWriter);
                }
                catch (IOException iOException) {
                    throw new SAXParseException(null, parseContext.locator, iOException);
                }
            } else {
                this.buffer = new StringBuffer();
                this.stxEmitter = new StringEmitter(this.buffer, n == TextFactory.this.NO_MARKUP ? "(`" + string + "' with the `markup' attribute set to `" + MARKUP_VALUES[TextFactory.this.NO_MARKUP] + "' started in line " + this.lineNo + ")" : null);
            }
        }

        public short process(Context context) throws SAXException {
            super.process(context);
            if (this.recursionLevel++ == 0) {
                this.buffer.setLength(0);
                context.emitter.pushEmitter(this.stxEmitter);
            }
            return 0;
        }

        public short processEnd(Context context) throws SAXException {
            if (--this.recursionLevel == 0) {
                context.emitter.popEmitter();
                context.emitter.characters(this.buffer.toString().toCharArray(), 0, this.buffer.length());
            }
            return super.processEnd(context);
        }
    }
}

