/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;
import net.sf.joost.Constants;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.stx.ErrorHandlerImpl;
import net.sf.joost.stx.SAXEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class Emitter
implements Constants {
    private ContentHandler contH;
    private LexicalHandler lexH;
    private ErrorHandlerImpl errorHandler;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private Stack nsStack = new Stack();
    private String nsDefault = "";
    private Stack openedElements = new Stack();
    private Stack emitterStack = new Stack();
    private String lastUri;
    private String lastLName;
    private String lastQName;
    private AttributesImpl lastAttrs;
    private String lastPublicId;
    private String lastSystemId;
    private int lastLineNo;
    private int lastColNo;
    private boolean insideCDATA = false;

    public Emitter(ErrorHandlerImpl errorHandlerImpl) {
        this.errorHandler = errorHandlerImpl;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contH = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexH = lexicalHandler;
    }

    private void processLastElement() throws SAXException {
        try {
            this.contH.startElement(this.lastUri, this.lastLName, this.lastQName, this.lastAttrs);
        }
        catch (SAXException sAXException) {
            this.errorHandler.error(sAXException.getMessage(), this.lastPublicId, this.lastSystemId, this.lastLineNo, this.lastColNo);
        }
        this.openedElements.push(this.lastUri);
        this.openedElements.push(this.lastQName);
        this.lastAttrs = null;
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, String string6, int n, int n2) throws SAXException {
        if (this.lastAttrs == null) {
            this.errorHandler.error("Can't create an attribute if there's no opened element", string5, string6, n, n2);
            return;
        }
        if (this.contH != null) {
            String string7;
            int n3 = this.lastAttrs.getIndex(string, string3);
            if (n3 != -1) {
                this.lastAttrs.setValue(n3, string4);
            } else {
                this.lastAttrs.addAttribute(string, string3, string2, "CDATA", string4);
            }
            int n4 = string2.indexOf(":");
            if (n4 != -1 && !string.equals(this.nsSupport.getURI(string7 = string2.substring(0, n4)))) {
                this.nsSupport.declarePrefix(string7, string);
                this.nsStack.push(string7);
                this.contH.startPrefixMapping(string7, string);
            }
        }
    }

    public void startDocument() throws SAXException {
        if (this.contH != null) {
            this.contH.startDocument();
        }
    }

    public void endDocument(String string, String string2, int n, int n2) throws SAXException {
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            if (!this.openedElements.isEmpty()) {
                this.errorHandler.fatalError("Missing end tag for `" + this.openedElements.pop() + "' at the document end", string, string2, n, n2);
            }
            this.contH.endDocument();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable, String string4, String string5, int n, int n2) throws SAXException {
        if (this.contH != null) {
            Object object;
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            this.nsSupport.pushContext();
            this.nsStack.push(null);
            int n3 = string3.indexOf(":");
            if (n3 != -1) {
                object = string3.substring(0, n3);
                if (!string.equals(this.nsSupport.getURI((String)object))) {
                    this.nsSupport.declarePrefix((String)object, string);
                    this.nsStack.push(object);
                    this.contH.startPrefixMapping((String)object, string);
                }
            } else if (!string.equals(this.nsDefault)) {
                this.nsSupport.declarePrefix("", string);
                this.nsDefault = string;
                this.nsStack.push("");
                this.contH.startPrefixMapping("", string);
            }
            this.lastUri = string;
            this.lastLName = string2;
            this.lastQName = string3;
            this.lastAttrs = attributes.getLength() != 0 ? new AttributesImpl(attributes) : new AttributesImpl();
            if (hashtable != null) {
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string6 = (String)object.nextElement();
                    String string7 = (String)hashtable.get(string6);
                    if ("".equals(string6)) {
                        if (string7.equals(this.nsDefault)) continue;
                        this.contH.startPrefixMapping("", string7);
                        this.nsSupport.declarePrefix("", string7);
                        this.nsDefault = string7;
                        this.nsStack.push("");
                        continue;
                    }
                    if (string7.equals(this.nsSupport.getURI(string6))) continue;
                    this.contH.startPrefixMapping(string6, string7);
                    this.nsSupport.declarePrefix(string6, string7);
                    this.nsStack.push(string6);
                }
            }
            this.lastPublicId = string4;
            this.lastSystemId = string5;
            this.lastLineNo = n;
            this.lastColNo = n2;
        }
    }

    public void endElement(String string, String string2, String string3, String string4, String string5, int n, int n2) throws SAXException {
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            if (this.openedElements.isEmpty()) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag " + (string3 != null ? "`" + string3 + "' " : "") + "(no element opened)", string4, string5, n, n2);
                return;
            }
            String string6 = (String)this.openedElements.pop();
            String string7 = (String)this.openedElements.pop();
            if (!string3.equals(string6)) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag `" + string3 + "' (`" + string6 + "' expected)", string4, string5, n, n2);
                return;
            }
            if (!string.equals(string7)) {
                this.errorHandler.fatalError("Attempt to emit unmatched end tag `{" + string + "}" + string3 + "' (`{" + string7 + "}" + string6 + "' expected)", string4, string5, n, n2);
                return;
            }
            this.contH.endElement(string, string2, string3);
            this.nsSupport.popContext();
            String string8 = (String)this.nsStack.pop();
            while (string8 != null) {
                this.contH.endPrefixMapping(string8);
                if (string8 == "") {
                    this.nsDefault = this.nsSupport.getURI("");
                    if (this.nsDefault == null) {
                        this.nsDefault = "";
                    }
                }
                string8 = (String)this.nsStack.pop();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.contH != null) {
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            if (this.insideCDATA) {
                String string = new String(cArray, n, n2);
                int n3 = string.indexOf("]]>");
                while (n3 != -1) {
                    this.contH.characters(string.substring(0, n3 += 2).toCharArray(), 0, n3);
                    this.lexH.endCDATA();
                    this.lexH.startCDATA();
                    string = string.substring(n3);
                    n3 = string.indexOf("]]>");
                }
                this.contH.characters(string.toCharArray(), 0, string.length());
            } else {
                this.contH.characters(cArray, n, n2);
            }
        }
    }

    public void processingInstruction(String string, String string2, String string3, String string4, int n, int n2) throws SAXException {
        block3: {
            if (this.contH == null) break block3;
            if (this.lastAttrs != null) {
                this.processLastElement();
            }
            try {
                this.contH.processingInstruction(string, string2);
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), string3, string4, n, n2);
            }
        }
    }

    public void comment(char[] cArray, int n, int n2, String string, String string2, int n3, int n4) throws SAXException {
        block3: {
            if (this.contH != null && this.lastAttrs != null) {
                this.processLastElement();
            }
            if (this.lexH == null) break block3;
            try {
                this.lexH.comment(cArray, n, n2);
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), string, string2, n3, n4);
            }
        }
    }

    public void startCDATA(String string, String string2, int n, int n2) throws SAXException {
        if (this.contH != null && this.lastAttrs != null) {
            this.processLastElement();
        }
        if (this.lexH != null) {
            try {
                this.lexH.startCDATA();
            }
            catch (SAXException sAXException) {
                this.errorHandler.error(sAXException.getMessage(), string, string2, n, n2);
            }
            this.insideCDATA = true;
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexH != null) {
            this.lexH.endCDATA();
            this.insideCDATA = false;
        }
    }

    public void pushEmitter(StxEmitter stxEmitter) throws SAXException {
        this.emitterStack.push(this.contH);
        this.emitterStack.push(this.lexH);
        if (this.lastAttrs != null) {
            this.emitterStack.push(SAXEvent.newElement(this.lastUri, this.lastLName, this.lastQName, this.lastAttrs, null));
            this.lastAttrs = null;
        } else {
            this.emitterStack.push(null);
        }
        this.contH = stxEmitter;
        this.lexH = stxEmitter;
        this.emitterStack.push(this.nsSupport);
        this.nsSupport = new NamespaceSupport();
        this.nsDefault = "";
        this.emitterStack.push(this.openedElements);
        this.openedElements = new Stack();
    }

    public StxEmitter popEmitter() throws SAXException {
        if (this.lastAttrs != null) {
            this.processLastElement();
        }
        StxEmitter stxEmitter = null;
        if (this.contH instanceof StxEmitter) {
            Object e;
            stxEmitter = (StxEmitter)this.contH;
            this.openedElements = (Stack)this.emitterStack.pop();
            this.nsSupport = (NamespaceSupport)this.emitterStack.pop();
            this.nsDefault = this.nsSupport.getURI("");
            if (this.nsDefault == null) {
                this.nsDefault = "";
            }
            if ((e = this.emitterStack.pop()) != null) {
                SAXEvent sAXEvent = (SAXEvent)e;
                this.lastUri = sAXEvent.uri;
                this.lastQName = sAXEvent.qName;
                this.lastLName = sAXEvent.lName;
                this.lastAttrs = (AttributesImpl)sAXEvent.attrs;
            }
        } else {
            throw new SAXException("No StxEmitter on the emitter stack");
        }
        this.lexH = (LexicalHandler)this.emitterStack.pop();
        this.contH = (ContentHandler)this.emitterStack.pop();
        return stxEmitter;
    }

    public boolean isEmitterActive(StxEmitter stxEmitter) {
        return this.contH == stxEmitter || this.emitterStack.search(stxEmitter) != -1;
    }

    public Writer getResultWriter(String string, String string2, String string3, String string4, int n, int n2) throws IOException, SAXException {
        OutputStreamWriter outputStreamWriter;
        Object object;
        int n3 = string.lastIndexOf(47);
        if (n3 != -1) {
            object = new File(string.substring(0, n3));
            ((File)object).mkdirs();
        }
        object = new FileOutputStream(string);
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)object, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string5 = "Unsupported encoding `" + string2 + "', using " + "UTF-8";
            this.errorHandler.warning(string5, string3, string4, n, n2);
            string2 = "UTF-8";
            outputStreamWriter = new OutputStreamWriter((OutputStream)object, "UTF-8");
        }
        return outputStreamWriter;
    }
}

