/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.stx;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.joost.trax.SourceLocatorImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ErrorHandlerImpl
implements ErrorHandler {
    public ErrorListener errorListener;
    private boolean configurationFlag = false;

    public ErrorHandlerImpl() {
    }

    public ErrorHandlerImpl(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorHandlerImpl(boolean bl) {
        this.configurationFlag = bl;
    }

    public ErrorHandlerImpl(ErrorListener errorListener, boolean bl) {
        this.errorListener = errorListener;
        this.configurationFlag = bl;
    }

    private TransformerException newException(String string, SourceLocator sourceLocator) {
        if (this.configurationFlag) {
            return new TransformerConfigurationException(string, sourceLocator);
        }
        return new TransformerException(string, sourceLocator);
    }

    public void warning(String string, Locator locator) throws SAXException {
        this.warning(this.newException(string, new SourceLocatorImpl(locator)));
    }

    public void warning(String string, String string2, String string3, int n, int n2) throws SAXException {
        this.warning(this.newException(string, new SourceLocatorImpl(string2, string3, n, n2)));
    }

    public void warning(TransformerException transformerException) throws SAXException {
        try {
            if (this.errorListener == null) {
                return;
            }
            this.errorListener.warning(transformerException);
        }
        catch (TransformerException transformerException2) {
            throw new SAXException(transformerException2);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.errorListener == null) {
            return;
        }
        this.warning(sAXParseException.getMessage(), sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
    }

    public void error(String string, Locator locator) throws SAXException {
        this.error(this.newException(string, new SourceLocatorImpl(locator)));
    }

    public void error(String string, String string2, String string3, int n, int n2) throws SAXException {
        this.error(this.newException(string, new SourceLocatorImpl(string2, string3, n, n2)));
    }

    public void error(TransformerException transformerException) throws SAXException {
        try {
            if (this.errorListener == null) {
                throw transformerException;
            }
            this.errorListener.error(transformerException);
        }
        catch (TransformerException transformerException2) {
            throw new SAXException(transformerException2);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        Exception exception = sAXParseException.getException();
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        this.error(sAXParseException.getMessage(), sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
    }

    public void fatalError(String string, Locator locator) throws SAXException {
        this.fatalError(this.newException(string, new SourceLocatorImpl(locator)));
    }

    public void fatalError(String string, String string2, String string3, int n, int n2) throws SAXException {
        this.fatalError(this.newException(string, new SourceLocatorImpl(string2, string3, n, n2)));
    }

    public void fatalError(TransformerException transformerException) throws SAXException {
        try {
            if (this.errorListener == null) {
                throw transformerException;
            }
            this.errorListener.fatalError(transformerException);
        }
        catch (TransformerException transformerException2) {
            throw new SAXException(transformerException2);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        Exception exception = sAXParseException.getException();
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        this.fatalError(sAXParseException.getMessage(), sAXParseException.getPublicId(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
    }
}

