/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trax;

import java.io.IOException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.joost.emitter.SAXEmitter;
import net.sf.joost.stx.Processor;
import net.sf.joost.trax.ConfigurationErrListener;
import net.sf.joost.trax.TemplatesImpl;
import net.sf.joost.trax.TransformerImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class TrAXFilter
extends XMLFilterImpl {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$joost$trax$TrAXFilter == null ? (class$net$sf$joost$trax$TrAXFilter = TrAXFilter.class$("net.sf.joost.trax.TrAXFilter")) : class$net$sf$joost$trax$TrAXFilter));
    private Templates templates = null;
    private Processor processor = null;
    private ConfigurationErrListener configErrListener;
    static /* synthetic */ Class class$net$sf$joost$trax$TrAXFilter;

    protected TrAXFilter(Templates templates) throws TransformerConfigurationException {
        log.debug((Object)"calling constructor");
        this.templates = templates;
        if (templates instanceof TemplatesImpl) {
            this.configErrListener = ((TemplatesImpl)templates).factory.defaultErrorListener;
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        Transformer transformer = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("parsing InputSource " + inputSource.getSystemId()));
        }
        try {
            ContentHandler contentHandler;
            transformer = this.templates.newTransformer();
            if (transformer instanceof TransformerImpl) {
                this.processor = ((TransformerImpl)transformer).getStxProcessor();
            } else {
                log.fatal((Object)"An error is occured, because the given transfomer is not an instance of TransformerImpl");
            }
            XMLReader xMLReader = this.getParent();
            if (xMLReader == null) {
                xMLReader = XMLReaderFactory.createXMLReader();
                this.setParent(xMLReader);
            }
            if ((contentHandler = this.getContentHandler()) == null) {
                contentHandler = xMLReader.getContentHandler();
            }
            if (contentHandler == null) {
                throw new SAXException("no ContentHandler registered");
            }
            SAXEmitter sAXEmitter = null;
            if (contentHandler != null) {
                sAXEmitter = new SAXEmitter(contentHandler);
            }
            if (this.processor == null) {
                throw new SAXException("Joost-Processor is not correct configured.");
            }
            this.processor.setContentHandler(sAXEmitter);
            this.processor.setLexicalHandler(sAXEmitter);
            if (xMLReader == null) {
                throw new SAXException("No parent for filter");
            }
            xMLReader.setContentHandler(this.processor);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.processor);
            xMLReader.parse(inputSource);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            try {
                this.configErrListener.fatalError(transformerConfigurationException);
            }
            catch (TransformerConfigurationException transformerConfigurationException2) {
                throw new SAXException(transformerConfigurationException2.getMessage(), transformerConfigurationException2);
            }
        }
        catch (SAXException sAXException) {
            try {
                this.configErrListener.fatalError(new TransformerConfigurationException(sAXException.getMessage(), sAXException));
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new SAXException(transformerConfigurationException.getMessage(), transformerConfigurationException);
            }
        }
        catch (IOException iOException) {
            try {
                this.configErrListener.fatalError(new TransformerConfigurationException(iOException.getMessage(), iOException));
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new IOException(transformerConfigurationException.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

