/*
 * Decompiled with CFR 0.152.
 */
package net.sf.joost.trax;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.joost.TransformerHandlerResolver;
import net.sf.joost.emitter.StreamEmitter;
import net.sf.joost.emitter.StxEmitter;
import net.sf.joost.stx.Processor;
import net.sf.joost.trace.ParserListenerMgr;
import net.sf.joost.trax.ConfigurationErrListener;
import net.sf.joost.trax.TemplatesHandlerImpl;
import net.sf.joost.trax.TemplatesImpl;
import net.sf.joost.trax.TrAXConstants;
import net.sf.joost.trax.TrAXFilter;
import net.sf.joost.trax.TrAXHelper;
import net.sf.joost.trax.TransformerHandlerImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class TransformerFactoryImpl
extends SAXTransformerFactory
implements TrAXConstants {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$joost$trax$TransformerFactoryImpl == null ? (class$net$sf$joost$trax$TransformerFactoryImpl = TransformerFactoryImpl.class$("net.sf.joost.trax.TransformerFactoryImpl")) : class$net$sf$joost$trax$TransformerFactoryImpl));
    private URIResolver uriResolver = null;
    private ErrorListener errorListener = null;
    protected TransformerHandlerResolver thResolver = null;
    protected ConfigurationErrListener defaultErrorListener = new ConfigurationErrListener();
    private boolean debugmode = false;
    private StxEmitter msgEmitter;
    private Boolean reentryGuard = new Boolean(true);
    private ParserListenerMgr parserListenerMgr = new ParserListenerMgr();
    static /* synthetic */ Class class$net$sf$joost$trax$TransformerFactoryImpl;

    public TransformerFactoryImpl() throws IOException {
        this.msgEmitter = new StreamEmitter(System.err, null);
        ((StreamEmitter)this.msgEmitter).setOmitXmlDeclaration(true);
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException("Feature not supported");
        this.defaultErrorListener.fatalError(transformerConfigurationException);
        return null;
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        if (string.equals("http://joost.sf.net/attributes/transformer-handler-resolver")) {
            return this.thResolver;
        }
        if (string.equals("http://joost.sf.net/attributes/debug-feature")) {
            return new Boolean(this.debugmode);
        }
        if (string.equals("http://joost.sf.net/attributes/messageEmitterClass")) {
            return this.msgEmitter;
        }
        log.warn((Object)("Feature not supported: " + string));
        throw new IllegalArgumentException("Feature not supported: " + string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals("http://joost.sf.net/attributes/transformer-handler-resolver")) {
            this.thResolver = (TransformerHandlerResolver)object;
            return;
        } else if (string.equals("http://joost.sf.net/attributes/debug-feature")) {
            this.debugmode = (Boolean)object;
            return;
        } else if (string.equals("http://joost.sf.net/attributes/messageEmitterClass")) {
            if (object instanceof String) {
                try {
                    this.msgEmitter = this.buildMessageEmitter((String)object);
                    return;
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    log.fatal((Object)transformerConfigurationException.getMessage(), (Throwable)transformerConfigurationException);
                    throw new IllegalArgumentException(transformerConfigurationException.getMessage());
                }
            } else {
                if (!(object instanceof StxEmitter)) throw new IllegalArgumentException("Emitter is of wrong type,should be either a String or a StxEmitter");
                this.msgEmitter = (StxEmitter)object;
            }
            return;
        } else {
            log.warn((Object)("Feature not supported: " + string));
            throw new IllegalArgumentException("Feature not supported: " + string);
        }
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            if (errorListener == null) {
                throw new IllegalArgumentException("ErrorListener is null");
            }
            this.errorListener = errorListener;
            this.defaultErrorListener.setUserErrorListener(errorListener);
        }
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURIResolver(URIResolver uRIResolver) {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            this.uriResolver = uRIResolver;
        }
    }

    public boolean getFeature(String string) {
        if (string.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter")) {
            return true;
        }
        String string2 = "Unknown feature " + string;
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string2);
        try {
            this.defaultErrorListener.error(transformerConfigurationException);
            return false;
        }
        catch (TransformerException transformerException) {
            throw new IllegalArgumentException(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            try {
                SAXSource sAXSource = TrAXHelper.getSAXSource(source, this.errorListener);
                TemplatesImpl templatesImpl = new TemplatesImpl(sAXSource.getXMLReader(), sAXSource.getInputSource(), this);
                return templatesImpl;
            }
            catch (TransformerException transformerException) {
                this.defaultErrorListener.fatalError(transformerException);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformer newTransformer() throws TransformerConfigurationException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            StreamSource streamSource = new StreamSource(new StringReader("<?xml version='1.0'?><stx:transform xmlns:stx='http://stx.sourceforge.net/2002/ns' version='1.0' pass-through='all' />"));
            return this.newTransformer(streamSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            Templates templates = this.newTemplates(source);
            Transformer transformer = templates.newTransformer();
            return transformer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            TemplatesHandlerImpl templatesHandlerImpl = new TemplatesHandlerImpl(this);
            return templatesHandlerImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            StreamSource streamSource = new StreamSource(new StringReader("<?xml version='1.0'?><stx:transform xmlns:stx='http://stx.sourceforge.net/2002/ns' version='1.0' pass-through='all' />"));
            return this.newTransformerHandler(streamSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            Templates templates = this.newTemplates(source);
            return this.newTransformerHandler(templates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Boolean bl = this.reentryGuard;
        synchronized (bl) {
            Transformer transformer = templates.newTransformer();
            TransformerHandlerImpl transformerHandlerImpl = new TransformerHandlerImpl(transformer);
            return transformerHandlerImpl;
        }
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        XMLFilter xMLFilter = null;
        try {
            Templates templates = this.newTemplates(source);
            XMLReader xMLReader = Processor.getXMLReader();
            xMLFilter = this.newXMLFilter(templates);
            xMLFilter.setParent(xMLReader);
            return xMLFilter;
        }
        catch (SAXException sAXException) {
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(sAXException.getMessage(), sAXException);
            this.defaultErrorListener.fatalError(transformerConfigurationException);
            return null;
        }
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.defaultErrorListener.fatalError(transformerConfigurationException);
            return null;
        }
    }

    public ParserListenerMgr getParserListenerMgr() {
        return this.parserListenerMgr;
    }

    public StxEmitter getMessageEmitter() {
        return this.msgEmitter;
    }

    public StxEmitter buildMessageEmitter(String string) throws TransformerConfigurationException {
        Object var2_2 = null;
        try {
            var2_2 = this.loadClass(string).newInstance();
            if (!(var2_2 instanceof StxEmitter)) {
                throw new TransformerConfigurationException(string + " is not an StxEmitter");
            }
        }
        catch (InstantiationException instantiationException) {
            throw new TransformerConfigurationException(instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TransformerConfigurationException(illegalAccessException.getMessage(), illegalAccessException);
        }
        return var2_2;
    }

    private Class loadClass(String string) throws TransformerConfigurationException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(string);
                }
                catch (Exception exception) {
                    return Class.forName(string);
                }
            }
            return Class.forName(string);
        }
        catch (Exception exception) {
            throw new TransformerConfigurationException("Failed to load " + string, exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

