/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.index;

import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.slide.common.Domain;
import org.apache.slide.common.SlideException;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.RequestedResource;
import org.apache.slide.search.SearchException;
import org.apache.slide.search.basic.BasicResultSetImpl;
import org.apache.slide.search.basic.ComparableResourceImpl;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.apache.slide.search.basic.IBasicResultSet;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.SubjectNode;

public class TextContainsExpression
implements IBasicExpression {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$index$TextContainsExpression == null ? (class$org$apache$slide$index$TextContainsExpression = TextContainsExpression.class$("org.apache.slide.index.TextContainsExpression")) : class$org$apache$slide$index$TextContainsExpression).getName();
    String searchedText;
    String indexPath;
    Analyzer analyzer;
    IBasicExpressionFactory factory;
    static /* synthetic */ Class class$org$apache$slide$index$TextContainsExpression;

    TextContainsExpression(String searchedText, String rootPath, Analyzer analyzer) {
        this.searchedText = searchedText;
        this.indexPath = rootPath;
        this.analyzer = analyzer;
    }

    TextContainsExpression(String mergeOperator, Collection children, IBasicExpressionFactory factory) throws BadQueryException {
    }

    public IBasicResultSet execute() throws SearchException {
        BasicResultSetImpl result = new BasicResultSetImpl(false);
        try {
            IndexSearcher searcher = new IndexSearcher(this.indexPath);
            Query query = QueryParser.parse((String)this.searchedText, (String)"content", (Analyzer)this.analyzer);
            Hits hits = searcher.search(query);
            int noOfHits = hits.length();
            for (int i = 0; i < noOfHits; ++i) {
                IBasicQuery q;
                String scope;
                Document doc = hits.doc(i);
                String uri = doc.get("uri");
                if (!uri.startsWith(scope = (q = this.factory.getQuery()).getSearchToken().getSlideContext().getSlidePath(q.getScope().getHref()))) continue;
                RequestedResource resource = this.createResource(uri);
                result.add((Object)resource);
            }
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
        Domain.log((Object)("Executed Search for '" + this.searchedText + "' in the index"), (String)LOG_CHANNEL, (int)6);
        return result;
    }

    private RequestedResource createResource(String uri) throws SearchException {
        SubjectNode node = new SubjectNode(uri);
        ComparableResourceImpl resource = null;
        IBasicQuery query = this.factory.getQuery();
        try {
            resource = new ComparableResourceImpl((ObjectNode)node, query.getSearchToken(), query.getScope(), this.factory.getPropertyProvider());
        }
        catch (SlideException e) {
            throw new SearchException((Throwable)e);
        }
        return resource;
    }

    public void setFactory(IBasicExpressionFactory factory) {
        this.factory = factory;
    }

    public IBasicExpressionFactory getFactory() {
        return this.factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

