/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.index;

import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.slide.index.TextContainsExpression;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicExpressionFactory;
import org.apache.slide.search.basic.IBasicQuery;
import org.jdom.Element;

public class TextContainsExpressionFactory
implements IBasicExpressionFactory {
    private IBasicQuery query;
    protected PropertyProvider propertyProvider;
    private String rootPath;
    private Analyzer analyzer;

    public TextContainsExpressionFactory(String rootPath, Analyzer analyzer) {
        this.rootPath = rootPath;
        this.analyzer = analyzer;
    }

    public IBasicExpression createMergeExpression(String mergeOperator, String namespace, Collection expressionsToMerge) throws BadQueryException {
        return null;
    }

    public IBasicExpression createExpression(Element element) throws BadQueryException {
        TextContainsExpression result = null;
        if (element == null) {
            throw new BadQueryException("expected a where criteria");
        }
        String namespace = element.getNamespace().getURI();
        if (namespace.equals("DAV:")) {
            result = this.createDAVExpression(element);
        }
        result.setFactory(this);
        return result;
    }

    private TextContainsExpression createDAVExpression(Element e) {
        String name = e.getName();
        TextContainsExpression result = null;
        if (name.equals("contains")) {
            String searchedText = e.getTextTrim();
            result = new TextContainsExpression(searchedText, this.rootPath, this.analyzer);
        }
        return result;
    }

    public void init(IBasicQuery query, PropertyProvider propertyProvider) throws BadQueryException {
        this.query = query;
        this.propertyProvider = propertyProvider;
    }

    public PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public IBasicQuery getQuery() {
        return this.query;
    }
}

