/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter;
import org.apache.slide.store.impl.rdbms.StoreContentZip;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.logger.Logger;

public class CommonRDBMSAdapter
extends StandardRDBMSAdapter {
    public CommonRDBMSAdapter(Service service, Logger logger) {
        super(service, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Connection connection, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        PreparedStatement statement = null;
        try {
            this.clearBinding(connection, uri);
            try {
                statement = connection.prepareStatement("delete from LINKS l where l.URI_ID in (select u.URI_ID from URI u where u.URI_STRING = ?)");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete from VERSION_HISTORY vh where vh.URI_ID in (select u.URI_ID from URI u where u.URI_STRING = ?)");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete from VERSION v where v.URI_ID in (select u.URI_ID from URI u where u.URI_STRING = ?)");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete from OBJECT o where o.URI_ID in (select u.URI_ID from URI u where u.URI_STRING = ?)");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete from URI where URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        try {
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement("delete from VERSION_CONTENT vc where vc.VERSION_ID in (select vh.VERSION_ID from VERSION_HISTORY vh, URI u where vh.REVISION_NO = ? and vh.URI_ID=u.URI_ID AND u.URI_STRING=?)");
                statement.setString(1, revisionDescriptor.getRevisionNumber().toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    public void removeRevisionDescriptors(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete from VERSION_PREDS vp where vp.VERSION_ID in (select vh.VERSION_ID from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ?)");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionDescriptor(Connection connection, Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from VERSION_LABELS vl where vl.VERSION_ID in (select vh.VERSION_ID from VERSION_HISTORY vh, URI u where vh.REVISION_NO = ? and vh.URI_ID = u.URI_ID AND u.URI_STRING = ?)");
                statement.setString(1, revisionNumber.toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete from PROPERTIES p where p.VERSION_ID in (select vh.VERSION_ID from VERSION_HISTORY vh, URI u where vh.REVISION_NO = ? and vh.URI_ID = u.URI_ID AND u.URI_STRING = ?)");
                statement.setString(1, revisionNumber.toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from LOCKS where LOCKS.LOCK_ID in (select u.URI_ID from URI u where u.URI_STRING=?)");
                statement.setString(1, lock.getLockId());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete from URI where URI_STRING=?");
                statement.setString(1, lock.getLockId());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    public void revokePermission(Connection connection, Uri uri, NodePermission permission) throws ServiceAccessException {
        if (permission == null) {
            return;
        }
        PreparedStatement statement = null;
        try {
            NodeRevisionNumber revisionNumber = permission.getRevisionNumber();
            statement = connection.prepareStatement("delete from PERMISSIONS where PERMISSIONS.OBJECT_ID in (select ou.URI_ID from URI ou, URI su, URI au where ou.URI_STRING = ? and SUBJECT_ID = su.URI_ID and su.URI_STRING = ? and ACTION_ID = au.URI_ID and au.URI_STRING = ? and VERSION_NO" + (revisionNumber == null ? " IS NULL " : " = '" + revisionNumber.toString() + "'"));
            statement.setString(1, permission.getObjectUri());
            statement.setString(2, permission.getSubjectUri());
            statement.setString(3, permission.getActionUri());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw this.createException(e, uri.toString());
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
        this.close(statement);
    }

    public void revokePermissions(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete from PERMISSIONS where PERMISSIONS.OBJECT_ID in (select u.URI_ID from URI u where u.URI_STRING = ?)");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBinding(Connection connection, Uri uri) throws ServiceAccessException, ObjectNotFoundException, SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete from BINDING where BINDING.URI_ID in (select URI_ID from URI where URI.URI_STRING = ?)");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
        try {
            statement = connection.prepareStatement("delete from PARENT_BINDING where PARENT_BINDING.URI_ID in (select URI_ID from URI where URI.URI_STRING = ?)");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException, SQLException {
        this.assureVersionInfo(connection, uri, revisionDescriptor);
        InputStream is = revisionContent.streamContent();
        if (is != null) {
            Object v1;
            File tempFile = null;
            if (this.bcompress) {
                this.getLogger().log((Object)"Compressing the data", LOG_CHANNEL, 7);
                StoreContentZip ziputil = new StoreContentZip();
                ziputil.Zip(is);
                is = ziputil.getInputStream();
                if (revisionDescriptor.getContentLength() == -1L) {
                    revisionDescriptor.setContentLength(ziputil.getInitialContentLength());
                }
            } else if (revisionDescriptor.getContentLength() == -1L) {
                try {
                    tempFile = File.createTempFile("content", null);
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    try {
                        int nChar;
                        byte[] buffer = new byte[2048];
                        while ((nChar = is.read(buffer)) != -1) {
                            fos.write(buffer, 0, nChar);
                        }
                    }
                    finally {
                        fos.close();
                    }
                    is.close();
                    is = new FileInputStream(tempFile);
                    revisionDescriptor.setContentLength(tempFile.length());
                }
                catch (IOException ex) {
                    this.getLogger().log((Object)(ex.toString() + " during the calculation of the content length."), LOG_CHANNEL, 2);
                    throw ex;
                }
            }
            PreparedStatement statement = null;
            try {
                long versionID = this.getVersionID(connection, uri.toString(), revisionDescriptor);
                statement = connection.prepareStatement("insert into VERSION_CONTENT (VERSION_ID, CONTENT) values (?,?)");
                statement.setLong(1, versionID);
                statement.setBinaryStream(2, is, (int)revisionDescriptor.getContentLength());
                statement.executeUpdate();
                if (tempFile != null) {
                    is.close();
                    is = null;
                    tempFile.delete();
                }
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var12_14 = null;
                try {
                    this.close(statement);
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_18;
                    v0 = var14_18 = null;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        this.logger.log((Object)"Could not close stream", (Throwable)ioe, LOG_CHANNEL, 7);
                    }
                }
                throw throwable;
            }
            try {
                this.close(statement);
                v1 = null;
            }
            catch (Throwable throwable) {
                Object var14_17;
                v1 = var14_17 = null;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    this.logger.log((Object)"Could not close stream", (Throwable)ioe, LOG_CHANNEL, 7);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getVersionID(Connection connection, String uriString, NodeRevisionDescriptor revisionDescriptor) throws SQLException {
        PreparedStatement statement = null;
        ResultSet rs = null;
        long versionID = 0L;
        try {
            statement = connection.prepareStatement("select vh.VERSION_ID from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ? and vh.REVISION_NO = ?");
            statement.setString(1, uriString);
            statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
            rs = statement.executeQuery();
            if (rs.next()) {
                versionID = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            this.close(statement, rs);
            throw throwable;
        }
        this.close(statement, rs);
        return versionID;
    }

    protected String convertRevisionNumberToComparable(String revisioNumber) {
        return "to_number(substr(" + revisioNumber + ",1,instr(" + revisioNumber + ",'.')-1)), to_number(substr(" + revisioNumber + ",instr(" + revisioNumber + ",'.')+1))";
    }
}

