/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.impl.rdbms.CommonRDBMSAdapter;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.logger.Logger;

public class DB2RDBMSAdapter
extends CommonRDBMSAdapter {
    public DB2RDBMSAdapter(Service service, Logger logger) {
        super(service, logger);
        this.bcompress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean storeObject(Connection connection, Uri uri, ObjectNode object, boolean create) throws ServiceAccessException {
        String className = object.getClass().getName();
        try {
            long uriid;
            PreparedStatement statement;
            block27: {
                ResultSet res;
                block26: {
                    block25: {
                        boolean bl;
                        statement = null;
                        res = null;
                        try {
                            uriid = this.assureUriId(connection, uri.toString());
                            statement = connection.prepareStatement("select 1 from OBJECT o, URI u where o.URI_ID=u.URI_ID and u.URI_STRING=?");
                            statement.setString(1, uri.toString());
                            res = statement.executeQuery();
                            if (!res.next()) break block25;
                            if (!create) break block26;
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            this.close(statement, res);
                            throw throwable;
                        }
                        this.close(statement, res);
                        return bl;
                    }
                    if (create) break block26;
                    boolean bl = false;
                    this.close(statement, res);
                    return bl;
                }
                this.close(statement, res);
                if (!create) break block27;
                try {
                    statement = connection.prepareStatement("insert into OBJECT (URI_ID,CLASS_NAME) values (?,?)");
                    statement.setLong(1, uriid);
                    statement.setString(2, className);
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
            try {
                this.clearBinding(connection, uri);
            }
            catch (ObjectNotFoundException e1) {
                // empty catch block
            }
            Enumeration bindings = object.enumerateBindings();
            while (bindings.hasMoreElements()) {
                ObjectNode.Binding binding = (ObjectNode.Binding)bindings.nextElement();
                try {
                    long childID = this.getID(connection, binding.getUuri());
                    if (childID == 0L) {
                        childID = this.assureUriId(connection, binding.getUuri());
                    }
                    statement = connection.prepareStatement("insert into BINDING (URI_ID, NAME, CHILD_UURI_ID) values (?,?,?)");
                    statement.setLong(1, uriid);
                    statement.setString(2, binding.getName());
                    statement.setLong(3, childID);
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
            Enumeration parentBindings = object.enumerateParentBindings();
            while (parentBindings.hasMoreElements()) {
                ObjectNode.ParentBinding parentBinding = (ObjectNode.ParentBinding)parentBindings.nextElement();
                try {
                    long parentID = this.getID(connection, parentBinding.getUuri());
                    statement = connection.prepareStatement("insert into PARENT_BINDING (URI_ID, NAME, PARENT_UURI_ID) values (?,?,?)");
                    statement.setLong(1, uriid);
                    statement.setString(2, parentBinding.getName());
                    statement.setLong(3, parentID);
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
            if (!(object instanceof LinkNode)) return true;
            try {
                statement = connection.prepareStatement("delete from LINKS where URI_ID = ?");
                statement.setLong(1, uriid);
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                long linkedID = this.getID(connection, ((LinkNode)object).getLinkedUri());
                statement = connection.prepareStatement("insert into LINKS (URI_ID, LINK_TO_ID) values (?,?)");
                statement.setLong(1, uriid);
                statement.setLong(2, linkedID);
                statement.executeUpdate();
                return true;
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    public void putLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            int inheritable = lock.isInheritable() ? 1 : 0;
            int exclusive = lock.isExclusive() ? 1 : 0;
            long lockid = this.assureUriId(connection, lock.getLockId());
            long objectID = this.getID(connection, lock.getObjectUri());
            long subjectID = this.getID(connection, lock.getSubjectUri());
            long typeID = this.getID(connection, lock.getTypeUri());
            statement = connection.prepareStatement("insert into LOCKS (LOCK_ID,OBJECT_ID,SUBJECT_ID,TYPE_ID,EXPIRATION_DATE,IS_INHERITABLE,IS_EXCLUSIVE,OWNER) values (?,?,?,?,?,?,?,?)");
            statement.setLong(1, lockid);
            statement.setLong(2, objectID);
            statement.setLong(3, subjectID);
            statement.setLong(4, typeID);
            statement.setLong(5, lock.getExpirationDate().getTime());
            statement.setInt(6, inheritable);
            statement.setInt(7, exclusive);
            statement.setString(8, lock.getOwnerInfo());
            statement.execute();
        }
        catch (SQLException e) {
            try {
                throw this.createException(e, uri.toString());
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
        this.close(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPermission(Connection connection, Uri uri, NodePermission permission) throws ServiceAccessException {
        PreparedStatement statement = null;
        ResultSet res = null;
        int succession = 0;
        try {
            try {
                statement = connection.prepareStatement("select max(p.SUCCESSION) from URI ou, PERMISSIONS p where p.OBJECT_ID = ou.URI_ID and ou.URI_STRING = ?");
                statement.setString(1, permission.getObjectUri());
                res = statement.executeQuery();
                res.next();
                succession = res.getInt(1) + 1;
            }
            catch (Throwable throwable) {
                this.close(statement, res);
                throw throwable;
            }
            this.close(statement, res);
            this.assureUriId(connection, permission.getSubjectUri());
            this.assureUriId(connection, permission.getActionUri());
            try {
                int inheritable = permission.isInheritable() ? 1 : 0;
                int negative = permission.isNegative() ? 1 : 0;
                long objectID = this.getID(connection, permission.getObjectUri());
                long subjectID = this.getID(connection, permission.getSubjectUri());
                long actionID = this.getID(connection, permission.getActionUri());
                statement = connection.prepareStatement("insert into PERMISSIONS (OBJECT_ID,SUBJECT_ID,ACTION_ID,VERSION_NO, IS_INHERITABLE,IS_NEGATIVE,SUCCESSION) values (?,?,?,?,?,?,?)");
                statement.setLong(1, objectID);
                statement.setLong(2, subjectID);
                statement.setLong(3, actionID);
                statement.setString(4, this.getRevisionNumberAsString(permission.getRevisionNumber()));
                statement.setInt(5, inheritable);
                statement.setInt(6, negative);
                statement.setInt(7, succession);
                if (statement.executeUpdate() != 1) {
                    String msg = "Failed to insert permission (" + permission.getObjectUri() + "," + permission.getSubjectUri() + "," + permission.getActionUri() + ")";
                    this.getLogger().log((Object)msg, LOG_CHANNEL, 2);
                }
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createRevisionDescriptor(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            this.assureVersionInfo(connection, uri, revisionDescriptor);
            Enumeration labels = revisionDescriptor.enumerateLabels();
            while (labels.hasMoreElements()) {
                long labelId = this.assureLabelId(connection, (String)labels.nextElement());
                try {
                    long versionID = this.getVersionID(connection, uri.toString(), revisionDescriptor);
                    statement = connection.prepareStatement("insert into VERSION_LABELS (VERSION_ID, LABEL_ID) values (?,?)");
                    statement.setLong(1, versionID);
                    statement.setLong(2, labelId);
                    statement.executeUpdate();
                }
                catch (Throwable throwable) {
                    this.close(statement);
                    throw throwable;
                }
                this.close(statement);
            }
            Enumeration properties = revisionDescriptor.enumerateProperties();
            while (properties.hasMoreElements()) {
                try {
                    NodeProperty property = (NodeProperty)properties.nextElement();
                    long versionID = this.getVersionID(connection, uri.toString(), revisionDescriptor);
                    statement = connection.prepareStatement("insert into PROPERTIES (VERSION_ID,PROPERTY_NAMESPACE,PROPERTY_NAME,PROPERTY_VALUE,PROPERTY_TYPE,IS_PROTECTED) values (?,?,?,?,?,?)");
                    int protectedProperty = property.isProtected() ? 1 : 0;
                    statement.setLong(1, versionID);
                    statement.setString(2, property.getNamespace());
                    statement.setString(3, property.getName());
                    statement.setString(4, property.getValue().toString());
                    statement.setString(5, property.getType());
                    statement.setInt(6, protectedProperty);
                    statement.executeUpdate();
                }
                catch (Throwable throwable) {
                    this.close(statement);
                    throw throwable;
                    return;
                }
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionDescriptors(Connection connection, Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            boolean revisionExists;
            int isVersioned = 0;
            if (revisionDescriptors.isVersioned()) {
                isVersioned = 1;
            }
            try {
                statement = connection.prepareStatement("SELECT u.URI_ID FROM VERSION v, URI u WHERE v.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                revisionExists = res.next();
            }
            catch (Throwable throwable) {
                this.close(statement, res);
                throw throwable;
            }
            this.close(statement, res);
            if (!revisionExists) {
                try {
                    long id = this.getID(connection, uri.toString());
                    statement = connection.prepareStatement("insert into VERSION (URI_ID, IS_VERSIONED) values (?,?)");
                    statement.setLong(1, id);
                    statement.setInt(2, isVersioned);
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement, res);
                }
            }
            boolean versionHistoryExists = false;
            if (revisionDescriptors.getLatestRevision() != null) {
                try {
                    statement = connection.prepareStatement("SELECT 1 FROM VERSION_HISTORY vh, URI u WHERE vh.URI_ID = u.URI_ID and u.URI_STRING = ? and REVISION_NO = ?");
                    statement.setString(1, uri.toString());
                    statement.setString(2, revisionDescriptors.getLatestRevision().toString());
                    res = statement.executeQuery();
                    versionHistoryExists = res.next();
                }
                finally {
                    this.close(statement, res);
                }
            }
            if (!versionHistoryExists && revisionDescriptors.getLatestRevision() != null) {
                try {
                    long[] ids = this.getBranchIdAndUriID(connection, uri.toString());
                    long uriID = ids[0];
                    long branchID = ids[1];
                    statement = connection.prepareStatement("insert into VERSION_HISTORY (URI_ID, BRANCH_ID, REVISION_NO) values(?,?,?)");
                    statement.setLong(1, uriID);
                    statement.setLong(2, branchID);
                    statement.setString(3, this.getRevisionNumberAsString(revisionDescriptors.getLatestRevision()));
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement, res);
                }
            }
            Enumeration revisionNumbers = revisionDescriptors.enumerateRevisionNumbers();
            while (revisionNumbers.hasMoreElements()) {
                NodeRevisionNumber nodeRevisionNumber = (NodeRevisionNumber)revisionNumbers.nextElement();
                Enumeration successors = revisionDescriptors.getSuccessors(nodeRevisionNumber);
                while (successors.hasMoreElements()) {
                    try {
                        NodeRevisionNumber successor = (NodeRevisionNumber)successors.nextElement();
                        statement = connection.prepareStatement("insert into VERSION_PREDS (VERSION_ID, PREDECESSOR_ID)  select vr.VERSION_ID, suc.VERSION_ID FROM URI uri, VERSION_HISTORY  vr, VERSION_HISTORY suc  where vr.URI_ID = uri.URI_ID  and suc.URI_ID = uri.URI_ID  and uri.URI_STRING = ?  and vr.REVISION_NO = ?  and suc.REVISION_NO = ? ");
                        statement.setString(1, uri.toString());
                        statement.setString(2, nodeRevisionNumber.toString());
                        statement.setString(3, successor.toString());
                        statement.executeUpdate();
                    }
                    finally {
                        this.close(statement);
                    }
                }
            }
            this.getLogger().log((Object)(revisionDescriptors.getOriginalUri() + revisionDescriptors.getInitialRevision()), LOG_CHANNEL, 6);
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assureVersionInfo(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws SQLException {
        boolean versionHistoryExists;
        boolean revisionExists;
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            statement = connection.prepareStatement("select 1 from VERSION v, URI u where v.URI_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            res = statement.executeQuery();
            revisionExists = res.next();
        }
        catch (Throwable throwable) {
            this.close(statement, res);
            throw throwable;
        }
        this.close(statement, res);
        if (!revisionExists) {
            try {
                long id = this.getID(connection, uri.toString());
                statement = connection.prepareStatement("insert into VERSION (URI_ID, IS_VERSIONED) values (?,?)");
                statement.setLong(1, id);
                statement.setInt(2, 0);
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        try {
            statement = connection.prepareStatement("select 1 from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ? and REVISION_NO = ?");
            statement.setString(1, uri.toString());
            statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
            res = statement.executeQuery();
            versionHistoryExists = res.next();
        }
        finally {
            this.close(statement, res);
        }
        if (!versionHistoryExists) {
            long branchId = this.assureBranchId(connection, revisionDescriptor.getBranchName());
            try {
                long id = this.getID(connection, uri.toString());
                statement = connection.prepareStatement("insert into VERSION_HISTORY (URI_ID, BRANCH_ID, REVISION_NO) values (?,?,?)");
                statement.setLong(1, id);
                statement.setLong(2, branchId);
                statement.setString(3, this.getRevisionNumberAsString(revisionDescriptor.getRevisionNumber()));
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getID(Connection connection, String uriString) throws SQLException {
        PreparedStatement statement = null;
        ResultSet rs = null;
        long uriID = 0L;
        try {
            statement = connection.prepareStatement("select URI_ID from URI where URI_STRING = ?");
            statement.setString(1, uriString);
            rs = statement.executeQuery();
            if (rs.next()) {
                uriID = rs.getLong(1);
            }
        }
        catch (Throwable throwable) {
            this.close(statement, rs);
            throw throwable;
        }
        this.close(statement, rs);
        return uriID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getBranchIdAndUriID(Connection connection, String uriString) throws SQLException {
        PreparedStatement statement = null;
        ResultSet res = null;
        long[] ids = new long[2];
        try {
            statement = connection.prepareStatement("select u.URI_ID, b.BRANCH_ID from URI u, BRANCH b where u.URI_STRING = ? and b.BRANCH_STRING = ?");
            statement.setString(1, uriString);
            statement.setString(2, "main");
            res = statement.executeQuery();
            if (res.next()) {
                ids[0] = res.getLong(1);
                ids[1] = res.getLong(2);
            }
        }
        catch (Throwable throwable) {
            this.close(statement, res);
            throw throwable;
        }
        this.close(statement, res);
        return ids;
    }

    protected String convertRevisionNumberToComparable(String revisioNumber) {
        return revisioNumber;
    }
}

