/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.impl.rdbms.AbstractRDBMSAdapter;
import org.apache.slide.store.impl.rdbms.JDBCAwareInputStream;
import org.apache.slide.store.impl.rdbms.StoreContentZip;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.logger.Logger;

public class StandardRDBMSAdapter
extends AbstractRDBMSAdapter {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$impl$rdbms$StandardRDBMSAdapter == null ? (class$org$apache$slide$store$impl$rdbms$StandardRDBMSAdapter = StandardRDBMSAdapter.class$("org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter")) : class$org$apache$slide$store$impl$rdbms$StandardRDBMSAdapter).getName();
    protected boolean bcompress = false;
    static /* synthetic */ Class class$org$apache$slide$store$impl$rdbms$StandardRDBMSAdapter;
    static /* synthetic */ Class class$org$apache$slide$structure$LinkNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Vector;

    public StandardRDBMSAdapter(Service service, Logger logger) {
        super(service, logger);
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        try {
            this.bcompress = "true".equalsIgnoreCase((String)parameters.get("compress"));
            if (this.bcompress) {
                this.getLogger().log((Object)"Switching on content compression", LOG_CHANNEL, 6);
            }
            super.setParameters(parameters);
        }
        catch (Exception e) {
            this.getLogger().log((Object)e.toString(), LOG_CHANNEL, 2);
        }
    }

    public void createObject(Connection connection, Uri uri, ObjectNode object) throws ObjectAlreadyExistsException, ServiceAccessException {
        if (!this.storeObject(connection, uri, object, true)) {
            throw new ObjectAlreadyExistsException(uri.toString());
        }
    }

    public void storeObject(Connection connection, Uri uri, ObjectNode object) throws ObjectNotFoundException, ServiceAccessException {
        if (!this.storeObject(connection, uri, object, false)) {
            throw new ObjectNotFoundException(uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean storeObject(Connection connection, Uri uri, ObjectNode object, boolean create) throws ServiceAccessException {
        String className = object.getClass().getName();
        try {
            long uriid;
            ResultSet res;
            PreparedStatement statement;
            block27: {
                statement = null;
                res = null;
                try {
                    uriid = this.assureUriId(connection, uri.toString());
                    statement = connection.prepareStatement("select 1 from OBJECT o, URI u where o.URI_ID=u.URI_ID and u.URI_STRING=?");
                    statement.setString(1, uri.toString());
                    res = statement.executeQuery();
                    if (res.next()) {
                        if (create) {
                            boolean bl = false;
                            this.close(statement, res);
                            return bl;
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    this.close(statement, res);
                    throw throwable;
                }
                {
                    if (create) break block27;
                    boolean bl = false;
                    this.close(statement, res);
                    return bl;
                }
            }
            this.close(statement, res);
            if (create) {
                try {
                    statement = connection.prepareStatement("insert into OBJECT (URI_ID,CLASS_NAME) values (?,?)");
                    statement.setLong(1, uriid);
                    statement.setString(2, className);
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
            try {
                this.clearBinding(connection, uri);
            }
            catch (ObjectNotFoundException e1) {
                // empty catch block
            }
            Enumeration bindings = object.enumerateBindings();
            while (bindings.hasMoreElements()) {
                ObjectNode.Binding binding = (ObjectNode.Binding)bindings.nextElement();
                try {
                    statement = connection.prepareStatement("insert into BINDING (URI_ID, NAME, CHILD_UURI_ID) select ?, ?, URI_ID from URI where URI_STRING = ?");
                    statement.setLong(1, uriid);
                    statement.setString(2, binding.getName());
                    statement.setString(3, binding.getUuri());
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
            Enumeration parentBindings = object.enumerateParentBindings();
            while (parentBindings.hasMoreElements()) {
                ObjectNode.ParentBinding parentBinding = (ObjectNode.ParentBinding)parentBindings.nextElement();
                try {
                    statement = connection.prepareStatement("insert into PARENT_BINDING (URI_ID, NAME, PARENT_UURI_ID) select ?, ?, URI_ID from URI where URI_STRING = ?");
                    statement.setLong(1, uriid);
                    statement.setString(2, parentBinding.getName());
                    statement.setString(3, parentBinding.getUuri());
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
            if (!(object instanceof LinkNode)) return true;
            try {
                statement = connection.prepareStatement("delete from LINKS where URI_ID = ?");
                statement.setLong(1, uriid);
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("insert into LINKS (URI_ID, LINK_TO_ID) select ?, u.URI_ID from URI u where u.URI_STRING = ?");
                statement.setLong(1, uriid);
                statement.setString(2, ((LinkNode)object).getLinkedUri());
                statement.executeUpdate();
                return true;
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Connection connection, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        PreparedStatement statement = null;
        try {
            this.clearBinding(connection, uri);
            try {
                statement = connection.prepareStatement("delete LINKS from LINKS l, URI u where l.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete VERSION_HISTORY from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete VERSION from VERSION v, URI u where v.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete OBJECT from OBJECT o, URI u where o.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete from URI where URI_STRING = ?");
                statement.setString(1, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode retrieveObject(Connection connection, Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        LinkNode result;
        block28: {
            result = null;
            try {
                String className;
                PreparedStatement statement = null;
                ResultSet res = null;
                Vector<ObjectNode.Binding> children = new Vector<ObjectNode.Binding>();
                Vector<ObjectNode.ParentBinding> parents = new Vector<ObjectNode.ParentBinding>();
                Vector<String> links = new Vector<String>();
                try {
                    statement = connection.prepareStatement("select o.CLASS_NAME from OBJECT o, URI u where o.URI_ID = u.URI_ID and u.URI_STRING = ?");
                    statement.setString(1, uri.toString());
                    res = statement.executeQuery();
                    if (!res.next()) {
                        throw new ObjectNotFoundException(uri);
                    }
                    className = res.getString(1);
                    this.close(statement, res);
                }
                catch (Throwable throwable) {
                    this.close(statement, res);
                    throw throwable;
                }
                try {
                    statement = connection.prepareStatement("SELECT c.NAME, cu.URI_STRING FROM URI u, URI cu, BINDING c WHERE cu.URI_ID = c.CHILD_UURI_ID AND c.URI_ID = u.URI_ID and u.URI_STRING = ?");
                    statement.setString(1, uri.toString());
                    res = statement.executeQuery();
                    while (res.next()) {
                        children.addElement(new ObjectNode.Binding(res.getString(1), res.getString(2)));
                    }
                }
                finally {
                    this.close(statement, res);
                }
                try {
                    statement = connection.prepareStatement("SELECT c.NAME, cu.URI_STRING FROM URI u, URI cu, PARENT_BINDING c WHERE cu.URI_ID = c.PARENT_UURI_ID AND c.URI_ID = u.URI_ID and u.URI_STRING = ?");
                    statement.setString(1, uri.toString());
                    res = statement.executeQuery();
                    while (res.next()) {
                        parents.addElement(new ObjectNode.ParentBinding(res.getString(1), res.getString(2)));
                    }
                }
                finally {
                    this.close(statement, res);
                }
                try {
                    statement = connection.prepareStatement("SELECT lu.URI_STRING FROM URI u, URI lu, LINKS l WHERE lu.URI_ID = l.URI_ID AND l.LINK_TO_ID = u.URI_ID and u.URI_STRING = ?");
                    statement.setString(1, uri.toString());
                    res = statement.executeQuery();
                    while (res.next()) {
                        links.addElement(res.getString(1));
                    }
                }
                finally {
                    this.close(statement, res);
                }
                if (className.equals((class$org$apache$slide$structure$LinkNode == null ? (class$org$apache$slide$structure$LinkNode = StandardRDBMSAdapter.class$("org.apache.slide.structure.LinkNode")) : class$org$apache$slide$structure$LinkNode).getName())) {
                    try {
                        statement = connection.prepareStatement("SELECT lu.URI_STRING FROM URI u, URI lu, LINKS l WHERE lu.URI_ID = l.LINK_TO_ID AND l.URI_ID = u.URI_ID and u.URI_STRING = ?");
                        statement.setString(1, uri.toString());
                        res = statement.executeQuery();
                        if (res.next()) {
                            String linkTarget = res.getString(1);
                            result = new LinkNode(uri.toString(), children, links, linkTarget);
                        } else {
                            result = new LinkNode(uri.toString(), children, links);
                        }
                        break block28;
                    }
                    finally {
                        this.close(statement, res);
                    }
                }
                try {
                    Class<?> objclass = Class.forName(className);
                    Class[] argClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = StandardRDBMSAdapter.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = StandardRDBMSAdapter.class$("java.util.Vector")) : class$java$util$Vector, class$java$util$Vector == null ? (class$java$util$Vector = StandardRDBMSAdapter.class$("java.util.Vector")) : class$java$util$Vector, class$java$util$Vector == null ? (class$java$util$Vector = StandardRDBMSAdapter.class$("java.util.Vector")) : class$java$util$Vector};
                    Object[] arguments = new Object[]{uri.toString(), children, parents, links};
                    Constructor<?> constructor = objclass.getConstructor(argClasses);
                    result = (ObjectNode)constructor.newInstance(arguments);
                    result.setUri(result.getUuri());
                }
                catch (Exception e) {
                    throw new ServiceAccessException(this.service, (Throwable)e);
                }
            }
            catch (SQLException e) {
                throw this.createException(e, uri.toString());
            }
        }
        return result;
    }

    public Enumeration enumerateLocks(Connection connection, Uri uri) throws ServiceAccessException {
        Vector<NodeLock> lockVector = new Vector<NodeLock>();
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            statement = connection.prepareStatement("select l.EXPIRATION_DATE, l.IS_INHERITABLE, l.IS_EXCLUSIVE, u2.URI_STRING as LCK, u3.URI_STRING as SUBJECT, u4.URI_STRING as TYPE, l.OWNER from LOCKS l, URI u, URI u2, URI u3, URI u4 where l.OBJECT_ID=u.URI_ID and u.URI_STRING=? and l.LOCK_ID=u2.URI_ID and l.SUBJECT_ID=u3.URI_ID and l.TYPE_ID = u4.URI_ID");
            statement.setString(1, uri.toString());
            res = statement.executeQuery();
            while (res.next()) {
                Date expirationDate = null;
                try {
                    Long timeValue = new Long(res.getLong("EXPIRATION_DATE"));
                    expirationDate = new Date(timeValue);
                }
                catch (NumberFormatException e) {
                    this.getLogger().log((Object)e, LOG_CHANNEL, 4);
                    expirationDate = new Date();
                }
                NodeLock lock = new NodeLock(res.getString("LCK"), uri.toString(), res.getString("SUBJECT"), res.getString("TYPE"), expirationDate, res.getInt("IS_INHERITABLE") == 1, res.getInt("IS_EXCLUSIVE") == 1, res.getString("OWNER"));
                lockVector.addElement(lock);
            }
            this.close(statement, res);
        }
        catch (SQLException e) {
            try {
                throw this.createException(e, uri.toString());
            }
            catch (Throwable throwable) {
                this.close(statement, res);
                throw throwable;
            }
        }
        return lockVector.elements();
    }

    public void killLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(connection, uri, lock);
    }

    public void putLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            int inheritable = lock.isInheritable() ? 1 : 0;
            int exclusive = lock.isExclusive() ? 1 : 0;
            long lockid = this.assureUriId(connection, lock.getLockId());
            statement = connection.prepareStatement("insert into LOCKS (LOCK_ID,OBJECT_ID,SUBJECT_ID,TYPE_ID,EXPIRATION_DATE,IS_INHERITABLE,IS_EXCLUSIVE,OWNER) select ?, object.URI_ID, subject.URI_ID, type.URI_ID, ?, ?, ?, ? from URI object, URI subject, URI type WHERE object.URI_STRING=? and subject.URI_STRING=? and type.URI_STRING=?");
            statement.setLong(1, lockid);
            statement.setLong(2, lock.getExpirationDate().getTime());
            statement.setInt(3, inheritable);
            statement.setInt(4, exclusive);
            statement.setString(5, lock.getOwnerInfo());
            statement.setString(6, lock.getObjectUri());
            statement.setString(7, lock.getSubjectUri());
            statement.setString(8, lock.getTypeUri());
            statement.execute();
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                throw this.createException(e, uri.toString());
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        try {
            PreparedStatement statement = null;
            ResultSet rslt = null;
            try {
                statement = connection.prepareStatement("select 1 from LOCKS l, URI u where l.LOCK_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, lock.getLockId());
                rslt = statement.executeQuery();
                if (!rslt.next()) {
                    throw new LockTokenNotFoundException(lock);
                }
                this.removeLock(connection, uri, lock);
                this.putLock(connection, uri, lock);
                this.close(statement, rslt);
            }
            catch (Throwable throwable) {
                this.close(statement, rslt);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete LOCKS from LOCKS, URI u where LOCK_ID = u.URI_ID and u.URI_STRING=?");
                statement.setString(1, lock.getLockId());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete URI from URI, LOCKS l where URI_STRING=?");
                statement.setString(1, lock.getLockId());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    public Enumeration enumeratePermissions(Connection connection, Uri uri) throws ServiceAccessException {
        Vector<NodePermission> permissions = new Vector<NodePermission>();
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            statement = connection.prepareStatement("select ou.URI_STRING, su.URI_STRING, au.URI_STRING, p.VERSION_NO, p.IS_INHERITABLE, p.IS_NEGATIVE from PERMISSIONS p, URI ou, URI su, URI au where p.OBJECT_ID = ou.URI_ID and ou.URI_STRING = ? and p.SUBJECT_ID = su.URI_ID and p.ACTION_ID = au.URI_ID order by SUCCESSION");
            statement.setString(1, uri.toString());
            res = statement.executeQuery();
            while (res.next()) {
                String object = res.getString(1);
                String subject = res.getString(2);
                String action = res.getString(3);
                String revision = res.getString(4);
                if ("NULL".equals(revision)) {
                    revision = null;
                }
                boolean inheritable = res.getInt(5) == 1;
                boolean negative = res.getInt(6) == 1;
                NodePermission permission = new NodePermission(object, revision, subject, action, inheritable, negative);
                permissions.add(permission);
            }
            this.close(statement, res);
        }
        catch (SQLException e) {
            try {
                throw this.createException(e, uri.toString());
            }
            catch (Throwable throwable) {
                this.close(statement, res);
                throw throwable;
            }
        }
        return permissions.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPermission(Connection connection, Uri uri, NodePermission permission) throws ServiceAccessException {
        PreparedStatement statement = null;
        ResultSet res = null;
        int succession = 0;
        try {
            try {
                statement = connection.prepareStatement("select max(p.SUCCESSION) from URI ou, PERMISSIONS p where p.OBJECT_ID = ou.URI_ID and ou.URI_STRING = ?");
                statement.setString(1, permission.getObjectUri());
                res = statement.executeQuery();
                res.next();
                succession = res.getInt(1) + 1;
                this.close(statement, res);
            }
            catch (Throwable throwable) {
                this.close(statement, res);
                throw throwable;
            }
            this.assureUriId(connection, permission.getSubjectUri());
            this.assureUriId(connection, permission.getActionUri());
            try {
                int inheritable = permission.isInheritable() ? 1 : 0;
                int negative = permission.isNegative() ? 1 : 0;
                statement = connection.prepareStatement("insert into PERMISSIONS (OBJECT_ID,SUBJECT_ID,ACTION_ID,VERSION_NO, IS_INHERITABLE,IS_NEGATIVE,SUCCESSION) select ou.URI_ID, su.URI_ID, au.URI_ID, ?, ?, ?, ? from URI ou, URI su, URI au where ou.URI_STRING = ? and su.URI_STRING = ? and au.URI_STRING = ?");
                statement.setString(1, this.getRevisionNumberAsString(permission.getRevisionNumber()));
                statement.setInt(2, inheritable);
                statement.setInt(3, negative);
                statement.setInt(4, succession);
                statement.setString(5, permission.getObjectUri());
                statement.setString(6, permission.getSubjectUri());
                statement.setString(7, permission.getActionUri());
                if (statement.executeUpdate() != 1) {
                    String msg = "Failed to insert permission (" + permission.getObjectUri() + "," + permission.getSubjectUri() + "," + permission.getActionUri() + ")";
                    this.getLogger().log((Object)msg, LOG_CHANNEL, 2);
                }
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    public void revokePermission(Connection connection, Uri uri, NodePermission permission) throws ServiceAccessException {
        if (permission == null) {
            return;
        }
        PreparedStatement statement = null;
        try {
            NodeRevisionNumber revisionNumber = permission.getRevisionNumber();
            statement = connection.prepareStatement("delete PERMISSIONS from PERMISSIONS, URI ou, URI su, URI au where OBJECT_ID = ou.URI_ID and ou.URI_STRING = ? and SUBJECT_ID = su.URI_ID and su.URI_STRING = ? and ACTION_ID = au.URI_ID and au.URI_STRING = ? and VERSION_NO" + (revisionNumber == null ? " IS NULL " : " = '" + revisionNumber.toString() + "'"));
            statement.setString(1, permission.getObjectUri());
            statement.setString(2, permission.getSubjectUri());
            statement.setString(3, permission.getActionUri());
            statement.executeUpdate();
            this.close(statement);
        }
        catch (SQLException e) {
            try {
                throw this.createException(e, uri.toString());
            }
            catch (Throwable throwable) {
                this.close(statement);
                throw throwable;
            }
        }
    }

    public void revokePermissions(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete PERMISSIONS from PERMISSIONS, URI u where OBJECT_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionDescriptor(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            this.assureVersionInfo(connection, uri, revisionDescriptor);
            Enumeration labels = revisionDescriptor.enumerateLabels();
            while (labels.hasMoreElements()) {
                long labelId = this.assureLabelId(connection, (String)labels.nextElement());
                try {
                    statement = connection.prepareStatement("insert into VERSION_LABELS (VERSION_ID, LABEL_ID) select VERSION_ID, ? from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ? and vh.REVISION_NO = ?");
                    statement.setLong(1, labelId);
                    statement.setString(2, uri.toString());
                    statement.setString(3, revisionDescriptor.getRevisionNumber().toString());
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
            Enumeration properties = revisionDescriptor.enumerateProperties();
            while (properties.hasMoreElements()) {
                try {
                    NodeProperty property = (NodeProperty)properties.nextElement();
                    statement = connection.prepareStatement("insert into PROPERTIES (VERSION_ID,PROPERTY_NAMESPACE,PROPERTY_NAME,PROPERTY_VALUE,PROPERTY_TYPE,IS_PROTECTED) select vh.VERSION_ID, ?, ?, ?, ?, ? from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ? and vh.REVISION_NO = ?");
                    int protectedProperty = property.isProtected() ? 1 : 0;
                    statement.setString(1, property.getNamespace());
                    statement.setString(2, property.getName());
                    statement.setString(3, property.getValue().toString());
                    statement.setString(4, property.getType());
                    statement.setInt(5, protectedProperty);
                    statement.setString(6, uri.toString());
                    statement.setString(7, revisionDescriptor.getRevisionNumber().toString());
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement);
                }
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        try {
            PreparedStatement statement = null;
            try {
                statement = connection.prepareStatement("delete VERSION_CONTENT from VERSION_CONTENT vc, VERSION_HISTORY vh, URI u where vc.VERSION_ID = vh.VERSION_ID and vh.REVISION_NO = ? and vh.URI_ID=u.URI_ID AND u.URI_STRING=?");
                statement.setString(1, revisionDescriptor.getRevisionNumber().toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionDescriptor(Connection connection, Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete VERSION_LABELS from VERSION_LABELS vl, VERSION_HISTORY vh, URI u where vl.VERSION_ID = vh.VERSION_ID and vh.REVISION_NO = ? and vh.URI_ID = u.URI_ID AND u.URI_STRING = ?");
                statement.setString(1, revisionNumber.toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
            try {
                statement = connection.prepareStatement("delete PROPERTIES from PROPERTIES p, VERSION_HISTORY vh, URI u where p.VERSION_ID = vh.VERSION_ID and vh.REVISION_NO = ? and vh.URI_ID = u.URI_ID AND u.URI_STRING = ?");
                statement.setString(1, revisionNumber.toString());
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    public void removeRevisionDescriptors(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete VERSION_PREDS from VERSION_PREDS vp, VERSION_HISTORY vh, URI u where vp.VERSION_ID = vh.VERSION_ID and vh.URI_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
        finally {
            this.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionContent retrieveRevisionContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor, boolean temporaryConnection) throws ServiceAccessException, RevisionNotFoundException {
        NodeRevisionContent result;
        block22: {
            result = null;
            try {
                Object v1;
                PreparedStatement statement = null;
                ResultSet res = null;
                try {
                    statement = connection.prepareStatement("select vc.CONTENT from VERSION_CONTENT vc, VERSION_HISTORY vh, URI u where vc.VERSION_ID = vh.VERSION_ID and vh.URI_ID = u.URI_ID and u.URI_STRING = ? and vh.REVISION_NO = ?");
                    statement.setString(1, uri.toString());
                    statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
                    res = statement.executeQuery();
                    if (!res.next()) {
                        throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                    }
                    InputStream is = res.getBinaryStream("CONTENT");
                    if (is == null) {
                        throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
                    }
                    result = new NodeRevisionContent();
                    if (this.bcompress) {
                        this.getLogger().log((Object)"DeCompressing the data", LOG_CHANNEL, 7);
                        StoreContentZip ziputil = new StoreContentZip();
                        ziputil.UnZip(is);
                        revisionDescriptor.setContentLength(ziputil.getContentLength());
                        is = ziputil.getInputStream();
                        result.setContent(is);
                    } else if (temporaryConnection) {
                        result.setContent((InputStream)new JDBCAwareInputStream(is, statement, res, connection));
                    } else {
                        result.setContent((InputStream)new JDBCAwareInputStream(is, statement, res, null));
                    }
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var11_14 = null;
                    try {
                        this.close(statement, res);
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var13_18;
                        v0 = var13_18 = null;
                    }
                    if (this.bcompress && temporaryConnection) {
                        try {
                            connection.commit();
                        }
                        finally {
                            connection.close();
                        }
                    }
                    throw throwable;
                }
                try {
                    this.close(statement, res);
                    v1 = null;
                }
                catch (Throwable throwable) {
                    Object var13_17;
                    v1 = var13_17 = null;
                }
                if (!this.bcompress || !temporaryConnection) break block22;
                try {
                    connection.commit();
                }
                finally {
                    connection.close();
                }
            }
            catch (SQLException e) {
                throw this.createException(e, uri.toString());
            }
            catch (RevisionNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                this.getLogger().log((Object)e, LOG_CHANNEL, 2);
                throw new ServiceAccessException(this.service, (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionDescriptor retrieveRevisionDescriptor(Connection connection, Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptor revisionDescriptor = null;
        if (revisionNumber == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        try {
            PreparedStatement statement = null;
            ResultSet res = null;
            String branch = null;
            Vector<String> labels = new Vector<String>();
            Hashtable<String, NodeProperty> properties = new Hashtable<String, NodeProperty>();
            long versionId = 0L;
            try {
                statement = connection.prepareStatement("select vh.VERSION_ID, b.BRANCH_STRING from VERSION_HISTORY vh, BRANCH b, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ? and b.BRANCH_ID = vh.BRANCH_ID and vh.REVISION_NO = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionNumber.toString());
                res = statement.executeQuery();
                if (!res.next()) {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                versionId = res.getLong(1);
                branch = res.getString(2);
                this.close(statement, res);
            }
            catch (Throwable throwable) {
                this.close(statement, res);
                throw throwable;
            }
            try {
                statement = connection.prepareStatement("select l.LABEL_STRING from VERSION_LABELS vl, LABEL l where vl.VERSION_ID = ? and l.LABEL_ID = vl.LABEL_ID");
                statement.setLong(1, versionId);
                res = statement.executeQuery();
                while (res.next()) {
                    labels.addElement(res.getString(1));
                }
            }
            finally {
                this.close(statement, res);
            }
            try {
                statement = connection.prepareStatement("select PROPERTY_NAME, PROPERTY_NAMESPACE, PROPERTY_VALUE, PROPERTY_TYPE, IS_PROTECTED from PROPERTIES where VERSION_ID = ?");
                statement.setLong(1, versionId);
                res = statement.executeQuery();
                while (res.next()) {
                    String propertyName = res.getString(1);
                    String propertyNamespace = res.getString(2);
                    NodeProperty property = new NodeProperty(propertyName, (Object)res.getString(3), propertyNamespace, res.getString(4), res.getInt(5) == 1);
                    properties.put(propertyNamespace + propertyName, property);
                }
            }
            finally {
                this.close(statement, res);
            }
            revisionDescriptor = new NodeRevisionDescriptor(revisionNumber, branch, labels, properties);
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
        return revisionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionDescriptors retrieveRevisionDescriptors(Connection connection, Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptors revisionDescriptors = null;
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            NodeRevisionNumber initialRevision = new NodeRevisionNumber();
            Hashtable workingRevisions = new Hashtable();
            Hashtable<String, NodeRevisionNumber> latestRevisionNumbers = new Hashtable<String, NodeRevisionNumber>();
            Hashtable branches = new Hashtable();
            Vector<NodeRevisionNumber> allRevisions = new Vector<NodeRevisionNumber>();
            boolean isVersioned = false;
            try {
                statement = connection.prepareStatement("select IS_VERSIONED from VERSION v, URI u where v.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                if (!res.next()) {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                isVersioned = res.getInt("IS_VERSIONED") == 1;
                this.close(statement, res);
            }
            catch (Throwable throwable) {
                this.close(statement, res);
                throw throwable;
            }
            try {
                statement = connection.prepareStatement("select vh.REVISION_NO, b.BRANCH_STRING from VERSION_HISTORY vh, BRANCH b, URI u where vh.BRANCH_ID = b.BRANCH_ID and vh.URI_ID = u.URI_ID and u.URI_STRING = ? order by " + this.convertRevisionNumberToComparable("vh.REVISION_NO"));
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    NodeRevisionNumber revisionNumber = new NodeRevisionNumber(res.getString(1));
                    allRevisions.add(revisionNumber);
                    latestRevisionNumbers.put(res.getString(2), revisionNumber);
                }
            }
            finally {
                this.close(statement, res);
            }
            Enumeration e = allRevisions.elements();
            while (e.hasMoreElements()) {
                NodeRevisionNumber revisionNumber = (NodeRevisionNumber)e.nextElement();
                try {
                    statement = connection.prepareStatement("select distinct pvh.REVISION_NO from VERSION_HISTORY vh, VERSION_HISTORY pvh, VERSION_PREDS vp, URI u where pvh.VERSION_ID = vp.VERSION_ID and vp.VERSION_ID = vh.VERSION_ID and vh.URI_ID = u.URI_ID and u.URI_STRING = ? and vh.REVISION_NO = ?");
                    statement.setString(1, uri.toString());
                    statement.setString(2, revisionNumber.toString());
                    res = statement.executeQuery();
                    Vector<NodeRevisionNumber> predecessors = new Vector<NodeRevisionNumber>();
                    while (res.next()) {
                        predecessors.add(new NodeRevisionNumber(res.getString(1)));
                    }
                    branches.put(new NodeRevisionNumber(revisionNumber.toString()), predecessors);
                }
                finally {
                    this.close(statement, res);
                }
            }
            revisionDescriptors = new NodeRevisionDescriptors(uri.toString(), initialRevision, workingRevisions, latestRevisionNumbers, branches, isVersioned);
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
        return revisionDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionDescriptors(Connection connection, Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            boolean versionHistoryExists;
            boolean revisionExists;
            int isVersioned = 0;
            if (revisionDescriptors.isVersioned()) {
                isVersioned = 1;
            }
            try {
                statement = connection.prepareStatement("SELECT 1 FROM VERSION v, URI u WHERE v.URI_ID = u.URI_ID and u.URI_STRING = ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                revisionExists = res.next();
                this.close(statement, res);
            }
            catch (Throwable throwable) {
                this.close(statement, res);
                throw throwable;
            }
            if (!revisionExists) {
                try {
                    statement = connection.prepareStatement("insert into VERSION (URI_ID, IS_VERSIONED) select u.URI_ID, ? from URI u where u.URI_STRING = ?");
                    statement.setInt(1, isVersioned);
                    statement.setString(2, uri.toString());
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement, res);
                }
            }
            NodeRevisionNumber versionNumber = revisionDescriptors.hasRevisions() ? revisionDescriptors.getLatestRevision() : new NodeRevisionNumber();
            try {
                statement = connection.prepareStatement("SELECT 1 FROM VERSION_HISTORY vh, URI u WHERE vh.URI_ID = u.URI_ID and u.URI_STRING = ? and REVISION_NO = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, versionNumber.toString());
                res = statement.executeQuery();
                versionHistoryExists = res.next();
            }
            finally {
                this.close(statement, res);
            }
            if (!versionHistoryExists && revisionDescriptors.getLatestRevision() != null) {
                try {
                    statement = connection.prepareStatement("insert into VERSION_HISTORY (URI_ID, BRANCH_ID, REVISION_NO) select u.URI_ID, b.BRANCH_ID, ? from URI u, BRANCH b where u.URI_STRING = ? and b.BRANCH_STRING = ?");
                    statement.setString(1, this.getRevisionNumberAsString(versionNumber));
                    statement.setString(2, uri.toString());
                    statement.setString(3, "main");
                    statement.executeUpdate();
                }
                finally {
                    this.close(statement, res);
                }
            }
            Enumeration revisionNumbers = revisionDescriptors.enumerateRevisionNumbers();
            while (revisionNumbers.hasMoreElements()) {
                NodeRevisionNumber nodeRevisionNumber = (NodeRevisionNumber)revisionNumbers.nextElement();
                Enumeration successors = revisionDescriptors.getSuccessors(nodeRevisionNumber);
                while (successors.hasMoreElements()) {
                    try {
                        NodeRevisionNumber successor = (NodeRevisionNumber)successors.nextElement();
                        statement = connection.prepareStatement("insert into VERSION_PREDS (VERSION_ID, PREDECESSOR_ID)  select vr.VERSION_ID, suc.VERSION_ID FROM URI uri, VERSION_HISTORY  vr, VERSION_HISTORY suc  where vr.URI_ID = uri.URI_ID  and suc.URI_ID = uri.URI_ID  and uri.URI_STRING = ?  and vr.REVISION_NO = ?  and suc.REVISION_NO = ? ");
                        statement.setString(1, uri.toString());
                        statement.setString(2, nodeRevisionNumber.toString());
                        statement.setString(3, successor.toString());
                        statement.executeUpdate();
                    }
                    finally {
                        this.close(statement);
                    }
                }
            }
            this.getLogger().log((Object)(revisionDescriptors.getOriginalUri() + revisionDescriptors.getInitialRevision()), LOG_CHANNEL, 7);
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
    }

    public void createRevisionContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        if (!this.storeRevisionContent(connection, uri, revisionDescriptor, revisionContent, true)) {
            throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
        }
    }

    public void storeRevisionContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        if (!this.storeRevisionContent(connection, uri, revisionDescriptor, revisionContent, false)) {
            throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean storeRevisionContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent, boolean create) throws ServiceAccessException {
        try {
            ResultSet res;
            PreparedStatement statement;
            block9: {
                statement = null;
                res = null;
                try {
                    statement = connection.prepareStatement("select 1 from VERSION_CONTENT vc, VERSION_HISTORY vh, URI u where vc.VERSION_ID = vh.VERSION_ID and vh.URI_ID = u.URI_ID and u.URI_STRING = ? and vh.REVISION_NO = ?");
                    statement.setString(1, uri.toString());
                    statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
                    res = statement.executeQuery();
                    if (res.next()) {
                        if (create) {
                            boolean bl = false;
                            this.close(statement, res);
                            return bl;
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.close(statement, res);
                    throw throwable;
                }
                {
                    if (create) break block9;
                    boolean bl = false;
                    this.close(statement, res);
                    return bl;
                }
            }
            this.close(statement, res);
            if (!create) {
                this.removeRevisionContent(connection, uri, revisionDescriptor);
            }
            this.storeContent(connection, uri, revisionDescriptor, revisionContent);
            return true;
        }
        catch (SQLException e) {
            throw this.createException(e, uri.toString());
        }
        catch (IOException e) {
            this.getLogger().log((Object)e, LOG_CHANNEL, 2);
            throw new ServiceAccessException(this.service, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assureVersionInfo(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws SQLException {
        boolean versionHistoryExists;
        boolean revisionExists;
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            statement = connection.prepareStatement("select 1 from VERSION v, URI u where v.URI_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            res = statement.executeQuery();
            revisionExists = res.next();
            this.close(statement, res);
        }
        catch (Throwable throwable) {
            this.close(statement, res);
            throw throwable;
        }
        if (!revisionExists) {
            try {
                statement = connection.prepareStatement("insert into VERSION (URI_ID, IS_VERSIONED) select u.URI_ID, ? from URI u where u.URI_STRING = ?");
                statement.setInt(1, 0);
                statement.setString(2, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
        try {
            statement = connection.prepareStatement("select 1 from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ? and REVISION_NO = ?");
            statement.setString(1, uri.toString());
            statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
            res = statement.executeQuery();
            versionHistoryExists = res.next();
        }
        finally {
            this.close(statement, res);
        }
        if (!versionHistoryExists) {
            long branchId = this.assureBranchId(connection, revisionDescriptor.getBranchName());
            try {
                statement = connection.prepareStatement("insert into VERSION_HISTORY (URI_ID, BRANCH_ID, REVISION_NO) select u.URI_ID, ?, ? from URI u where u.URI_STRING = ?");
                statement.setLong(1, branchId);
                statement.setString(2, this.getRevisionNumberAsString(revisionDescriptor.getRevisionNumber()));
                statement.setString(3, uri.toString());
                statement.executeUpdate();
            }
            finally {
                this.close(statement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeContent(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException, SQLException {
        this.assureVersionInfo(connection, uri, revisionDescriptor);
        PreparedStatement statement = null;
        InputStream is = null;
        is = revisionContent.streamContent();
        if (is != null) {
            Object v1;
            long contentLength = 0L;
            if (this.bcompress) {
                this.getLogger().log((Object)"Compressing the data", LOG_CHANNEL, 7);
                StoreContentZip ziputil = new StoreContentZip();
                ziputil.Zip(is);
                is = ziputil.getInputStream();
                contentLength = ziputil.getContentLength();
            } else {
                contentLength = revisionDescriptor.getContentLength();
            }
            byte[] buffer = new byte[2048];
            File tempFile = null;
            if (contentLength == -1L) {
                try {
                    int nChar;
                    tempFile = File.createTempFile("content", null);
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    while ((nChar = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, nChar);
                    }
                    fos.close();
                    is.close();
                    is = new FileInputStream(tempFile);
                    contentLength = tempFile.length();
                }
                catch (IOException ex) {
                    this.getLogger().log((Object)(ex.toString() + " during the calculation of the content length."), LOG_CHANNEL, 2);
                    this.getLogger().log((Object)("tempFile: " + tempFile.getAbsolutePath()), LOG_CHANNEL, 2);
                    throw ex;
                }
            }
            try {
                statement = connection.prepareStatement("insert into VERSION_CONTENT (VERSION_ID, CONTENT) select vh.VERSION_ID, ? from VERSION_HISTORY vh, URI u where vh.URI_ID = u.URI_ID and u.URI_STRING = ? and vh.REVISION_NO = ?");
                statement.setBinaryStream(1, is, (int)contentLength);
                statement.setString(2, uri.toString());
                statement.setString(3, revisionDescriptor.getRevisionNumber().toString());
                statement.executeUpdate();
                if (tempFile != null) {
                    is.close();
                    is = null;
                    tempFile.delete();
                }
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var14_14 = null;
                try {
                    this.close(statement);
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    Object var16_18;
                    v0 = var16_18 = null;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {
                        this.logger.log((Object)"Could not close stream", (Throwable)ioe, LOG_CHANNEL, 7);
                    }
                }
                throw throwable;
            }
            try {
                this.close(statement);
                v1 = null;
            }
            catch (Throwable throwable) {
                Object var16_17;
                v1 = var16_17 = null;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    this.logger.log((Object)"Could not close stream", (Throwable)ioe, LOG_CHANNEL, 7);
                }
            }
        }
    }

    public void storeRevisionDescriptor(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.removeRevisionDescriptor(connection, uri, revisionDescriptor.getRevisionNumber());
        this.createRevisionDescriptor(connection, uri, revisionDescriptor);
    }

    public void storeRevisionDescriptors(Connection connection, Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.removeRevisionDescriptors(connection, uri);
        this.createRevisionDescriptors(connection, uri, revisionDescriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long assureUriId(Connection connection, String uri) throws SQLException {
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            statement = connection.prepareStatement("select URI_ID from URI where URI_STRING=?");
            statement.setString(1, uri);
            res = statement.executeQuery();
            if (res.next()) {
                long id;
                long l = id = res.getLong(1);
                this.close(statement, res);
                return l;
            }
            this.close(statement, res);
        }
        catch (Throwable throwable) {
            this.close(statement, res);
            throw throwable;
        }
        try {
            statement = connection.prepareStatement("insert into URI (URI_STRING) values (?)");
            statement.setString(1, uri);
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
        return this.assureUriId(connection, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long assureBranchId(Connection connection, String branch) throws SQLException {
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            statement = connection.prepareStatement("select BRANCH_ID from BRANCH where BRANCH_STRING=?");
            statement.setString(1, branch);
            res = statement.executeQuery();
            if (res.next()) {
                long id;
                long l = id = res.getLong(1);
                this.close(statement, res);
                return l;
            }
            this.close(statement, res);
        }
        catch (Throwable throwable) {
            this.close(statement, res);
            throw throwable;
        }
        try {
            statement = connection.prepareStatement("insert into BRANCH (BRANCH_STRING) values (?)");
            statement.setString(1, branch);
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
        return this.assureBranchId(connection, branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long assureLabelId(Connection connection, String label) throws SQLException {
        PreparedStatement statement = null;
        ResultSet res = null;
        try {
            statement = connection.prepareStatement("select LABEL_ID from LABEL where LABEL_STRING=?");
            statement.setString(1, label);
            res = statement.executeQuery();
            if (res.next()) {
                long id;
                long l = id = res.getLong(1);
                this.close(statement, res);
                return l;
            }
            this.close(statement, res);
        }
        catch (Throwable throwable) {
            this.close(statement, res);
            throw throwable;
        }
        try {
            statement = connection.prepareStatement("insert into LABEL (LABEL_STRING) values (?)");
            statement.setString(1, label);
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
        return this.assureLabelId(connection, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearBinding(Connection connection, Uri uri) throws ServiceAccessException, ObjectNotFoundException, SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete BINDING from BINDING c, URI u where c.URI_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
        try {
            statement = connection.prepareStatement("delete PARENT_BINDING from PARENT_BINDING c, URI u where c.URI_ID = u.URI_ID and u.URI_STRING = ?");
            statement.setString(1, uri.toString());
            statement.executeUpdate();
        }
        finally {
            this.close(statement);
        }
    }

    protected String getRevisionNumberAsString(NodeRevisionNumber revisionNumber) {
        return revisionNumber != null ? revisionNumber.toString() : null;
    }

    protected String convertRevisionNumberToComparable(String revisioNumber) {
        return "convert(numeric, SUBSTRING(" + revisioNumber + ",1,charindex('.'," + revisioNumber + "))), convert(numeric, SUBSTRING(" + revisioNumber + ",charindex('.'," + revisioNumber + ")+1,100))";
    }

    protected void close(PreparedStatement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().log((Object)e, LOG_CHANNEL, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void close(PreparedStatement statement, ResultSet resultSet) {
        block12: {
            block11: {
                if (resultSet == null) break block11;
                resultSet.close();
            }
            Object var5_3 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                break block12;
            }
            catch (SQLException e2) {
                this.getLogger().log((Object)e2, LOG_CHANNEL, 4);
            }
            break block12;
            {
                catch (SQLException e) {
                    this.getLogger().log((Object)e, LOG_CHANNEL, 4);
                    Object var5_4 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block12;
                    }
                    catch (SQLException e2) {
                        this.getLogger().log((Object)e2, LOG_CHANNEL, 4);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e2) {
                    this.getLogger().log((Object)e2, LOG_CHANNEL, 4);
                }
                throw throwable;
            }
        }
    }

    protected ServiceAccessException createException(SQLException e, String uri) {
        this.getLogger().log((Object)("SQL error " + e.getErrorCode() + " on " + uri + ": " + e.getMessage()), LOG_CHANNEL, 2);
        return new ServiceAccessException(this.service, (Throwable)e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

